// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the associations between a service network and a VPC endpoint.
func (c *Client) ListServiceNetworkVpcEndpointAssociations(ctx context.Context, params *ListServiceNetworkVpcEndpointAssociationsInput, optFns ...func(*Options)) (*ListServiceNetworkVpcEndpointAssociationsOutput, error) {
	if params == nil {
		params = &ListServiceNetworkVpcEndpointAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceNetworkVpcEndpointAssociations", params, optFns, c.addOperationListServiceNetworkVpcEndpointAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceNetworkVpcEndpointAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceNetworkVpcEndpointAssociationsInput struct {

	// The ID of the service network associated with the VPC endpoint.
	//
	// This member is required.
	ServiceNetworkIdentifier *string

	// The maximum page size.
	MaxResults *int32

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServiceNetworkVpcEndpointAssociationsOutput struct {

	// Information about the association between the VPC endpoint and service network.
	//
	// This member is required.
	Items []types.ServiceNetworkEndpointAssociation

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceNetworkVpcEndpointAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceNetworkVpcEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceNetworkVpcEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceNetworkVpcEndpointAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListServiceNetworkVpcEndpointAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceNetworkVpcEndpointAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServiceNetworkVpcEndpointAssociationsPaginatorOptions is the paginator
// options for ListServiceNetworkVpcEndpointAssociations
type ListServiceNetworkVpcEndpointAssociationsPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceNetworkVpcEndpointAssociationsPaginator is a paginator for
// ListServiceNetworkVpcEndpointAssociations
type ListServiceNetworkVpcEndpointAssociationsPaginator struct {
	options   ListServiceNetworkVpcEndpointAssociationsPaginatorOptions
	client    ListServiceNetworkVpcEndpointAssociationsAPIClient
	params    *ListServiceNetworkVpcEndpointAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListServiceNetworkVpcEndpointAssociationsPaginator returns a new
// ListServiceNetworkVpcEndpointAssociationsPaginator
func NewListServiceNetworkVpcEndpointAssociationsPaginator(client ListServiceNetworkVpcEndpointAssociationsAPIClient, params *ListServiceNetworkVpcEndpointAssociationsInput, optFns ...func(*ListServiceNetworkVpcEndpointAssociationsPaginatorOptions)) *ListServiceNetworkVpcEndpointAssociationsPaginator {
	if params == nil {
		params = &ListServiceNetworkVpcEndpointAssociationsInput{}
	}

	options := ListServiceNetworkVpcEndpointAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceNetworkVpcEndpointAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceNetworkVpcEndpointAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceNetworkVpcEndpointAssociations page.
func (p *ListServiceNetworkVpcEndpointAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceNetworkVpcEndpointAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceNetworkVpcEndpointAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceNetworkVpcEndpointAssociationsAPIClient is a client that implements
// the ListServiceNetworkVpcEndpointAssociations operation.
type ListServiceNetworkVpcEndpointAssociationsAPIClient interface {
	ListServiceNetworkVpcEndpointAssociations(context.Context, *ListServiceNetworkVpcEndpointAssociationsInput, ...func(*Options)) (*ListServiceNetworkVpcEndpointAssociationsOutput, error)
}

var _ ListServiceNetworkVpcEndpointAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceNetworkVpcEndpointAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceNetworkVpcEndpointAssociations",
	}
}
