// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Send a WhatsApp message. For examples of sending a message using the Amazon Web
// Services CLI, see [Sending messages]in the Amazon Web Services End User Messaging Social User
// Guide .
//
// [Sending messages]: https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html
func (c *Client) SendWhatsAppMessage(ctx context.Context, params *SendWhatsAppMessageInput, optFns ...func(*Options)) (*SendWhatsAppMessageOutput, error) {
	if params == nil {
		params = &SendWhatsAppMessageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SendWhatsAppMessage", params, optFns, c.addOperationSendWhatsAppMessageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SendWhatsAppMessageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SendWhatsAppMessageInput struct {

	// The message to send through WhatsApp. The length is in KB. The message field
	// passes through a WhatsApp Message object, see [Messages]in the WhatsApp Business Platform
	// Cloud API Reference.
	//
	// [Messages]: https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages
	//
	// This member is required.
	Message []byte

	// The API version for the request formatted as v{VersionNumber} . For a list of
	// supported API versions and Amazon Web Services Regions, see [Amazon Web Services End User Messaging Social API Service Endpoints]in the Amazon Web
	// Services General Reference.
	//
	// [Amazon Web Services End User Messaging Social API Service Endpoints]: https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html
	//
	// This member is required.
	MetaApiVersion *string

	// The ID of the phone number used to send the WhatsApp message. If you are
	// sending a media file only the originationPhoneNumberId used to upload the file
	// can be used. Phone number identifiers are formatted as
	// phone-number-id-01234567890123456789012345678901 . Use [GetLinkedWhatsAppBusinessAccount] to find a phone
	// number's id.
	//
	// [GetLinkedWhatsAppBusinessAccount]: https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html
	//
	// This member is required.
	OriginationPhoneNumberId *string

	noSmithyDocumentSerde
}

type SendWhatsAppMessageOutput struct {

	// The unique identifier of the message.
	MessageId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSendWhatsAppMessageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSendWhatsAppMessage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSendWhatsAppMessage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SendWhatsAppMessage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSendWhatsAppMessageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSendWhatsAppMessage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSendWhatsAppMessage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SendWhatsAppMessage",
	}
}
