// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// A list of lineage groups shared with your Amazon Web Services account. For more
// information, see [Cross-Account Lineage Tracking]in the Amazon SageMaker Developer Guide.
//
// [Cross-Account Lineage Tracking]: https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html
func (c *Client) ListLineageGroups(ctx context.Context, params *ListLineageGroupsInput, optFns ...func(*Options)) (*ListLineageGroupsOutput, error) {
	if params == nil {
		params = &ListLineageGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLineageGroups", params, optFns, c.addOperationListLineageGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLineageGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLineageGroupsInput struct {

	// A timestamp to filter against lineage groups created after a certain point in
	// time.
	CreatedAfter *time.Time

	// A timestamp to filter against lineage groups created before a certain point in
	// time.
	CreatedBefore *time.Time

	// The maximum number of endpoints to return in the response. This value defaults
	// to 10.
	MaxResults *int32

	// If the response is truncated, SageMaker returns this token. To retrieve the
	// next set of algorithms, use it in the subsequent request.
	NextToken *string

	// The parameter by which to sort the results. The default is CreationTime .
	SortBy types.SortLineageGroupsBy

	// The sort order for the results. The default is Ascending .
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListLineageGroupsOutput struct {

	// A list of lineage groups and their properties.
	LineageGroupSummaries []types.LineageGroupSummary

	// If the response is truncated, SageMaker returns this token. To retrieve the
	// next set of algorithms, use it in the subsequent request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLineageGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListLineageGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListLineageGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLineageGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLineageGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListLineageGroupsPaginatorOptions is the paginator options for ListLineageGroups
type ListLineageGroupsPaginatorOptions struct {
	// The maximum number of endpoints to return in the response. This value defaults
	// to 10.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLineageGroupsPaginator is a paginator for ListLineageGroups
type ListLineageGroupsPaginator struct {
	options   ListLineageGroupsPaginatorOptions
	client    ListLineageGroupsAPIClient
	params    *ListLineageGroupsInput
	nextToken *string
	firstPage bool
}

// NewListLineageGroupsPaginator returns a new ListLineageGroupsPaginator
func NewListLineageGroupsPaginator(client ListLineageGroupsAPIClient, params *ListLineageGroupsInput, optFns ...func(*ListLineageGroupsPaginatorOptions)) *ListLineageGroupsPaginator {
	if params == nil {
		params = &ListLineageGroupsInput{}
	}

	options := ListLineageGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLineageGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLineageGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLineageGroups page.
func (p *ListLineageGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLineageGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLineageGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLineageGroupsAPIClient is a client that implements the ListLineageGroups
// operation.
type ListLineageGroupsAPIClient interface {
	ListLineageGroups(context.Context, *ListLineageGroupsInput, ...func(*Options)) (*ListLineageGroupsOutput, error)
}

var _ ListLineageGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLineageGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLineageGroups",
	}
}
