// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Reboots specific nodes within a SageMaker HyperPod cluster using a soft
// recovery mechanism. BatchRebootClusterNodes performs a graceful reboot of the
// specified nodes by calling the Amazon Elastic Compute Cloud RebootInstances
// API, which attempts to cleanly shut down the operating system before restarting
// the instance.
//
// This operation is useful for recovering from transient issues or applying
// certain configuration changes that require a restart.
//
//   - Rebooting a node may cause temporary service interruption for workloads
//     running on that node. Ensure your workloads can handle node restarts or use
//     appropriate scheduling to minimize impact.
//
//   - You can reboot up to 25 nodes in a single request.
//
//   - For SageMaker HyperPod clusters using the Slurm workload manager, ensure
//     rebooting nodes will not disrupt critical cluster operations.
func (c *Client) BatchRebootClusterNodes(ctx context.Context, params *BatchRebootClusterNodesInput, optFns ...func(*Options)) (*BatchRebootClusterNodesOutput, error) {
	if params == nil {
		params = &BatchRebootClusterNodesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchRebootClusterNodes", params, optFns, c.addOperationBatchRebootClusterNodesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchRebootClusterNodesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchRebootClusterNodesInput struct {

	// The name or Amazon Resource Name (ARN) of the SageMaker HyperPod cluster
	// containing the nodes to reboot.
	//
	// This member is required.
	ClusterName *string

	// A list of EC2 instance IDs to reboot using soft recovery. You can specify
	// between 1 and 25 instance IDs.
	//
	//   - Either NodeIds or NodeLogicalIds must be provided (or both), but at least
	//   one is required.
	//
	//   - Each instance ID must follow the pattern i- followed by 17 hexadecimal
	//   characters (for example, i-0123456789abcdef0 ).
	NodeIds []string

	// A list of logical node IDs to reboot using soft recovery. You can specify
	// between 1 and 25 logical node IDs.
	//
	// The NodeLogicalId is a unique identifier that persists throughout the node's
	// lifecycle and can be used to track nodes that are still being provisioned and
	// don't yet have an EC2 instance ID assigned.
	//
	//   - This parameter is only supported for clusters using Continuous as the
	//   NodeProvisioningMode . For clusters using the default provisioning mode, use
	//   NodeIds instead.
	//
	//   - Either NodeIds or NodeLogicalIds must be provided (or both), but at least
	//   one is required.
	NodeLogicalIds []string

	noSmithyDocumentSerde
}

type BatchRebootClusterNodesOutput struct {

	// A list of errors encountered for EC2 instance IDs that could not be rebooted.
	// Each error includes the instance ID, an error code, and a descriptive message.
	Failed []types.BatchRebootClusterNodesError

	// A list of errors encountered for logical node IDs that could not be rebooted.
	// Each error includes the logical node ID, an error code, and a descriptive
	// message. This field is only present when NodeLogicalIds were provided in the
	// request.
	FailedNodeLogicalIds []types.BatchRebootClusterNodeLogicalIdsError

	// A list of EC2 instance IDs for which the reboot operation was successfully
	// initiated.
	Successful []string

	// A list of logical node IDs for which the reboot operation was successfully
	// initiated. This field is only present when NodeLogicalIds were provided in the
	// request.
	SuccessfulNodeLogicalIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchRebootClusterNodesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpBatchRebootClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpBatchRebootClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchRebootClusterNodes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchRebootClusterNodesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchRebootClusterNodes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchRebootClusterNodes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchRebootClusterNodes",
	}
}
