// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds nodes to a HyperPod cluster by incrementing the target count for one or
// more instance groups. This operation returns a unique NodeLogicalId for each
// node being added, which can be used to track the provisioning status of the
// node. This API provides a safer alternative to UpdateCluster for scaling
// operations by avoiding unintended configuration changes.
//
// This API is only supported for clusters using Continuous as the
// NodeProvisioningMode .
func (c *Client) BatchAddClusterNodes(ctx context.Context, params *BatchAddClusterNodesInput, optFns ...func(*Options)) (*BatchAddClusterNodesOutput, error) {
	if params == nil {
		params = &BatchAddClusterNodesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchAddClusterNodes", params, optFns, c.addOperationBatchAddClusterNodesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchAddClusterNodesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchAddClusterNodesInput struct {

	// The name of the HyperPod cluster to which you want to add nodes.
	//
	// This member is required.
	ClusterName *string

	// A list of instance groups and the number of nodes to add to each. You can
	// specify up to 5 instance groups in a single request, with a maximum of 50 nodes
	// total across all instance groups.
	//
	// This member is required.
	NodesToAdd []types.AddClusterNodeSpecification

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. This token is valid for 8 hours. If you retry the request with
	// the same client token within this timeframe and the same parameters, the API
	// returns the same set of NodeLogicalIds with their latest status.
	ClientToken *string

	noSmithyDocumentSerde
}

type BatchAddClusterNodesOutput struct {

	// A list of errors that occurred during the node addition operation. Each entry
	// includes the instance group name, error code, number of failed additions, and an
	// error message.
	//
	// This member is required.
	Failed []types.BatchAddClusterNodesError

	// A list of NodeLogicalIDs that were successfully added to the cluster. The
	// NodeLogicalID is unique per cluster and does not change between instance
	// replacements. Each entry includes a NodeLogicalId that can be used to track the
	// node's provisioning status (with DescribeClusterNode ), the instance group name,
	// and the current status of the node.
	//
	// This member is required.
	Successful []types.NodeAdditionResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchAddClusterNodesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpBatchAddClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpBatchAddClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchAddClusterNodes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opBatchAddClusterNodesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpBatchAddClusterNodesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchAddClusterNodes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpBatchAddClusterNodes struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpBatchAddClusterNodes) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpBatchAddClusterNodes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*BatchAddClusterNodesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *BatchAddClusterNodesInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opBatchAddClusterNodesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpBatchAddClusterNodes{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opBatchAddClusterNodes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchAddClusterNodes",
	}
}
