// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a table bucket. For more information, see [Creating a table bucket] in the Amazon Simple Storage
// Service User Guide.
//
// Permissions
//
//   - You must have the s3tables:CreateTableBucket permission to use this
//     operation.
//
//   - If you use this operation with the optional encryptionConfiguration
//     parameter you must have the s3tables:PutTableBucketEncryption permission.
//
//   - If you use this operation with the storageClassConfiguration request
//     parameter, you must have the s3tables:PutTableBucketStorageClass permission.
//
//   - To create a table bucket with tags, you must have the s3tables:TagResource
//     permission in addition to s3tables:CreateTableBucket permission.
//
// [Creating a table bucket]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-create.html
func (c *Client) CreateTableBucket(ctx context.Context, params *CreateTableBucketInput, optFns ...func(*Options)) (*CreateTableBucketOutput, error) {
	if params == nil {
		params = &CreateTableBucketInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTableBucket", params, optFns, c.addOperationCreateTableBucketMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTableBucketOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTableBucketInput struct {

	// The name for the table bucket.
	//
	// This member is required.
	Name *string

	// The encryption configuration to use for the table bucket. This configuration
	// specifies the default encryption settings that will be applied to all tables
	// created in this bucket unless overridden at the table level. The configuration
	// includes the encryption algorithm and, if using SSE-KMS, the KMS key to use.
	EncryptionConfiguration *types.EncryptionConfiguration

	// The default storage class configuration for the table bucket. This
	// configuration will be applied to all new tables created in this bucket unless
	// overridden at the table level. If not specified, the service default storage
	// class will be used.
	StorageClassConfiguration *types.StorageClassConfiguration

	// A map of user-defined tags that you would like to apply to the table bucket
	// that you are creating. A tag is a key-value pair that you apply to your
	// resources. Tags can help you organize and control access to resources. For more
	// information, see [Tagging for cost allocation or attribute-based access control (ABAC)].
	//
	// You must have the s3tables:TagResource permission in addition to
	// s3tables:CreateTableBucket permisson to create a table bucket with tags.
	//
	// [Tagging for cost allocation or attribute-based access control (ABAC)]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateTableBucketOutput struct {

	// The Amazon Resource Name (ARN) of the table bucket.
	//
	// This member is required.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTableBucketMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateTableBucket{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateTableBucket{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTableBucket"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTableBucketValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTableBucket(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTableBucket(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTableBucket",
	}
}
