// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of a DNS firewall rule.
func (c *Client) UpdateFirewallRule(ctx context.Context, params *UpdateFirewallRuleInput, optFns ...func(*Options)) (*UpdateFirewallRuleOutput, error) {
	if params == nil {
		params = &UpdateFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFirewallRule", params, optFns, c.addOperationUpdateFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFirewallRuleInput struct {

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	//
	// This member is required.
	ClientToken *string

	// The ID of the DNS Firewall rule.
	//
	// This member is required.
	FirewallRuleId *string

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list, or a threat in a DNS Firewall Advanced
	// rule.
	Action types.FirewallRuleAction

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideTtl *int32

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK .
	BlockResponse types.FirewallBlockResponse

	// The confidence threshold for DNS Firewall Advanced. You must provide this value
	// when you create a DNS Firewall Advanced rule.
	ConfidenceThreshold types.ConfidenceThreshold

	// The description for the Firewall rule.
	Description *string

	// The type of the DNS Firewall Advanced rule. Valid values are DGA and
	// DNS_TUNNELING.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The name of the DNS Firewall rule.
	Name *string

	// The setting that determines the processing order of the rule in the rule group.
	// DNS Firewall processes the rules in a rule group by order of priority, starting
	// from the lowest setting.
	Priority *int64

	noSmithyDocumentSerde
}

type UpdateFirewallRuleOutput struct {

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list, or a threat in a DNS Firewall Advanced
	// rule.
	//
	// This member is required.
	Action types.FirewallRuleAction

	// The time and date the Firewall rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view the Firewall rule is associated with.
	//
	// This member is required.
	DnsViewId *string

	// The ID of the Firewall rule.
	//
	// This member is required.
	Id *string

	// The name of the Firewall rule.
	//
	// This member is required.
	Name *string

	// The setting that determines the processing order of the rule in the rule group.
	// DNS Firewall processes the rules in a rule group by order of priority, starting
	// from the lowest setting.
	//
	// This member is required.
	Priority *int64

	// The operational status of the firewall rule.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The time and date the rule was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideTtl *int32

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK .
	BlockResponse types.FirewallBlockResponse

	// The confidence threshold for DNS Firewall Advanced. You must provide this value
	// when you create a DNS Firewall Advanced rule.
	ConfidenceThreshold types.ConfidenceThreshold

	// The description of the Firewall rule.
	Description *string

	// The type of the DNS Firewall Advanced rule. Valid values are DGA and
	// DNS_TUNNELING.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The ID of the domain list associated with the Firewall rule.
	FirewallDomainListId *string

	// The DNS query type you want the rule to evaluate.
	QueryType *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateFirewallRuleMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateFirewallRule struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateFirewallRule) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateFirewallRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateFirewallRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateFirewallRuleInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateFirewallRuleMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateFirewallRule{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateFirewallRule",
	}
}
