// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver
// resource.
func (c *Client) DisassociateHostedZone(ctx context.Context, params *DisassociateHostedZoneInput, optFns ...func(*Options)) (*DisassociateHostedZoneOutput, error) {
	if params == nil {
		params = &DisassociateHostedZoneInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateHostedZone", params, optFns, c.addOperationDisassociateHostedZoneMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateHostedZoneOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateHostedZoneInput struct {

	// The ID of the Route 53 private hosted zone to disassociate.
	//
	// This member is required.
	HostedZoneId *string

	// The Amazon Resource Name (ARN) of the Route 53 Global Resolver resource to
	// disassociate the hosted zone from.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

type DisassociateHostedZoneOutput struct {

	// The date and time when the association was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the Route 53 private hosted zone that was disassociated.
	//
	// This member is required.
	HostedZoneId *string

	// The name of the Route 53 private hosted zone that was disassociated.
	//
	// This member is required.
	HostedZoneName *string

	// The unique identifier of the disassociation.
	//
	// This member is required.
	Id *string

	// The name of the association that was removed.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the Route 53 Global Resolver resource that
	// the hosted zone was disassociated from.
	//
	// This member is required.
	ResourceArn *string

	// The final status of the disassociation.
	//
	// This member is required.
	Status types.HostedZoneAssociationStatus

	// The date and time when the association was last updated before disassociation.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateHostedZoneMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDisassociateHostedZone{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDisassociateHostedZone{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateHostedZone"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateHostedZoneValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateHostedZone(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisassociateHostedZone(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateHostedZone",
	}
}
