// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes a Route 53 Global Resolver instance. This operation cannot be undone.
// All associated DNS views, access sources, tokens, and firewall rules are also
// deleted.
func (c *Client) DeleteGlobalResolver(ctx context.Context, params *DeleteGlobalResolverInput, optFns ...func(*Options)) (*DeleteGlobalResolverOutput, error) {
	if params == nil {
		params = &DeleteGlobalResolverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteGlobalResolver", params, optFns, c.addOperationDeleteGlobalResolverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteGlobalResolverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteGlobalResolverInput struct {

	// The unique identifier of the Route 53 Global Resolver to delete.
	//
	// This member is required.
	GlobalResolverId *string

	noSmithyDocumentSerde
}

type DeleteGlobalResolverOutput struct {

	// The Amazon Resource Name (ARN) of the deleted Route 53 Global Resolver.
	//
	// This member is required.
	Arn *string

	// The unique string that identifies the request and ensures idempotency.
	//
	// This member is required.
	ClientToken *string

	// The date and time when the Route 53 Global Resolver was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The hostname that DNS clients used for TLS certificate validation when
	// connecting to the deleted Route 53 Global Resolver.
	//
	// This member is required.
	DnsName *string

	// The unique identifier of the deleted Route 53 Global Resolver.
	//
	// This member is required.
	Id *string

	// The global anycast IPv4 addresses that were associated with the deleted Route
	// 53 Global Resolver.
	//
	// This member is required.
	Ipv4Addresses []string

	// The name of the deleted Route 53 Global Resolver.
	//
	// This member is required.
	Name *string

	// The AWS Regions where the deleted Route 53 Global Resolver was deployed and
	// operational.
	//
	// This member is required.
	Regions []string

	// The final status of the deleted Route 53 Global Resolver.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the Route 53 Global Resolver was last updated before
	// deletion.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the deleted Route 53 Global Resolver.
	Description *string

	// The AWS Region where observability data for the deleted Route 53 Global
	// Resolver was stored.
	ObservabilityRegion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteGlobalResolverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteGlobalResolver"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteGlobalResolverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteGlobalResolver(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteGlobalResolver(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteGlobalResolver",
	}
}
