// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes a DNS firewall rule. This operation cannot be undone.
func (c *Client) DeleteFirewallRule(ctx context.Context, params *DeleteFirewallRuleInput, optFns ...func(*Options)) (*DeleteFirewallRuleOutput, error) {
	if params == nil {
		params = &DeleteFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteFirewallRule", params, optFns, c.addOperationDeleteFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteFirewallRuleInput struct {

	// The unique identifier of the firewall rule to delete.
	//
	// This member is required.
	FirewallRuleId *string

	noSmithyDocumentSerde
}

type DeleteFirewallRuleOutput struct {

	// The action that was configured for the deleted firewall rule.
	//
	// This member is required.
	Action types.FirewallRuleAction

	// The date and time when the firewall rule was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view that was associated with the deleted firewall rule.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier of the deleted firewall rule.
	//
	// This member is required.
	Id *string

	// The name of the deleted firewall rule.
	//
	// This member is required.
	Name *string

	// The priority that was configured for the deleted firewall rule.
	//
	// This member is required.
	Priority *int64

	// The final status of the deleted firewall rule.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the firewall rule was last updated before deletion.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The DNS record type that was configured for the deleted firewall rule's custom
	// response.
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom domain that was configured for the deleted firewall rule's BLOCK
	// response.
	BlockOverrideDomain *string

	// The TTL value that was configured for the deleted firewall rule's custom
	// response.
	BlockOverrideTtl *int32

	// The block response type that was configured for the deleted firewall rule.
	BlockResponse types.FirewallBlockResponse

	// The confidence threshold that was configured for the deleted firewall rule's
	// advanced threat detection.
	ConfidenceThreshold types.ConfidenceThreshold

	// The description of the deleted firewall rule.
	Description *string

	// Whether advanced DNS threat protection was enabled for the deleted firewall
	// rule.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The ID of the firewall domain list that was associated with the deleted
	// firewall rule.
	FirewallDomainListId *string

	// The DNS query type that the deleted firewall rule was configured to match.
	QueryType *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteFirewallRule",
	}
}
