// Code generated by smithy-go-codegen DO NOT EDIT.

package resourceexplorer2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourceexplorer2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the status and details of a Resource Explorer setup operation. This
// operation returns information about the progress of creating or deleting
// Resource Explorer configurations across Regions.
func (c *Client) GetResourceExplorerSetup(ctx context.Context, params *GetResourceExplorerSetupInput, optFns ...func(*Options)) (*GetResourceExplorerSetupOutput, error) {
	if params == nil {
		params = &GetResourceExplorerSetupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceExplorerSetup", params, optFns, c.addOperationGetResourceExplorerSetupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceExplorerSetupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceExplorerSetupInput struct {

	// The unique identifier of the setup task to retrieve status information for.
	// This ID is returned by CreateResourceExplorerSetup or
	// DeleteResourceExplorerSetup operations.
	//
	// This member is required.
	TaskId *string

	// The maximum number of Region status results to return in a single response.
	// Valid values are between 1 and 100 .
	MaxResults *int32

	// The pagination token from a previous GetResourceExplorerSetup response. Use
	// this token to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetResourceExplorerSetupOutput struct {

	// The pagination token to use in a subsequent GetResourceExplorerSetup request to
	// retrieve the next set of results.
	NextToken *string

	// A list of Region status objects that describe the current state of Resource
	// Explorer configuration in each Region.
	Regions []types.RegionStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceExplorerSetupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetResourceExplorerSetup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetResourceExplorerSetup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetResourceExplorerSetup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetResourceExplorerSetupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceExplorerSetup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetResourceExplorerSetupPaginatorOptions is the paginator options for
// GetResourceExplorerSetup
type GetResourceExplorerSetupPaginatorOptions struct {
	// The maximum number of Region status results to return in a single response.
	// Valid values are between 1 and 100 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetResourceExplorerSetupPaginator is a paginator for GetResourceExplorerSetup
type GetResourceExplorerSetupPaginator struct {
	options   GetResourceExplorerSetupPaginatorOptions
	client    GetResourceExplorerSetupAPIClient
	params    *GetResourceExplorerSetupInput
	nextToken *string
	firstPage bool
}

// NewGetResourceExplorerSetupPaginator returns a new
// GetResourceExplorerSetupPaginator
func NewGetResourceExplorerSetupPaginator(client GetResourceExplorerSetupAPIClient, params *GetResourceExplorerSetupInput, optFns ...func(*GetResourceExplorerSetupPaginatorOptions)) *GetResourceExplorerSetupPaginator {
	if params == nil {
		params = &GetResourceExplorerSetupInput{}
	}

	options := GetResourceExplorerSetupPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetResourceExplorerSetupPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetResourceExplorerSetupPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetResourceExplorerSetup page.
func (p *GetResourceExplorerSetupPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetResourceExplorerSetupOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetResourceExplorerSetup(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetResourceExplorerSetupAPIClient is a client that implements the
// GetResourceExplorerSetup operation.
type GetResourceExplorerSetupAPIClient interface {
	GetResourceExplorerSetup(context.Context, *GetResourceExplorerSetupInput, ...func(*Options)) (*GetResourceExplorerSetupOutput, error)
}

var _ GetResourceExplorerSetupAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetResourceExplorerSetup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetResourceExplorerSetup",
	}
}
