// Code generated by smithy-go-codegen DO NOT EDIT.

package repostspace

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/repostspace/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Remove a role from multiple users or groups in a private re:Post channel.
func (c *Client) BatchRemoveChannelRoleFromAccessors(ctx context.Context, params *BatchRemoveChannelRoleFromAccessorsInput, optFns ...func(*Options)) (*BatchRemoveChannelRoleFromAccessorsOutput, error) {
	if params == nil {
		params = &BatchRemoveChannelRoleFromAccessorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchRemoveChannelRoleFromAccessors", params, optFns, c.addOperationBatchRemoveChannelRoleFromAccessorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchRemoveChannelRoleFromAccessorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchRemoveChannelRoleFromAccessorsInput struct {

	// The users or groups identifiers to remove the role from.
	//
	// This member is required.
	AccessorIds []string

	// The unique ID of the private re:Post channel.
	//
	// This member is required.
	ChannelId *string

	// The channel role to remove from the users or groups.
	//
	// This member is required.
	ChannelRole types.ChannelRole

	// The unique ID of the private re:Post.
	//
	// This member is required.
	SpaceId *string

	noSmithyDocumentSerde
}

type BatchRemoveChannelRoleFromAccessorsOutput struct {

	// An array of errors that occurred when roles were removed.
	//
	// This member is required.
	Errors []types.BatchError

	// An array of successfully updated identifiers.
	//
	// This member is required.
	RemovedAccessorIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchRemoveChannelRoleFromAccessorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchRemoveChannelRoleFromAccessors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchRemoveChannelRoleFromAccessors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchRemoveChannelRoleFromAccessors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchRemoveChannelRoleFromAccessorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchRemoveChannelRoleFromAccessors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchRemoveChannelRoleFromAccessors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchRemoveChannelRoleFromAccessors",
	}
}
