// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the resource permissions for a theme. Permissions apply to the action
// to grant or revoke permissions on, for example "quicksight:DescribeTheme" .
//
// Theme permissions apply in groupings. Valid groupings include the following for
// the three levels of permissions, which are user, owner, or no permissions:
//
//   - User
//
//   - "quicksight:DescribeTheme"
//
//   - "quicksight:DescribeThemeAlias"
//
//   - "quicksight:ListThemeAliases"
//
//   - "quicksight:ListThemeVersions"
//
//   - Owner
//
//   - "quicksight:DescribeTheme"
//
//   - "quicksight:DescribeThemeAlias"
//
//   - "quicksight:ListThemeAliases"
//
//   - "quicksight:ListThemeVersions"
//
//   - "quicksight:DeleteTheme"
//
//   - "quicksight:UpdateTheme"
//
//   - "quicksight:CreateThemeAlias"
//
//   - "quicksight:DeleteThemeAlias"
//
//   - "quicksight:UpdateThemeAlias"
//
//   - "quicksight:UpdateThemePermissions"
//
//   - "quicksight:DescribeThemePermissions"
//
//   - To specify no permissions, omit the permissions list.
func (c *Client) UpdateThemePermissions(ctx context.Context, params *UpdateThemePermissionsInput, optFns ...func(*Options)) (*UpdateThemePermissionsOutput, error) {
	if params == nil {
		params = &UpdateThemePermissionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateThemePermissions", params, optFns, c.addOperationUpdateThemePermissionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateThemePermissionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateThemePermissionsInput struct {

	// The ID of the Amazon Web Services account that contains the theme.
	//
	// This member is required.
	AwsAccountId *string

	// The ID for the theme.
	//
	// This member is required.
	ThemeId *string

	// A list of resource permissions to be granted for the theme.
	GrantPermissions []types.ResourcePermission

	// A list of resource permissions to be revoked from the theme.
	RevokePermissions []types.ResourcePermission

	noSmithyDocumentSerde
}

type UpdateThemePermissionsOutput struct {

	// The resulting list of resource permissions for the theme.
	Permissions []types.ResourcePermission

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// The Amazon Resource Name (ARN) of the theme.
	ThemeArn *string

	// The ID for the theme.
	ThemeId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateThemePermissionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateThemePermissions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateThemePermissions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateThemePermissions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateThemePermissionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateThemePermissions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateThemePermissions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateThemePermissions",
	}
}
