// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for relevant content in a Amazon Q Business application based on a
// query. This operation takes a search query text, the Amazon Q Business
// application identifier, and optional filters (such as content source and maximum
// results) as input. It returns a list of relevant content items, where each item
// includes the content text, the unique document identifier, the document title,
// the document URI, any relevant document attributes, and score attributes
// indicating the confidence level of the relevance.
func (c *Client) SearchRelevantContent(ctx context.Context, params *SearchRelevantContentInput, optFns ...func(*Options)) (*SearchRelevantContentOutput, error) {
	if params == nil {
		params = &SearchRelevantContentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchRelevantContent", params, optFns, c.addOperationSearchRelevantContentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchRelevantContentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchRelevantContentInput struct {

	// The unique identifier of the Amazon Q Business application to search.
	//
	// This member is required.
	ApplicationId *string

	// The source of content to search in.
	//
	// This member is required.
	ContentSource types.ContentSource

	// The text to search for.
	//
	// This member is required.
	QueryText *string

	// Enables filtering of responses based on document attributes or metadata fields.
	AttributeFilter *types.AttributeFilter

	// The maximum number of results to return.
	MaxResults *int32

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string

	noSmithyDocumentSerde
}

type SearchRelevantContentOutput struct {

	// The token to use to retrieve the next set of results, if there are any.
	NextToken *string

	// The list of relevant content items found.
	RelevantContent []types.RelevantContent

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchRelevantContentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchRelevantContent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchRelevantContent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchRelevantContent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchRelevantContentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchRelevantContent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchRelevantContentPaginatorOptions is the paginator options for
// SearchRelevantContent
type SearchRelevantContentPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchRelevantContentPaginator is a paginator for SearchRelevantContent
type SearchRelevantContentPaginator struct {
	options   SearchRelevantContentPaginatorOptions
	client    SearchRelevantContentAPIClient
	params    *SearchRelevantContentInput
	nextToken *string
	firstPage bool
}

// NewSearchRelevantContentPaginator returns a new SearchRelevantContentPaginator
func NewSearchRelevantContentPaginator(client SearchRelevantContentAPIClient, params *SearchRelevantContentInput, optFns ...func(*SearchRelevantContentPaginatorOptions)) *SearchRelevantContentPaginator {
	if params == nil {
		params = &SearchRelevantContentInput{}
	}

	options := SearchRelevantContentPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchRelevantContentPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchRelevantContentPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchRelevantContent page.
func (p *SearchRelevantContentPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchRelevantContentOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchRelevantContent(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchRelevantContentAPIClient is a client that implements the
// SearchRelevantContent operation.
type SearchRelevantContentAPIClient interface {
	SearchRelevantContent(context.Context, *SearchRelevantContentInput, ...func(*Options)) (*SearchRelevantContentOutput, error)
}

var _ SearchRelevantContentAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchRelevantContent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchRelevantContent",
	}
}
