// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of all chat response configurations available in a specified
// Amazon Q Business application. This operation returns summary information about
// each configuration to help administrators manage and select appropriate response
// settings.
func (c *Client) ListChatResponseConfigurations(ctx context.Context, params *ListChatResponseConfigurationsInput, optFns ...func(*Options)) (*ListChatResponseConfigurationsOutput, error) {
	if params == nil {
		params = &ListChatResponseConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChatResponseConfigurations", params, optFns, c.addOperationListChatResponseConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChatResponseConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChatResponseConfigurationsInput struct {

	// The unique identifier of the Amazon Q Business application for which to list
	// available chat response configurations.
	//
	// This member is required.
	ApplicationId *string

	// The maximum number of chat response configurations to return in a single
	// response. This parameter helps control pagination of results when many
	// configurations exist.
	MaxResults *int32

	// A pagination token used to retrieve the next set of results when the number of
	// configurations exceeds the specified maxResults value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListChatResponseConfigurationsOutput struct {

	// A list of chat response configuration summaries, each containing key
	// information about an available configuration in the specified application.
	ChatResponseConfigurations []types.ChatResponseConfiguration

	// A pagination token that can be used in a subsequent request to retrieve
	// additional chat response configurations if the results were truncated due to the
	// maxResults parameter.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChatResponseConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChatResponseConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChatResponseConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListChatResponseConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListChatResponseConfigurationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChatResponseConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChatResponseConfigurationsPaginatorOptions is the paginator options for
// ListChatResponseConfigurations
type ListChatResponseConfigurationsPaginatorOptions struct {
	// The maximum number of chat response configurations to return in a single
	// response. This parameter helps control pagination of results when many
	// configurations exist.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChatResponseConfigurationsPaginator is a paginator for
// ListChatResponseConfigurations
type ListChatResponseConfigurationsPaginator struct {
	options   ListChatResponseConfigurationsPaginatorOptions
	client    ListChatResponseConfigurationsAPIClient
	params    *ListChatResponseConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListChatResponseConfigurationsPaginator returns a new
// ListChatResponseConfigurationsPaginator
func NewListChatResponseConfigurationsPaginator(client ListChatResponseConfigurationsAPIClient, params *ListChatResponseConfigurationsInput, optFns ...func(*ListChatResponseConfigurationsPaginatorOptions)) *ListChatResponseConfigurationsPaginator {
	if params == nil {
		params = &ListChatResponseConfigurationsInput{}
	}

	options := ListChatResponseConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChatResponseConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChatResponseConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChatResponseConfigurations page.
func (p *ListChatResponseConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChatResponseConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListChatResponseConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListChatResponseConfigurationsAPIClient is a client that implements the
// ListChatResponseConfigurations operation.
type ListChatResponseConfigurationsAPIClient interface {
	ListChatResponseConfigurations(context.Context, *ListChatResponseConfigurationsInput, ...func(*Options)) (*ListChatResponseConfigurationsOutput, error)
}

var _ ListChatResponseConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListChatResponseConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListChatResponseConfigurations",
	}
}
