// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This action creates an opportunity from an existing engagement context. The
// task is asynchronous and orchestrates the process of converting engagement
// contextual information into a structured opportunity record within the partner's
// account.
func (c *Client) StartOpportunityFromEngagementTask(ctx context.Context, params *StartOpportunityFromEngagementTaskInput, optFns ...func(*Options)) (*StartOpportunityFromEngagementTaskOutput, error) {
	if params == nil {
		params = &StartOpportunityFromEngagementTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartOpportunityFromEngagementTask", params, optFns, c.addOperationStartOpportunityFromEngagementTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartOpportunityFromEngagementTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartOpportunityFromEngagementTaskInput struct {

	// Specifies the catalog in which the opportunity creation task is executed.
	// Acceptable values include AWS for production and Sandbox for testing
	// environments.
	//
	// This member is required.
	Catalog *string

	// A unique token provided by the client to help ensure the idempotency of the
	// request. It helps prevent the same task from being performed multiple times.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the engagement context from which to create the
	// opportunity. This specifies the specific contextual information within the
	// engagement that will be used for opportunity creation.
	//
	// This member is required.
	ContextIdentifier *string

	// The unique identifier of the engagement from which the opportunity creation
	// task is to be initiated. This helps ensure that the task is applied to the
	// correct engagement.
	//
	// This member is required.
	Identifier *string

	// A map of the key-value pairs of the tag or tags to assign.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type StartOpportunityFromEngagementTaskOutput struct {

	// The unique identifier of the engagement context used to create the opportunity.
	ContextId *string

	// The unique identifier of the engagement from which the opportunity was created.
	EngagementId *string

	// If the task fails, this field contains a detailed message describing the
	// failure and possible recovery steps.
	Message *string

	// The unique identifier of the opportunity created as a result of the task. This
	// field is populated when the task is completed successfully.
	OpportunityId *string

	// Indicates the reason for task failure using an enumerated code.
	ReasonCode types.ReasonCode

	// The identifier of the resource snapshot job created as part of the opportunity
	// creation process.
	ResourceSnapshotJobId *string

	// The timestamp indicating when the task was initiated. The format follows RFC
	// 3339 section 5.6.
	StartTime *time.Time

	// The Amazon Resource Name (ARN) of the task, used for tracking and managing the
	// task within AWS.
	TaskArn *string

	// The unique identifier of the task, used to track the task's progress.
	TaskId *string

	// Indicates the current status of the task.
	TaskStatus types.TaskStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartOpportunityFromEngagementTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartOpportunityFromEngagementTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartOpportunityFromEngagementTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartOpportunityFromEngagementTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartOpportunityFromEngagementTaskMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartOpportunityFromEngagementTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartOpportunityFromEngagementTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartOpportunityFromEngagementTask struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartOpportunityFromEngagementTask) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartOpportunityFromEngagementTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartOpportunityFromEngagementTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartOpportunityFromEngagementTaskInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartOpportunityFromEngagementTaskMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartOpportunityFromEngagementTask{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartOpportunityFromEngagementTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartOpportunityFromEngagementTask",
	}
}
