// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This request accepts a list of filters that retrieve opportunity subsets as
// well as sort options. This feature is available to partners from [Partner Central]using the
// ListOpportunities API action.
//
// To synchronize your system with Amazon Web Services, list only the
// opportunities that were newly created or updated. We recommend you rely on
// events emitted by the service into your Amazon Web Services account’s Amazon
// EventBridge default event bus. You can also use the ListOpportunities action.
//
// We recommend the following approach:
//
//   - Find the latest LastModifiedDate that you stored, and only use the values
//     that came from Amazon Web Services. Don’t use values generated by your system.
//
//   - When you send a ListOpportunities request, submit the date in ISO 8601
//     format in the AfterLastModifiedDate filter.
//
//   - Amazon Web Services only returns opportunities created or updated on or
//     after that date and time. Use NextToken to iterate over all pages.
//
// [Partner Central]: https://partnercentral.awspartner.com/
func (c *Client) ListOpportunities(ctx context.Context, params *ListOpportunitiesInput, optFns ...func(*Options)) (*ListOpportunitiesOutput, error) {
	if params == nil {
		params = &ListOpportunitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOpportunities", params, optFns, c.addOperationListOpportunitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOpportunitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOpportunitiesInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunities are listed in. Use AWS for listing real
	// opportunities in the Amazon Web Services catalog, and Sandbox for testing in
	// secure, isolated environments.
	//
	// This member is required.
	Catalog *string

	// Filters the opportunities based on the customer's company name. This allows
	// partners to search for opportunities associated with a specific customer by
	// matching the provided company name string.
	CustomerCompanyName []string

	// Filters the opportunities based on the opportunity identifier. This allows
	// partners to retrieve specific opportunities by providing their unique
	// identifiers, ensuring precise results.
	Identifier []string

	// Filters the opportunities based on their last modified date. This filter helps
	// retrieve opportunities that were updated after the specified date, allowing
	// partners to track recent changes or updates.
	LastModifiedDate *types.LastModifiedDate

	// Filters the opportunities based on their current lifecycle approval status. Use
	// this filter to retrieve opportunities with statuses such as Pending Submission ,
	// In Review , Action Required , or Approved .
	LifeCycleReviewStatus []types.ReviewStatus

	// Filters the opportunities based on their lifecycle stage. This filter allows
	// partners to retrieve opportunities at various stages in the sales cycle, such as
	// Qualified , Technical Validation , Business Validation , or Closed Won .
	LifeCycleStage []types.Stage

	// Specifies the maximum number of results to return in a single call. This limits
	// the number of opportunities returned in the response to avoid providing too many
	// results at once.
	//
	// Default: 20
	MaxResults *int32

	// A pagination token used to retrieve the next set of results in subsequent
	// calls. This token is included in the response only if there are additional
	// result pages available.
	NextToken *string

	// An object that specifies how the response is sorted. The default Sort.SortBy
	// value is LastModifiedDate .
	Sort *types.OpportunitySort

	noSmithyDocumentSerde
}

type ListOpportunitiesOutput struct {

	// An array that contains minimal details for opportunities that match the request
	// criteria. This summary view provides a quick overview of relevant opportunities.
	//
	// This member is required.
	OpportunitySummaries []types.OpportunitySummary

	// A pagination token used to retrieve the next set of results in subsequent
	// calls. This token is included in the response only if there are additional
	// result pages available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOpportunitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListOpportunities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListOpportunities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOpportunities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListOpportunitiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOpportunities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOpportunitiesPaginatorOptions is the paginator options for ListOpportunities
type ListOpportunitiesPaginatorOptions struct {
	// Specifies the maximum number of results to return in a single call. This limits
	// the number of opportunities returned in the response to avoid providing too many
	// results at once.
	//
	// Default: 20
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOpportunitiesPaginator is a paginator for ListOpportunities
type ListOpportunitiesPaginator struct {
	options   ListOpportunitiesPaginatorOptions
	client    ListOpportunitiesAPIClient
	params    *ListOpportunitiesInput
	nextToken *string
	firstPage bool
}

// NewListOpportunitiesPaginator returns a new ListOpportunitiesPaginator
func NewListOpportunitiesPaginator(client ListOpportunitiesAPIClient, params *ListOpportunitiesInput, optFns ...func(*ListOpportunitiesPaginatorOptions)) *ListOpportunitiesPaginator {
	if params == nil {
		params = &ListOpportunitiesInput{}
	}

	options := ListOpportunitiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOpportunitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOpportunitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOpportunities page.
func (p *ListOpportunitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOpportunitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOpportunities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOpportunitiesAPIClient is a client that implements the ListOpportunities
// operation.
type ListOpportunitiesAPIClient interface {
	ListOpportunities(context.Context, *ListOpportunitiesInput, ...func(*Options)) (*ListOpportunitiesOutput, error)
}

var _ ListOpportunitiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOpportunities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOpportunities",
	}
}
