// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an Opportunity record in Partner Central. Use this operation to create
// a potential business opportunity for submission to Amazon Web Services. Creating
// an opportunity sets Lifecycle.ReviewStatus to Pending Submission .
//
// To submit an opportunity, follow these steps:
//
//   - To create the opportunity, use CreateOpportunity .
//
//   - To associate a solution with the opportunity, use AssociateOpportunity .
//
//   - To start the engagement with AWS, use StartEngagementFromOpportunity .
//
// After submission, you can't edit the opportunity until the review is complete.
// But opportunities in the Pending Submission state must have complete details.
// You can update the opportunity while it's in the Pending Submission state.
//
// There's a set of mandatory fields to create opportunities, but consider
// providing optional fields to enrich the opportunity record.
func (c *Client) CreateOpportunity(ctx context.Context, params *CreateOpportunityInput, optFns ...func(*Options)) (*CreateOpportunityOutput, error) {
	if params == nil {
		params = &CreateOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOpportunity", params, optFns, c.addOperationCreateOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateOpportunityInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunity is created in. Use AWS to create opportunities in
	// the Amazon Web Services catalog, and Sandbox for testing in secure, isolated
	// environments.
	//
	// This member is required.
	Catalog *string

	// Required to be unique, and should be unchanging, it can be randomly generated
	// or a meaningful string.
	//
	// Default: None
	//
	// Best practice: To help ensure uniqueness and avoid conflicts, use a Universally
	// Unique Identifier (UUID) as the ClientToken . You can use standard libraries
	// from most programming languages to generate this. If you use the same client
	// token, the API returns the following error: "Conflicting client token submitted
	// for a new request body."
	//
	// This member is required.
	ClientToken *string

	// Specifies customer details associated with the Opportunity .
	Customer *types.Customer

	// An object that contains lifecycle details for the Opportunity .
	LifeCycle *types.LifeCycle

	// This object contains marketing details and is optional for an opportunity.
	Marketing *types.Marketing

	// Indicates whether the Opportunity pertains to a national security project. This
	// field must be set to true only when the customer's industry is Government.
	// Additional privacy and security measures apply during the review and management
	// process for opportunities marked as NationalSecurity .
	NationalSecurity types.NationalSecurity

	// Represents the internal team handling the opportunity. Specify collaborating
	// members of this opportunity who are within the partner's organization.
	OpportunityTeam []types.Contact

	// Specifies the opportunity type as a renewal, new, or expansion.
	//
	// Opportunity types:
	//
	//   - New opportunity: Represents a new business opportunity with a potential
	//   customer that's not previously engaged with your solutions or services.
	//
	//   - Renewal opportunity: Represents an opportunity to renew an existing
	//   contract or subscription with a current customer, ensuring continuity of
	//   service.
	//
	//   - Expansion opportunity: Represents an opportunity to expand the scope of an
	//   existing contract or subscription, either by adding new services or increasing
	//   the volume of existing services for a current customer.
	OpportunityType types.OpportunityType

	// Specifies the origin of the opportunity, indicating if it was sourced from
	// Amazon Web Services or the partner. For all opportunities created with Catalog:
	// AWS , this field must only be Partner Referral . However, when using Catalog:
	// Sandbox , you can set this field to AWS Referral to simulate Amazon Web
	// Services referral creation. This allows Amazon Web Services-originated flows
	// testing in the sandbox catalog.
	Origin types.OpportunityOrigin

	// Specifies the opportunity's unique identifier in the partner's CRM system. This
	// value is essential to track and reconcile because it's included in the outbound
	// payload to the partner.
	//
	// This field allows partners to link an opportunity to their CRM, which helps to
	// ensure seamless integration and accurate synchronization between the Partner
	// Central API and the partner's internal systems.
	PartnerOpportunityIdentifier *string

	// Identifies the type of support the partner needs from Amazon Web Services.
	//
	// Valid values:
	//
	//   - Cosell—Architectural Validation: Confirmation from Amazon Web Services that
	//   the partner's proposed solution architecture is aligned with Amazon Web Services
	//   best practices and poses minimal architectural risks.
	//
	//   - Cosell—Business Presentation: Request Amazon Web Services seller's
	//   participation in a joint customer presentation.
	//
	//   - Cosell—Competitive Information: Access to Amazon Web Services competitive
	//   resources and support for the partner's proposed solution.
	//
	//   - Cosell—Pricing Assistance: Connect with an Amazon Web Services seller for
	//   support situations where a partner may be receiving an upfront discount on a
	//   service (for example: EDP deals).
	//
	//   - Cosell—Technical Consultation: Connect with an Amazon Web Services
	//   Solutions Architect to address the partner's questions about the proposed
	//   solution.
	//
	//   - Cosell—Total Cost of Ownership Evaluation: Assistance with quoting
	//   different cost savings of proposed solutions on Amazon Web Services versus
	//   on-premises or a traditional hosting environment.
	//
	//   - Cosell—Deal Support: Request Amazon Web Services seller's support to
	//   progress the opportunity (for example: joint customer call, strategic
	//   positioning).
	//
	//   - Cosell—Support for Public Tender/RFx: Opportunity related to the public
	//   sector where the partner needs Amazon Web Services RFx support.
	PrimaryNeedsFromAws []types.PrimaryNeedFromAws

	// An object that contains project details for the Opportunity .
	Project *types.Project

	// Specifies details of a customer's procurement terms. This is required only for
	// partners in eligible programs.
	SoftwareRevenue *types.SoftwareRevenue

	// A map of the key-value pairs of the tag or tags to assign.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateOpportunityOutput struct {

	// Read-only, system-generated Opportunity unique identifier. Amazon Web Services
	// creates this identifier, and it's used for all subsequent opportunity actions,
	// such as updates, associations, and submissions. It helps to ensure that each
	// opportunity is accurately tracked and managed.
	//
	// This member is required.
	Id *string

	// DateTime when the opportunity was last modified. When the Opportunity is
	// created, its value is CreatedDate .
	LastModifiedDate *time.Time

	// Specifies the opportunity's unique identifier in the partner's CRM system. This
	// value is essential to track and reconcile because it's included in the outbound
	// payload sent back to the partner.
	PartnerOpportunityIdentifier *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateOpportunityMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateOpportunity struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateOpportunity) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateOpportunity) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateOpportunityInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateOpportunityInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateOpportunityMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateOpportunity{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateOpportunity",
	}
}
