// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralchannel

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralchannel/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists channel handshakes based on specified criteria.
func (c *Client) ListChannelHandshakes(ctx context.Context, params *ListChannelHandshakesInput, optFns ...func(*Options)) (*ListChannelHandshakesOutput, error) {
	if params == nil {
		params = &ListChannelHandshakesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChannelHandshakes", params, optFns, c.addOperationListChannelHandshakesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChannelHandshakesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChannelHandshakesInput struct {

	// The catalog identifier to filter handshakes.
	//
	// This member is required.
	Catalog *string

	// Filter results by handshake type.
	//
	// This member is required.
	HandshakeType types.HandshakeType

	// Filter by participant type (sender or receiver).
	//
	// This member is required.
	ParticipantType types.ParticipantType

	// Filter by associated resource identifiers.
	AssociatedResourceIdentifiers []string

	// Type-specific filters for handshakes.
	HandshakeTypeFilters types.ListChannelHandshakesTypeFilters

	// Type-specific sorting options for handshakes.
	HandshakeTypeSort types.ListChannelHandshakesTypeSort

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// Token for retrieving the next page of results.
	NextToken *string

	// Filter results by handshake status.
	Statuses []types.HandshakeStatus

	noSmithyDocumentSerde
}

type ListChannelHandshakesOutput struct {

	// List of channel handshakes matching the criteria.
	Items []types.ChannelHandshakeSummary

	// Token for retrieving the next page of results, if available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChannelHandshakesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListChannelHandshakes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListChannelHandshakes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListChannelHandshakes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListChannelHandshakesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChannelHandshakes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChannelHandshakesPaginatorOptions is the paginator options for
// ListChannelHandshakes
type ListChannelHandshakesPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChannelHandshakesPaginator is a paginator for ListChannelHandshakes
type ListChannelHandshakesPaginator struct {
	options   ListChannelHandshakesPaginatorOptions
	client    ListChannelHandshakesAPIClient
	params    *ListChannelHandshakesInput
	nextToken *string
	firstPage bool
}

// NewListChannelHandshakesPaginator returns a new ListChannelHandshakesPaginator
func NewListChannelHandshakesPaginator(client ListChannelHandshakesAPIClient, params *ListChannelHandshakesInput, optFns ...func(*ListChannelHandshakesPaginatorOptions)) *ListChannelHandshakesPaginator {
	if params == nil {
		params = &ListChannelHandshakesInput{}
	}

	options := ListChannelHandshakesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChannelHandshakesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChannelHandshakesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChannelHandshakes page.
func (p *ListChannelHandshakesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChannelHandshakesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListChannelHandshakes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListChannelHandshakesAPIClient is a client that implements the
// ListChannelHandshakes operation.
type ListChannelHandshakesAPIClient interface {
	ListChannelHandshakes(context.Context, *ListChannelHandshakesInput, ...func(*Options)) (*ListChannelHandshakesOutput, error)
}

var _ ListChannelHandshakesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListChannelHandshakes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListChannelHandshakes",
	}
}
