// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralchannel

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralchannel/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new partner relationship between accounts.
func (c *Client) CreateRelationship(ctx context.Context, params *CreateRelationshipInput, optFns ...func(*Options)) (*CreateRelationshipOutput, error) {
	if params == nil {
		params = &CreateRelationshipInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRelationship", params, optFns, c.addOperationCreateRelationshipMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRelationshipOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRelationshipInput struct {

	// The AWS account ID to associate in this relationship.
	//
	// This member is required.
	AssociatedAccountId *string

	// The type of association for the relationship (e.g., reseller, distributor).
	//
	// This member is required.
	AssociationType types.AssociationType

	// The catalog identifier for the relationship.
	//
	// This member is required.
	Catalog *string

	// A human-readable name for the relationship.
	//
	// This member is required.
	DisplayName *string

	// The identifier of the program management account for this relationship.
	//
	// This member is required.
	ProgramManagementAccountIdentifier *string

	// The business sector for the relationship.
	//
	// This member is required.
	Sector types.Sector

	// A unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string

	// The support plan requested for this relationship.
	RequestedSupportPlan types.SupportPlan

	// The resale account model for the relationship.
	ResaleAccountModel types.ResaleAccountModel

	// Key-value pairs to associate with the relationship.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateRelationshipOutput struct {

	// Details of the created relationship.
	RelationshipDetail *types.CreateRelationshipDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRelationshipMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateRelationship{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRelationship"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRelationshipMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRelationshipValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRelationship(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateRelationship struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRelationship) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRelationship) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRelationshipInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRelationshipInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRelationshipMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRelationship{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRelationship(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRelationship",
	}
}
