// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralbenefits

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralbenefits/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a paginated list of available benefits based on specified filter
// criteria.
func (c *Client) ListBenefits(ctx context.Context, params *ListBenefitsInput, optFns ...func(*Options)) (*ListBenefitsOutput, error) {
	if params == nil {
		params = &ListBenefitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBenefits", params, optFns, c.addOperationListBenefitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBenefitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBenefitsInput struct {

	// The catalog identifier to filter benefits by catalog.
	//
	// This member is required.
	Catalog *string

	// Filter benefits by specific fulfillment types.
	FulfillmentTypes []types.FulfillmentType

	// The maximum number of benefits to return in a single response.
	MaxResults *int32

	// A pagination token to retrieve the next set of results from a previous request.
	NextToken *string

	// Filter benefits by specific AWS partner programs.
	Programs []string

	// Filter benefits by their current status.
	Status []types.BenefitStatus

	noSmithyDocumentSerde
}

type ListBenefitsOutput struct {

	// A list of benefit summaries matching the specified criteria.
	BenefitSummaries []types.BenefitSummary

	// A pagination token to retrieve the next set of results, if more results are
	// available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBenefitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBenefits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBenefits{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBenefits"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBenefitsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBenefits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBenefitsPaginatorOptions is the paginator options for ListBenefits
type ListBenefitsPaginatorOptions struct {
	// The maximum number of benefits to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBenefitsPaginator is a paginator for ListBenefits
type ListBenefitsPaginator struct {
	options   ListBenefitsPaginatorOptions
	client    ListBenefitsAPIClient
	params    *ListBenefitsInput
	nextToken *string
	firstPage bool
}

// NewListBenefitsPaginator returns a new ListBenefitsPaginator
func NewListBenefitsPaginator(client ListBenefitsAPIClient, params *ListBenefitsInput, optFns ...func(*ListBenefitsPaginatorOptions)) *ListBenefitsPaginator {
	if params == nil {
		params = &ListBenefitsInput{}
	}

	options := ListBenefitsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBenefitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBenefitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBenefits page.
func (p *ListBenefitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBenefitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBenefits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBenefitsAPIClient is a client that implements the ListBenefits operation.
type ListBenefitsAPIClient interface {
	ListBenefits(context.Context, *ListBenefitsInput, ...func(*Options)) (*ListBenefitsOutput, error)
}

var _ ListBenefitsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBenefits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBenefits",
	}
}
