// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information about an AWS account.
type AccountSummary struct {

	// The name associated with the AWS account.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains contact information for the primary alliance lead responsible for
// partnership activities.
type AllianceLeadContact struct {

	// The business title or role of the alliance lead contact person.
	//
	// This member is required.
	BusinessTitle *string

	// The email address of the alliance lead contact person.
	//
	// This member is required.
	Email *string

	// The first name of the alliance lead contact person.
	//
	// This member is required.
	FirstName *string

	// The last name of the alliance lead contact person.
	//
	// This member is required.
	LastName *string

	noSmithyDocumentSerde
}

// Contains information about a business rule validation error that occurred
// during an operation.
type BusinessValidationError struct {

	// A code identifying the specific business validation error.
	//
	// This member is required.
	Code BusinessValidationCode

	// A description of the business validation error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Base structure containing common connection properties.
type Connection struct {

	// The AWS Resource Name (ARN) of the connection.
	//
	// This member is required.
	Arn *string

	// The catalog identifier that the connection belongs to.
	//
	// This member is required.
	Catalog *string

	// The type of connection.
	//
	// This member is required.
	ConnectionTypes map[string]ConnectionTypeDetail

	// The unique identifier of the connection.
	//
	// This member is required.
	Id *string

	// The AWS account ID of the other participant in the connection.
	//
	// This member is required.
	OtherParticipantAccountId *string

	// The timestamp when the connection was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// A summary view of a connection invitation containing key information without
// full details.
type ConnectionInvitationSummary struct {

	// The Amazon Resource Name (ARN) of the connection invitation.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection invitation exists.
	//
	// This member is required.
	Catalog *string

	// The type of connection being requested in the invitation.
	//
	// This member is required.
	ConnectionType ConnectionType

	// The timestamp when the connection invitation was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the connection invitation.
	//
	// This member is required.
	Id *string

	// The identifier of the other participant in the connection invitation.
	//
	// This member is required.
	OtherParticipantIdentifier *string

	// The type of participant (inviter or invitee) in the connection invitation.
	//
	// This member is required.
	ParticipantType ParticipantType

	// The current status of the connection invitation.
	//
	// This member is required.
	Status InvitationStatus

	// The timestamp when the connection invitation was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the connection associated with this invitation.
	ConnectionId *string

	// The timestamp when the connection invitation will expire.
	ExpiresAt *time.Time

	noSmithyDocumentSerde
}

// A summary view of an active connection between partners containing key
// information.
type ConnectionSummary struct {

	// The Amazon Resource Name (ARN) of the connection.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection exists.
	//
	// This member is required.
	Catalog *string

	// A map of connection types and their summary information for this connection.
	//
	// This member is required.
	ConnectionTypes map[string]ConnectionTypeSummary

	// The unique identifier of the connection.
	//
	// This member is required.
	Id *string

	// The AWS account ID of the other participant in the connection.
	//
	// This member is required.
	OtherParticipantAccountId *string

	// The timestamp when the connection was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Detailed information about a specific connection type within a connection.
type ConnectionTypeDetail struct {

	// The timestamp when this connection type was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The email address of the person who initiated this connection type.
	//
	// This member is required.
	InviterEmail *string

	// The name of the person who initiated this connection type.
	//
	// This member is required.
	InviterName *string

	// Information about the other participant in this connection type.
	//
	// This member is required.
	OtherParticipant Participant

	// The current status of this connection type.
	//
	// This member is required.
	Status ConnectionTypeStatus

	// The timestamp when this connection type was cancelled, if applicable.
	CanceledAt *time.Time

	// The AWS account ID of the participant who cancelled this connection type.
	CanceledBy *string

	noSmithyDocumentSerde
}

// Summary information about a specific connection type between partners.
type ConnectionTypeSummary struct {

	// Information about the other participant in this connection type.
	//
	// This member is required.
	OtherParticipant Participant

	// The current status of this connection type (active, canceled, etc.).
	//
	// This member is required.
	Status ConnectionTypeStatus

	noSmithyDocumentSerde
}

// Contains detailed information about an error that occurred during an operation.
type ErrorDetail struct {

	// The locale or language code for the error message.
	//
	// This member is required.
	Locale *string

	// A human-readable description of the error.
	//
	// This member is required.
	Message *string

	// A machine-readable code or reason for the error.
	//
	// This member is required.
	Reason ProfileValidationErrorReason

	noSmithyDocumentSerde
}

// Contains information about a field-level validation error that occurred during
// an operation.
type FieldValidationError struct {

	// A code identifying the specific field validation error.
	//
	// This member is required.
	Code FieldValidationCode

	// A description of the field validation error.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains localized content for a partner profile in a specific language or
// locale.
type LocalizedContent struct {

	// The localized description of the partner's business and services.
	//
	// This member is required.
	Description *string

	// The localized display name for the partner.
	//
	// This member is required.
	DisplayName *string

	// The locale or language code for the localized content.
	//
	// This member is required.
	Locale *string

	// The URL to the partner's logo image for this locale.
	//
	// This member is required.
	LogoUrl *string

	// The localized website URL for the partner.
	//
	// This member is required.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Represents a participant in a partner connection, containing their profile and
// account information.
//
// The following types satisfy this interface:
//
//	ParticipantMemberAccount
//	ParticipantMemberPartnerProfile
//	ParticipantMemberSellerProfile
type Participant interface {
	isParticipant()
}

// The AWS account information for the participant.
type ParticipantMemberAccount struct {
	Value AccountSummary

	noSmithyDocumentSerde
}

func (*ParticipantMemberAccount) isParticipant() {}

// The partner profile information for the participant.
type ParticipantMemberPartnerProfile struct {
	Value PartnerProfileSummary

	noSmithyDocumentSerde
}

func (*ParticipantMemberPartnerProfile) isParticipant() {}

// The seller profile information for the participant.
type ParticipantMemberSellerProfile struct {
	Value SellerProfileSummary

	noSmithyDocumentSerde
}

func (*ParticipantMemberSellerProfile) isParticipant() {}

// Represents a verified domain associated with a partner account.
type PartnerDomain struct {

	// The domain name that has been verified for the partner account.
	//
	// This member is required.
	DomainName *string

	// The timestamp when the domain was registered and verified for the partner
	// account.
	//
	// This member is required.
	RegisteredAt *time.Time

	noSmithyDocumentSerde
}

// Contains comprehensive profile information for a partner including
// public-facing details.
type PartnerProfile struct {

	// A description of the partner's business, services, and capabilities.
	//
	// This member is required.
	Description *string

	// The public display name for the partner organization.
	//
	// This member is required.
	DisplayName *string

	// The industry segments or verticals that the partner serves.
	//
	// This member is required.
	IndustrySegments []IndustrySegment

	// The URL to the partner's logo image.
	//
	// This member is required.
	LogoUrl *string

	// The primary type of solution or service the partner provides.
	//
	// This member is required.
	PrimarySolutionType PrimarySolutionType

	// The source locale used for automatic translation of profile content.
	//
	// This member is required.
	TranslationSourceLocale *string

	// The partner's primary website URL.
	//
	// This member is required.
	WebsiteUrl *string

	// A list of localized content versions for different languages and regions.
	LocalizedContents []LocalizedContent

	// The unique identifier of the partner profile.
	ProfileId *string

	noSmithyDocumentSerde
}

// A summary view of a partner profile containing basic identifying information.
type PartnerProfileSummary struct {

	// The unique identifier of the partner profile.
	//
	// This member is required.
	Id *string

	// The display name of the partner.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A summary view of a partner account containing basic information for listing
// purposes.
type PartnerSummary struct {

	// The Amazon Resource Name (ARN) of the partner account.
	//
	// This member is required.
	Arn *string

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The timestamp when the partner account was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the partner account.
	//
	// This member is required.
	Id *string

	// The legal name of the partner organization.
	//
	// This member is required.
	LegalName *string

	noSmithyDocumentSerde
}

// A summary view of a seller profile containing basic identifying information.
type SellerProfileSummary struct {

	// The unique identifier of the seller profile.
	//
	// This member is required.
	Id *string

	// The display name of the seller.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A key-value pair used to associate metadata with AWS Partner Central Account
// resources.
type Tag struct {

	// The key name of the tag. Tag keys are case-sensitive.
	//
	// This member is required.
	Key *string

	// The value associated with the tag key. Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains detailed information about a profile update task including the changes
// to be made.
type TaskDetails struct {

	// The updated description for the partner profile.
	//
	// This member is required.
	Description *string

	// The updated display name for the partner profile.
	//
	// This member is required.
	DisplayName *string

	// The updated industry segments for the partner profile.
	//
	// This member is required.
	IndustrySegments []IndustrySegment

	// The updated logo URL for the partner profile.
	//
	// This member is required.
	LogoUrl *string

	// The updated primary solution type for the partner profile.
	//
	// This member is required.
	PrimarySolutionType PrimarySolutionType

	// The updated translation source locale for the partner profile.
	//
	// This member is required.
	TranslationSourceLocale *string

	// The updated website URL for the partner profile.
	//
	// This member is required.
	WebsiteUrl *string

	// The updated localized content for the partner profile.
	LocalizedContents []LocalizedContent

	noSmithyDocumentSerde
}

// Contains information about a validation error, which can be either a
// field-level or business rule validation error.
//
// The following types satisfy this interface:
//
//	ValidationErrorMemberBusinessValidationError
//	ValidationErrorMemberFieldValidationError
type ValidationError interface {
	isValidationError()
}

// Details about a business rule validation error, if applicable.
type ValidationErrorMemberBusinessValidationError struct {
	Value BusinessValidationError

	noSmithyDocumentSerde
}

func (*ValidationErrorMemberBusinessValidationError) isValidationError() {}

// Details about a field-level validation error, if applicable.
type ValidationErrorMemberFieldValidationError struct {
	Value FieldValidationError

	noSmithyDocumentSerde
}

func (*ValidationErrorMemberFieldValidationError) isValidationError() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isParticipant()     {}
func (*UnknownUnionMember) isValidationError() {}
