// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Rejects a connection invitation from another partner, declining the partnership
// request.
func (c *Client) RejectConnectionInvitation(ctx context.Context, params *RejectConnectionInvitationInput, optFns ...func(*Options)) (*RejectConnectionInvitationOutput, error) {
	if params == nil {
		params = &RejectConnectionInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RejectConnectionInvitation", params, optFns, c.addOperationRejectConnectionInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RejectConnectionInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RejectConnectionInvitationInput struct {

	// The catalog identifier where the connection invitation exists.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// This member is required.
	ClientToken *string

	// The unique identifier of the connection invitation to reject.
	//
	// This member is required.
	Identifier *string

	// The reason for rejecting the connection invitation.
	Reason *string

	noSmithyDocumentSerde
}

type RejectConnectionInvitationOutput struct {

	// The Amazon Resource Name (ARN) of the rejected connection invitation.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection invitation was rejected.
	//
	// This member is required.
	Catalog *string

	// The type of connection that was being invited for.
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The timestamp when the connection invitation was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the rejected connection invitation.
	//
	// This member is required.
	Id *string

	// The message that was included with the original connection invitation.
	//
	// This member is required.
	InvitationMessage *string

	// The email address of the person who sent the connection invitation.
	//
	// This member is required.
	InviterEmail *string

	// The name of the person who sent the connection invitation.
	//
	// This member is required.
	InviterName *string

	// The identifier of the other participant who sent the invitation.
	//
	// This member is required.
	OtherParticipantIdentifier *string

	// The type of participant (inviter or invitee) in the connection invitation.
	//
	// This member is required.
	ParticipantType types.ParticipantType

	// The current status of the connection invitation (rejected).
	//
	// This member is required.
	Status types.InvitationStatus

	// The timestamp when the connection invitation was last updated (rejected).
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the connection associated with the rejected invitation.
	ConnectionId *string

	// The timestamp when the connection invitation would have expired.
	ExpiresAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRejectConnectionInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRejectConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRejectConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RejectConnectionInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opRejectConnectionInvitationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpRejectConnectionInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRejectConnectionInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpRejectConnectionInvitation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpRejectConnectionInvitation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpRejectConnectionInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*RejectConnectionInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *RejectConnectionInvitationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opRejectConnectionInvitationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpRejectConnectionInvitation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opRejectConnectionInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RejectConnectionInvitation",
	}
}
