// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets the visibility level for a partner profile, controlling who can view the
// profile information.
func (c *Client) PutProfileVisibility(ctx context.Context, params *PutProfileVisibilityInput, optFns ...func(*Options)) (*PutProfileVisibilityOutput, error) {
	if params == nil {
		params = &PutProfileVisibilityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutProfileVisibility", params, optFns, c.addOperationPutProfileVisibilityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutProfileVisibilityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutProfileVisibilityInput struct {

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Identifier *string

	// The visibility setting to apply to the partner profile.
	//
	// This member is required.
	Visibility types.ProfileVisibility

	noSmithyDocumentSerde
}

type PutProfileVisibilityOutput struct {

	// The Amazon Resource Name (ARN) of the partner account.
	//
	// This member is required.
	Arn *string

	// The catalog identifier for the partner account.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the partner account.
	//
	// This member is required.
	Id *string

	// The unique identifier of the partner profile.
	//
	// This member is required.
	ProfileId *string

	// The updated visibility setting for the partner profile.
	//
	// This member is required.
	Visibility types.ProfileVisibility

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutProfileVisibilityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpPutProfileVisibility{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpPutProfileVisibility{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutProfileVisibility"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutProfileVisibilityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutProfileVisibility(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutProfileVisibility(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutProfileVisibility",
	}
}
