// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Cancels an existing connection between partners, terminating the partnership
// relationship.
func (c *Client) CancelConnection(ctx context.Context, params *CancelConnectionInput, optFns ...func(*Options)) (*CancelConnectionOutput, error) {
	if params == nil {
		params = &CancelConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelConnection", params, optFns, c.addOperationCancelConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelConnectionInput struct {

	// The catalog identifier where the connection exists.
	//
	// This member is required.
	Catalog *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	//
	// This member is required.
	ClientToken *string

	// The type of connection to cancel (e.g., reseller, distributor, technology
	// partner).
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The unique identifier of the connection to cancel.
	//
	// This member is required.
	Identifier *string

	// The reason for canceling the connection, providing context for the termination.
	//
	// This member is required.
	Reason *string

	noSmithyDocumentSerde
}

type CancelConnectionOutput struct {

	// The Amazon Resource Name (ARN) of the canceled connection.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection was canceled.
	//
	// This member is required.
	Catalog *string

	// The list of connection types that were active before cancellation.
	//
	// This member is required.
	ConnectionTypes map[string]types.ConnectionTypeDetail

	// The unique identifier of the canceled connection.
	//
	// This member is required.
	Id *string

	// The AWS account ID of the other participant in the canceled connection.
	//
	// This member is required.
	OtherParticipantAccountId *string

	// The timestamp when the connection was last updated (canceled).
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCancelConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCancelConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCancelConnectionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCancelConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCancelConnection struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCancelConnection) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCancelConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CancelConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CancelConnectionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCancelConnectionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCancelConnection{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCancelConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelConnection",
	}
}
