// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the capacity tasks for your Amazon Web Services account.
//
// Use filters to return specific results. If you specify multiple filters, the
// results include only the resources that match all of the specified filters. For
// a filter where you can specify multiple values, the results include items that
// match any of the values that you specify for the filter.
func (c *Client) ListCapacityTasks(ctx context.Context, params *ListCapacityTasksInput, optFns ...func(*Options)) (*ListCapacityTasksOutput, error) {
	if params == nil {
		params = &ListCapacityTasksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCapacityTasks", params, optFns, c.addOperationListCapacityTasksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCapacityTasksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCapacityTasksInput struct {

	// A list of statuses. For example, REQUESTED or WAITING_FOR_EVACUATION .
	CapacityTaskStatusFilter []types.CapacityTaskStatus

	// The maximum page size.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// Filters the results by an Outpost ID or an Outpost ARN.
	OutpostIdentifierFilter *string

	noSmithyDocumentSerde
}

type ListCapacityTasksOutput struct {

	// Lists all the capacity tasks.
	CapacityTasks []types.CapacityTaskSummary

	// The pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCapacityTasksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCapacityTasks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCapacityTasks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCapacityTasks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCapacityTasks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCapacityTasksPaginatorOptions is the paginator options for ListCapacityTasks
type ListCapacityTasksPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCapacityTasksPaginator is a paginator for ListCapacityTasks
type ListCapacityTasksPaginator struct {
	options   ListCapacityTasksPaginatorOptions
	client    ListCapacityTasksAPIClient
	params    *ListCapacityTasksInput
	nextToken *string
	firstPage bool
}

// NewListCapacityTasksPaginator returns a new ListCapacityTasksPaginator
func NewListCapacityTasksPaginator(client ListCapacityTasksAPIClient, params *ListCapacityTasksInput, optFns ...func(*ListCapacityTasksPaginatorOptions)) *ListCapacityTasksPaginator {
	if params == nil {
		params = &ListCapacityTasksInput{}
	}

	options := ListCapacityTasksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCapacityTasksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCapacityTasksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCapacityTasks page.
func (p *ListCapacityTasksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCapacityTasksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCapacityTasks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCapacityTasksAPIClient is a client that implements the ListCapacityTasks
// operation.
type ListCapacityTasksAPIClient interface {
	ListCapacityTasks(context.Context, *ListCapacityTasksInput, ...func(*Options)) (*ListCapacityTasksOutput, error)
}

var _ ListCapacityTasksAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCapacityTasks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCapacityTasks",
	}
}
