// Code generated by smithy-go-codegen DO NOT EDIT.

package osis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/osis/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the pipeline endpoints connected to pipelines in your account.
func (c *Client) ListPipelineEndpointConnections(ctx context.Context, params *ListPipelineEndpointConnectionsInput, optFns ...func(*Options)) (*ListPipelineEndpointConnectionsOutput, error) {
	if params == nil {
		params = &ListPipelineEndpointConnectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPipelineEndpointConnections", params, optFns, c.addOperationListPipelineEndpointConnectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPipelineEndpointConnectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPipelineEndpointConnectionsInput struct {

	// The maximum number of pipeline endpoint connections to return in the response.
	MaxResults *int32

	// If your initial ListPipelineEndpointConnections operation returns a nextToken ,
	// you can include the returned nextToken in subsequent
	// ListPipelineEndpointConnections operations, which returns results in the next
	// page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPipelineEndpointConnectionsOutput struct {

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// A list of pipeline endpoint connections.
	PipelineEndpointConnections []types.PipelineEndpointConnection

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPipelineEndpointConnectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPipelineEndpointConnections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPipelineEndpointConnections{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPipelineEndpointConnections"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPipelineEndpointConnections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPipelineEndpointConnectionsPaginatorOptions is the paginator options for
// ListPipelineEndpointConnections
type ListPipelineEndpointConnectionsPaginatorOptions struct {
	// The maximum number of pipeline endpoint connections to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPipelineEndpointConnectionsPaginator is a paginator for
// ListPipelineEndpointConnections
type ListPipelineEndpointConnectionsPaginator struct {
	options   ListPipelineEndpointConnectionsPaginatorOptions
	client    ListPipelineEndpointConnectionsAPIClient
	params    *ListPipelineEndpointConnectionsInput
	nextToken *string
	firstPage bool
}

// NewListPipelineEndpointConnectionsPaginator returns a new
// ListPipelineEndpointConnectionsPaginator
func NewListPipelineEndpointConnectionsPaginator(client ListPipelineEndpointConnectionsAPIClient, params *ListPipelineEndpointConnectionsInput, optFns ...func(*ListPipelineEndpointConnectionsPaginatorOptions)) *ListPipelineEndpointConnectionsPaginator {
	if params == nil {
		params = &ListPipelineEndpointConnectionsInput{}
	}

	options := ListPipelineEndpointConnectionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPipelineEndpointConnectionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPipelineEndpointConnectionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPipelineEndpointConnections page.
func (p *ListPipelineEndpointConnectionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPipelineEndpointConnectionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPipelineEndpointConnections(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPipelineEndpointConnectionsAPIClient is a client that implements the
// ListPipelineEndpointConnections operation.
type ListPipelineEndpointConnectionsAPIClient interface {
	ListPipelineEndpointConnections(context.Context, *ListPipelineEndpointConnectionsInput, ...func(*Options)) (*ListPipelineEndpointConnectionsOutput, error)
}

var _ ListPipelineEndpointConnectionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPipelineEndpointConnections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPipelineEndpointConnections",
	}
}
