// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about an Amazon Web Services account that is a member of
// an organization.
type Account struct {

	// The Amazon Resource Name (ARN) of the account.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// The email address associated with the Amazon Web Services account.
	//
	// The [regex pattern] for this parameter is a string of characters that represents a standard
	// internet email address.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Email *string

	// The unique identifier (ID) of the account.
	//
	// The [regex pattern] for an account ID string requires exactly 12 digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The method by which the account joined the organization.
	JoinedMethod AccountJoinedMethod

	// The date the account became a part of the organization.
	JoinedTimestamp *time.Time

	// The friendly name of the account.
	//
	// The [regex pattern] that is used to validate this parameter is a string of any of the
	// characters in the ASCII character range.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Name *string

	// Each state represents a specific phase in the account lifecycle. Use this
	// information to manage account access, automate workflows, or trigger actions
	// based on account state changes.
	//
	// For more information about account states and their implications, see [Monitor the state of your Amazon Web Services accounts] in the
	// Organizations User Guide.
	//
	// [Monitor the state of your Amazon Web Services accounts]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_account_state.html
	State AccountState

	// The status of the account in the organization.
	//
	// The Status parameter in the Account object will be retired on September 9,
	// 2026. Although both the account State and account Status parameters are
	// currently available in the Organizations APIs ( DescribeAccount , ListAccounts ,
	// ListAccountsForParent ), we recommend that you update your scripts or other code
	// to use the State parameter instead of Status before September 9, 2026.
	Status AccountStatus

	noSmithyDocumentSerde
}

// Contains a list of child entities, either OUs or accounts.
type Child struct {

	// The unique identifier (ID) of this child entity.
	//
	// The [regex pattern] for a child ID string requires one of the following:
	//
	//   - Account - A string that consists of exactly 12 digits.
	//
	//   - Organizational unit (OU) - A string that begins with "ou-" followed by from
	//   4 to 32 lowercase letters or digits (the ID of the root that contains the OU).
	//   This string is followed by a second "-" dash and from 8 to 32 additional
	//   lowercase letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The type of this child entity.
	Type ChildType

	noSmithyDocumentSerde
}

// Contains the status about a CreateAccount or CreateGovCloudAccount request to create an Amazon Web Services
// account or an Amazon Web Services GovCloud (US) account in an organization.
type CreateAccountStatus struct {

	// If the account was created successfully, the unique identifier (ID) of the new
	// account.
	//
	// The [regex pattern] for an account ID string requires exactly 12 digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	AccountId *string

	// The account name given to the account when it was created.
	AccountName *string

	// The date and time that the account was created and the request completed.
	CompletedTimestamp *time.Time

	// If the request failed, a description of the reason for the failure.
	//
	//   - ACCOUNT_LIMIT_EXCEEDED: The account couldn't be created because you reached
	//   the limit on the number of accounts in your organization.
	//
	//   - CONCURRENT_ACCOUNT_MODIFICATION: You already submitted a request with the
	//   same information.
	//
	//   - EMAIL_ALREADY_EXISTS: The account could not be created because another
	//   Amazon Web Services account with that email address already exists.
	//
	//   - FAILED_BUSINESS_VALIDATION: The Amazon Web Services account that owns your
	//   organization failed to receive business license validation.
	//
	//   - GOVCLOUD_ACCOUNT_ALREADY_EXISTS: The account in the Amazon Web Services
	//   GovCloud (US) Region could not be created because this Region already includes
	//   an account with that email address.
	//
	//   - IDENTITY_INVALID_BUSINESS_VALIDATION: The Amazon Web Services account that
	//   owns your organization can't complete business license validation because it
	//   doesn't have valid identity data.
	//
	//   - INVALID_ADDRESS: The account could not be created because the address you
	//   provided is not valid.
	//
	//   - INVALID_EMAIL: The account could not be created because the email address
	//   you provided is not valid.
	//
	//   - INVALID_PAYMENT_INSTRUMENT: The Amazon Web Services account that owns your
	//   organization does not have a supported payment method associated with the
	//   account. Amazon Web Services does not support cards issued by financial
	//   institutions in Russia or Belarus. For more information, see [Managing your Amazon Web Services payments].
	//
	//   - INTERNAL_FAILURE: The account could not be created because of an internal
	//   failure. Try again later. If the problem persists, contact Amazon Web Services
	//   Customer Support.
	//
	//   - MISSING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your
	//   organization has not received Business Validation.
	//
	//   - MISSING_PAYMENT_INSTRUMENT: You must configure the management account with
	//   a valid payment method, such as a credit card.
	//
	//   - PENDING_BUSINESS_VALIDATION: The Amazon Web Services account that owns your
	//   organization is still in the process of completing business license validation.
	//
	//   - UNKNOWN_BUSINESS_VALIDATION: The Amazon Web Services account that owns your
	//   organization has an unknown issue with business license validation.
	//
	// [Managing your Amazon Web Services payments]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html
	FailureReason CreateAccountFailureReason

	// If the account was created successfully, the ID for the new account in the
	// Amazon Web Services GovCloud (US) Region.
	GovCloudAccountId *string

	// The unique identifier (ID) that references this request. You get this value
	// from the response of the initial CreateAccountrequest to create the account.
	//
	// The [regex pattern] for a create account request ID string requires "car-" followed by from 8
	// to 32 lowercase letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The date and time that the request was made for the account creation.
	RequestedTimestamp *time.Time

	// The status of the asynchronous request to create an Amazon Web Services account.
	State CreateAccountState

	noSmithyDocumentSerde
}

// Contains information about the delegated administrator.
type DelegatedAdministrator struct {

	// The Amazon Resource Name (ARN) of the delegated administrator's account.
	Arn *string

	// The date when the account was made a delegated administrator.
	DelegationEnabledDate *time.Time

	// The email address that is associated with the delegated administrator's Amazon
	// Web Services account.
	Email *string

	// The unique identifier (ID) of the delegated administrator's account.
	Id *string

	// The method by which the delegated administrator's account joined the
	// organization.
	JoinedMethod AccountJoinedMethod

	// The date when the delegated administrator's account became a part of the
	// organization.
	JoinedTimestamp *time.Time

	// The friendly name of the delegated administrator's account.
	Name *string

	// Each state represents a specific phase in the account lifecycle. Use this
	// information to manage account access, automate workflows, or trigger actions
	// based on account state changes.
	//
	// For more information about account states and their implications, see [Monitor the state of your Amazon Web Services accounts] in the
	// Organizations User Guide.
	//
	// [Monitor the state of your Amazon Web Services accounts]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_account_state.html
	State AccountState

	// The status of the delegated administrator's account in the organization.
	Status AccountStatus

	noSmithyDocumentSerde
}

// Contains information about the Amazon Web Services service for which the
// account is a delegated administrator.
type DelegatedService struct {

	// The date that the account became a delegated administrator for this service.
	DelegationEnabledDate *time.Time

	// The name of an Amazon Web Services service that can request an operation for
	// the specified service. This is typically in the form of a URL, such as:
	// servicename.amazonaws.com .
	ServicePrincipal *string

	noSmithyDocumentSerde
}

// Contains rules to be applied to the affected accounts. The effective policy is
// the aggregation of any policies the account inherits, plus any policy directly
// attached to the account.
type EffectivePolicy struct {

	// The time of the last update to this policy.
	LastUpdatedTimestamp *time.Time

	// The text content of the policy.
	PolicyContent *string

	// The policy type.
	PolicyType EffectivePolicyType

	// The account ID of the policy target.
	TargetId *string

	noSmithyDocumentSerde
}

// Contains details about the validation errors that occurred when generating or
// enforcing an [effective policy], such as which policies contributed to the error and location of
// the error.
//
// [effective policy]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_effective.html
type EffectivePolicyValidationError struct {

	// The individual policies [inherited] and [attached] to the account which contributed to the
	// validation error.
	//
	// [inherited]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_inheritance_mgmt.html
	// [attached]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_policies_attach.html
	ContributingPolicies []string

	// The error code for the validation error. For example, ELEMENTS_TOO_MANY .
	ErrorCode *string

	// The error message for the validation error.
	ErrorMessage *string

	// The path within the effective policy where the validation error occurred.
	PathToError *string

	noSmithyDocumentSerde
}

// A structure that contains details of a service principal that represents an
// Amazon Web Services service that is enabled to integrate with Organizations.
type EnabledServicePrincipal struct {

	// The date that the service principal was enabled for integration with
	// Organizations.
	DateEnabled *time.Time

	// The name of the service principal. This is typically in the form of a URL, such
	// as: servicename.amazonaws.com .
	ServicePrincipal *string

	noSmithyDocumentSerde
}

// Contains details for a handshake. A handshake is the secure exchange of
// information between two Amazon Web Services accounts: a sender and a recipient.
//
// Note: Handshakes that are CANCELED , ACCEPTED , DECLINED , or EXPIRED show up
// in lists for only 30 days after entering that state After that they are deleted.
type Handshake struct {

	// The type of handshake:
	//
	//   - INVITE: Handshake sent to a standalone account requesting that it to join
	//   the sender's organization.
	//
	//   - ENABLE_ALL_FEATURES: Handshake sent to invited member accounts to enable
	//   all features for the organization.
	//
	//   - APPROVE_ALL_FEATURES: Handshake sent to the management account when all
	//   invited member accounts have approved to enable all features.
	//
	//   - TRANSFER_RESPONSIBILITY: Handshake sent to another organization's
	//   management account requesting that it designate the sender with the specified
	//   responsibilities for recipient's organization.
	Action ActionType

	// Amazon Resource Name (ARN) for the handshake.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// Timestamp when the handshake expires.
	ExpirationTimestamp *time.Time

	// ID for the handshake.
	//
	// The [regex pattern] for handshake ID string requires "h-" followed by from 8 to 32 lowercase
	// letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// An array of HandshakeParty objects. Contains details for participant in a
	// handshake.
	Parties []HandshakeParty

	// Timestamp when the handshake request was made.
	RequestedTimestamp *time.Time

	// An array of HandshakeResource objects. When needed, contains additional details
	// for a handshake. For example, the email address for the sender.
	Resources []HandshakeResource

	// Current state for the handshake.
	//
	//   - REQUESTED: Handshake awaiting a response from the recipient.
	//
	//   - OPEN: Handshake sent to multiple recipients and all recipients have
	//   responded. The sender can now complete the handshake action.
	//
	//   - CANCELED: Handshake canceled by the sender.
	//
	//   - ACCEPTED: Handshake accepted by the recipient.
	//
	//   - DECLINED: Handshake declined by the recipient.
	//
	//   - EXPIRED: Handshake has expired.
	State HandshakeState

	noSmithyDocumentSerde
}

// Contains the filter used to select the handshakes for an operation.
type HandshakeFilter struct {

	// The type of handshake.
	//
	// If you specify ActionType , you cannot also specify ParentHandshakeId .
	ActionType ActionType

	// The parent handshake. Only used for handshake types that are a child of another
	// type.
	//
	// If you specify ParentHandshakeId , you cannot also specify ActionType .
	//
	// The [regex pattern] for handshake ID string requires "h-" followed by from 8 to 32 lowercase
	// letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	ParentHandshakeId *string

	noSmithyDocumentSerde
}

// Contains details for a participant in a handshake.
type HandshakeParty struct {

	// ID for the participant: Acccount ID, organization ID, or email address.
	//
	// The [regex pattern] for handshake ID string requires "h-" followed by from 8 to 32 lowercase
	// letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	//
	// This member is required.
	Id *string

	// The type of ID for the participant.
	//
	// This member is required.
	Type HandshakePartyType

	noSmithyDocumentSerde
}

// Contains additional details for a handshake.
type HandshakeResource struct {

	// An array of HandshakeResource objects. When needed, contains additional details
	// for a handshake. For example, the email address for the sender.
	Resources []HandshakeResource

	// The type of information being passed, specifying how the value is to be
	// interpreted by the other party:
	//
	//   - ACCOUNT: ID for an Amazon Web Services account.
	//
	//   - ORGANIZATION: ID for an organization.
	//
	//   - EMAIL: Email address for the recipient.
	//
	//   - OWNER_EMAIL: Email address for the sender.
	//
	//   - OWNER_NAME: Name of the sender.
	//
	//   - NOTES: Additional text included by the sender for the recipient.
	Type HandshakeResourceType

	// Additional information for the handshake. The format of the value string must
	// match the requirements of the specified type.
	Value *string

	noSmithyDocumentSerde
}

// Contains details about an organization. An organization is a collection of
// accounts that are centrally managed together using consolidated billing,
// organized hierarchically with organizational units (OUs), and controlled with
// policies .
type Organization struct {

	// The Amazon Resource Name (ARN) of an organization.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// Do not use. This field is deprecated and doesn't provide complete information
	// about the policies in your organization.
	//
	// To determine the policies that are enabled and available for use in your
	// organization, use the ListRootsoperation instead.
	AvailablePolicyTypes []PolicyTypeSummary

	// Specifies the functionality that currently is available to the organization. If
	// set to "ALL", then all features are enabled and policies can be applied to
	// accounts in the organization. If set to "CONSOLIDATED_BILLING", then only
	// consolidated billing functionality is available. For more information, see [Enabling all features in your organization]in
	// the Organizations User Guide.
	//
	// [Enabling all features in your organization]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html
	FeatureSet OrganizationFeatureSet

	// The unique identifier (ID) of an organization.
	//
	// The [regex pattern] for an organization ID string requires "o-" followed by from 10 to 32
	// lowercase letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The Amazon Resource Name (ARN) of the account that is designated as the
	// management account for the organization.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	MasterAccountArn *string

	// The email address that is associated with the Amazon Web Services account that
	// is designated as the management account for the organization.
	MasterAccountEmail *string

	// The unique identifier (ID) of the management account of an organization.
	//
	// The [regex pattern] for an account ID string requires exactly 12 digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	MasterAccountId *string

	noSmithyDocumentSerde
}

// Contains details about an organizational unit (OU). An OU is a container of
// Amazon Web Services accounts within a root of an organization. Policies that are
// attached to an OU apply to all accounts contained in that OU and in any child
// OUs.
type OrganizationalUnit struct {

	// The Amazon Resource Name (ARN) of this OU.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// The unique identifier (ID) associated with this OU. The ID is unique to the
	// organization only.
	//
	// The [regex pattern] for an organizational unit ID string requires "ou-" followed by from 4 to
	// 32 lowercase letters or digits (the ID of the root that contains the OU). This
	// string is followed by a second "-" dash and from 8 to 32 additional lowercase
	// letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The friendly name of this OU.
	//
	// The [regex pattern] that is used to validate this parameter is a string of any of the
	// characters in the ASCII character range.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Name *string

	noSmithyDocumentSerde
}

// Contains information about either a root or an organizational unit (OU) that
// can contain OUs or accounts in an organization.
type Parent struct {

	// The unique identifier (ID) of the parent entity.
	//
	// The [regex pattern] for a parent ID string requires one of the following:
	//
	//   - Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//   letters or digits.
	//
	//   - Organizational unit (OU) - A string that begins with "ou-" followed by from
	//   4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This
	//   string is followed by a second "-" dash and from 8 to 32 additional lowercase
	//   letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The type of the parent entity.
	Type ParentType

	noSmithyDocumentSerde
}

// Contains rules to be applied to the affected accounts. Policies can be attached
// directly to accounts, or to roots and OUs to affect all accounts in those
// hierarchies.
type Policy struct {

	// The text content of the policy.
	Content *string

	// A structure that contains additional details about the policy.
	PolicySummary *PolicySummary

	noSmithyDocumentSerde
}

// Contains information about a policy, but does not include the content. To see
// the content of a policy, see DescribePolicy.
type PolicySummary struct {

	// The Amazon Resource Name (ARN) of the policy.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// A boolean value that indicates whether the specified policy is an Amazon Web
	// Services managed policy. If true, then you can attach the policy to roots, OUs,
	// or accounts, but you cannot edit it.
	AwsManaged bool

	// The description of the policy.
	Description *string

	// The unique identifier (ID) of the policy.
	//
	// The [regex pattern] for a policy ID string requires "p-" followed by from 8 to 128 lowercase
	// or uppercase letters, digits, or the underscore character (_).
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The friendly name of the policy.
	//
	// The [regex pattern] that is used to validate this parameter is a string of any of the
	// characters in the ASCII character range.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Name *string

	// The type of policy.
	Type PolicyType

	noSmithyDocumentSerde
}

// Contains information about a root, OU, or account that a policy is attached to.
type PolicyTargetSummary struct {

	// The Amazon Resource Name (ARN) of the policy target.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// The friendly name of the policy target.
	//
	// The [regex pattern] that is used to validate this parameter is a string of any of the
	// characters in the ASCII character range.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Name *string

	// The unique identifier (ID) of the policy target.
	//
	// The [regex pattern] for a target ID string requires one of the following:
	//
	//   - Root - A string that begins with "r-" followed by from 4 to 32 lowercase
	//   letters or digits.
	//
	//   - Account - A string that consists of exactly 12 digits.
	//
	//   - Organizational unit (OU) - A string that begins with "ou-" followed by from
	//   4 to 32 lowercase letters or digits (the ID of the root that the OU is in). This
	//   string is followed by a second "-" dash and from 8 to 32 additional lowercase
	//   letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	TargetId *string

	// The type of the policy target.
	Type TargetType

	noSmithyDocumentSerde
}

// Contains information about a policy type and its status in the associated root.
type PolicyTypeSummary struct {

	// The status of the policy type as it relates to the associated root. To attach a
	// policy of the specified type to a root or to an OU or account in that root, it
	// must be available in the organization and enabled for that root.
	Status PolicyTypeStatus

	// The name of the policy type.
	Type PolicyType

	noSmithyDocumentSerde
}

// A structure that contains details about a resource policy.
type ResourcePolicy struct {

	// The policy text of the resource policy.
	Content *string

	// A structure that contains resource policy ID and Amazon Resource Name (ARN).
	ResourcePolicySummary *ResourcePolicySummary

	noSmithyDocumentSerde
}

// A structure that contains resource policy ID and Amazon Resource Name (ARN).
type ResourcePolicySummary struct {

	// The Amazon Resource Name (ARN) of the resource policy.
	Arn *string

	// The unique identifier (ID) of the resource policy.
	Id *string

	noSmithyDocumentSerde
}

// Contains details for a transfer. A transfer is the arrangement between two
// management accounts where one account designates the other with specified
// responsibilities for their organization.
type ResponsibilityTransfer struct {

	// ID for the handshake of the transfer.
	ActiveHandshakeId *string

	// Amazon Resource Name (ARN) for the transfer.
	Arn *string

	// Timestamp when the transfer ends.
	EndTimestamp *time.Time

	// ID for the transfer.
	Id *string

	// Name assigned to the transfer.
	Name *string

	// Account that allows another account external to its organization to manage the
	// specified responsibilities for the organization.
	Source *TransferParticipant

	// Timestamp when the transfer starts.
	StartTimestamp *time.Time

	// Status for the transfer.
	Status ResponsibilityTransferStatus

	// Account that manages the specified responsibilities for another organization.
	Target *TransferParticipant

	// The type of transfer. Currently, only BILLING is supported.
	Type ResponsibilityTransferType

	noSmithyDocumentSerde
}

// Contains details about a root. A root is a top-level parent node in the
// hierarchy of an organization that can contain organizational units (OUs) and
// accounts. The root contains every Amazon Web Services account in the
// organization.
type Root struct {

	// The Amazon Resource Name (ARN) of the root.
	//
	// For more information about ARNs in Organizations, see [ARN Formats Supported by Organizations] in the Amazon Web
	// Services Service Authorization Reference.
	//
	// [ARN Formats Supported by Organizations]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsorganizations.html#awsorganizations-resources-for-iam-policies
	Arn *string

	// The unique identifier (ID) for the root. The ID is unique to the organization
	// only.
	//
	// The [regex pattern] for a root ID string requires "r-" followed by from 4 to 32 lowercase
	// letters or digits.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Id *string

	// The friendly name of the root.
	//
	// The [regex pattern] that is used to validate this parameter is a string of any of the
	// characters in the ASCII character range.
	//
	// [regex pattern]: http://wikipedia.org/wiki/regex
	Name *string

	// The types of policies that are currently enabled for the root and therefore can
	// be attached to the root or to its OUs or accounts.
	//
	// Even if a policy type is shown as available in the organization, you can
	// separately enable and disable them at the root level by using EnablePolicyTypeand DisablePolicyType. Use DescribeOrganization to see
	// the availability of the policy types in that organization.
	PolicyTypes []PolicyTypeSummary

	noSmithyDocumentSerde
}

// A custom key-value pair associated with a resource within your organization.
//
// You can attach tags to any of the following organization resources.
//
//   - Amazon Web Services account
//
//   - Organizational unit (OU)
//
//   - Organization root
//
//   - Policy
type Tag struct {

	// The key identifier, or name, of the tag.
	//
	// This member is required.
	Key *string

	// The string value that's associated with the key of the tag. You can set the
	// value of a tag to an empty string, but you can't set the value of a tag to null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains details for a participant in a transfer. A transfer is the arrangement
// between two management accounts where one account designates the other with
// specified responsibilities for their organization.
type TransferParticipant struct {

	// Email address for the management account.
	ManagementAccountEmail *string

	// ID for the management account.
	ManagementAccountId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
