// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new workflow version for the workflow that you specify with the
// workflowId parameter.
//
// When you create a new version of a workflow, you need to specify the
// configuration for the new version. It doesn't inherit any configuration values
// from the workflow.
//
// Provide a version name that is unique for this workflow. You cannot change the
// name after HealthOmics creates the version.
//
// Don't include any personally identifiable information (PII) in the version
// name. Version names appear in the workflow version ARN.
//
// For more information, see [Workflow versioning in Amazon Web Services HealthOmics] in the Amazon Web Services HealthOmics User Guide.
//
// [Workflow versioning in Amazon Web Services HealthOmics]: https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html
func (c *Client) CreateWorkflowVersion(ctx context.Context, params *CreateWorkflowVersionInput, optFns ...func(*Options)) (*CreateWorkflowVersionOutput, error) {
	if params == nil {
		params = &CreateWorkflowVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkflowVersion", params, optFns, c.addOperationCreateWorkflowVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkflowVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkflowVersionInput struct {

	// An idempotency token to ensure that duplicate workflows are not created when
	// Amazon Web Services HealthOmics submits retry requests.
	//
	// This member is required.
	RequestId *string

	// A name for the workflow version. Provide a version name that is unique for this
	// workflow. You cannot change the name after HealthOmics creates the version.
	//
	// The version name must start with a letter or number and it can include
	// upper-case and lower-case letters, numbers, hyphens, periods and underscores.
	// The maximum length is 64 characters. You can use a simple naming scheme, such as
	// version1, version2, version3. You can also match your workflow versions with
	// your own internal versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
	//
	// This member is required.
	VersionName *string

	// The ID of the workflow where you are creating the new version. The workflowId
	// is not the UUID.
	//
	// This member is required.
	WorkflowId *string

	// The computational accelerator for this workflow version.
	Accelerators types.Accelerators

	// (Optional) Use a container registry map to specify mappings between the ECR
	// private repository and one or more upstream registries. For more information,
	// see [Container images]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Container images]: https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html
	ContainerRegistryMap *types.ContainerRegistryMap

	// (Optional) URI of the S3 location for the registry mapping file.
	ContainerRegistryMapUri *string

	// The repository information for the workflow version definition. This allows you
	// to source your workflow version definition directly from a code repository.
	DefinitionRepository *types.DefinitionRepository

	// The S3 URI of a definition for this workflow version. The S3 bucket must be in
	// the same region as this workflow version.
	DefinitionUri *string

	// A ZIP archive containing the main workflow definition file and dependencies
	// that it imports for this workflow version. You can use a file with a ://fileb
	// prefix instead of the Base64 string. For more information, see Workflow
	// definition requirements in the Amazon Web Services HealthOmics User Guide.
	DefinitionZip []byte

	// A description for this workflow version.
	Description *string

	// The workflow engine for this workflow version. This is only required if you
	// have workflow definition files from more than one engine in your zip file.
	// Otherwise, the service can detect the engine automatically from your workflow
	// definition.
	Engine types.WorkflowEngine

	// The path of the main definition file for this workflow version. This parameter
	// is not required if the ZIP archive contains only one workflow definition file,
	// or if the main definition file is named “main”. An example path is:
	// workflow-definition/main-file.wdl .
	Main *string

	// A parameter template for this workflow version. If this field is blank, Amazon
	// Web Services HealthOmics will automatically parse the parameter template values
	// from your workflow definition file. To override these service generated default
	// values, provide a parameter template. To view an example of a parameter
	// template, see [Parameter template files]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Parameter template files]: https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html
	ParameterTemplate map[string]types.WorkflowParameter

	// The path to the workflow version parameter template JSON file within the
	// repository. This file defines the input parameters for runs that use this
	// workflow version. If not specified, the workflow version will be created without
	// a parameter template.
	ParameterTemplatePath *string

	// The markdown content for the workflow version's README file. This provides
	// documentation and usage information for users of this specific workflow version.
	//
	// This value conforms to the media type: text/markdown
	ReadmeMarkdown *string

	// The path to the workflow version README markdown file within the repository.
	// This file provides documentation and usage information for the workflow. If not
	// specified, the README.md file from the root directory of the repository will be
	// used.
	ReadmePath *string

	// The S3 URI of the README file for the workflow version. This file provides
	// documentation and usage information for the workflow version. Requirements
	// include:
	//
	//   - The S3 URI must begin with s3://USER-OWNED-BUCKET/
	//
	//   - The requester must have access to the S3 bucket and object.
	//
	//   - The max README content length is 500 KiB.
	ReadmeUri *string

	// The default static storage capacity (in gibibytes) for runs that use this
	// workflow version. The storageCapacity can be overwritten at run time. The
	// storage capacity is not required for runs with a DYNAMIC storage type.
	StorageCapacity *int32

	// The default storage type for runs that use this workflow version. The
	// storageType can be overridden at run time. DYNAMIC storage dynamically scales
	// the storage up or down, based on file system utilization. STATIC storage
	// allocates a fixed amount of storage. For more information about dynamic and
	// static storage types, see [Run storage types]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Run storage types]: https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html
	StorageType types.StorageType

	// Tags for this workflow version. You can define up to 50 tags for the workflow.
	// For more information, see [Adding a tag]in the Amazon Web Services HealthOmics User Guide.
	//
	// [Adding a tag]: https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html
	Tags map[string]string

	// Amazon Web Services Id of the owner of the S3 bucket that contains the workflow
	// definition. You need to specify this parameter if your account is not the bucket
	// owner.
	WorkflowBucketOwnerId *string

	noSmithyDocumentSerde
}

type CreateWorkflowVersionOutput struct {

	// ARN of the workflow version.
	Arn *string

	// The workflow version status.
	Status types.WorkflowStatus

	// The workflow version's tags.
	Tags map[string]string

	// The universally unique identifier (UUID) value for this workflow version.
	Uuid *string

	// The workflow version name.
	VersionName *string

	// The workflow's ID.
	WorkflowId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkflowVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkflowVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateWorkflowVersionMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateWorkflowVersionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkflowVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkflowVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateWorkflowVersionMiddleware struct {
}

func (*endpointPrefix_opCreateWorkflowVersionMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateWorkflowVersionMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateWorkflowVersionMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateWorkflowVersionMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateWorkflowVersion struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateWorkflowVersion) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateWorkflowVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateWorkflowVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateWorkflowVersionInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateWorkflowVersionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateWorkflowVersion{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateWorkflowVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkflowVersion",
	}
}
