// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a peering connection between an ODB network and a VPC.
//
// A peering connection enables private connectivity between the networks for
// application-tier communication.
func (c *Client) CreateOdbPeeringConnection(ctx context.Context, params *CreateOdbPeeringConnectionInput, optFns ...func(*Options)) (*CreateOdbPeeringConnectionOutput, error) {
	if params == nil {
		params = &CreateOdbPeeringConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateOdbPeeringConnection", params, optFns, c.addOperationCreateOdbPeeringConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateOdbPeeringConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateOdbPeeringConnectionInput struct {

	// The unique identifier of the ODB network that initiates the peering connection.
	//
	// This member is required.
	OdbNetworkId *string

	// The unique identifier of the peer network. This can be either a VPC ID or
	// another ODB network ID.
	//
	// This member is required.
	PeerNetworkId *string

	// The client token for the ODB peering connection request.
	//
	// Constraints:
	//
	//   - Must be unique for each request.
	ClientToken *string

	// The display name for the ODB peering connection.
	DisplayName *string

	// A list of CIDR blocks to add to the peering connection. These CIDR blocks
	// define the IP address ranges that can communicate through the peering
	// connection.
	PeerNetworkCidrsToBeAdded []string

	// The tags to assign to the ODB peering connection.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateOdbPeeringConnectionOutput struct {

	// The unique identifier of the ODB peering connection.
	//
	// This member is required.
	OdbPeeringConnectionId *string

	// The display name of the ODB peering connection.
	DisplayName *string

	// The status of the ODB peering connection.
	Status types.ResourceStatus

	// The reason for the current status of the ODB peering connection.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateOdbPeeringConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateOdbPeeringConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateOdbPeeringConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateOdbPeeringConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateOdbPeeringConnectionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateOdbPeeringConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateOdbPeeringConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateOdbPeeringConnection struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateOdbPeeringConnection) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateOdbPeeringConnection) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateOdbPeeringConnectionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateOdbPeeringConnectionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateOdbPeeringConnectionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateOdbPeeringConnection{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateOdbPeeringConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateOdbPeeringConnection",
	}
}
