// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration of an existing telemetry pipeline.
//
// The following attributes cannot be updated after pipeline creation:
//
//   - Pipeline name - The pipeline name is immutable
//
//   - Pipeline ARN - The ARN is automatically generated and cannot be changed
//
//   - Source type - Once a pipeline is created with a specific source type (such
//     as S3, CloudWatch Logs, GitHub, or third-party sources), it cannot be changed to
//     a different source type
//
// Processors can be added, removed, or modified. However, some processors are not
// supported for third-party pipelines and cannot be added through updates.
//
// # Source-Specific Update Rules
//
// CloudWatch Logs Sources (Vended and Custom)  Updatable: sts_role_arn
//
// Fixed: data_source_name , data_source_type , sink (must remain @original )
//
// S3 Sources (Crowdstrike, Zscaler, SentinelOne, Custom)  Updatable: All SQS
// configuration parameters, sts_role_arn , codec settings, compression type,
// bucket ownership settings, sink log group
//
// Fixed: notification_type , aws.region
//
// GitHub Audit Logs  Updatable: All Amazon Web Services Secrets Manager
// attributes, scope (can switch between ORGANIZATION/ENTERPRISE), organization or
// enterprise name, range , authentication credentials (PAT or GitHub App)
//
// Microsoft Sources (Entra ID, Office365, Windows)  Updatable: All Amazon Web
// Services Secrets Manager attributes, tenant_id , workspace_id (Windows only),
// OAuth2 credentials ( client_id , client_secret )
//
// Okta Sources (SSO, Auth0)  Updatable: All Amazon Web Services Secrets Manager
// attributes, domain , range (SSO only), OAuth2 credentials ( client_id ,
// client_secret )
//
// Palo Alto Networks  Updatable: All Amazon Web Services Secrets Manager
// attributes, hostname , basic authentication credentials ( username , password )
//
// ServiceNow CMDB  Updatable: All Amazon Web Services Secrets Manager attributes,
// instance_url , range , OAuth2 credentials ( client_id , client_secret )
//
// Wiz CNAPP  Updatable: All Amazon Web Services Secrets Manager attributes, region
// , range , OAuth2 credentials ( client_id , client_secret )
func (c *Client) UpdateTelemetryPipeline(ctx context.Context, params *UpdateTelemetryPipelineInput, optFns ...func(*Options)) (*UpdateTelemetryPipelineOutput, error) {
	if params == nil {
		params = &UpdateTelemetryPipelineInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateTelemetryPipeline", params, optFns, c.addOperationUpdateTelemetryPipelineMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateTelemetryPipelineOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateTelemetryPipelineInput struct {

	// The new configuration for the telemetry pipeline, including updated sources,
	// processors, and destinations.
	//
	// This member is required.
	Configuration *types.TelemetryPipelineConfiguration

	// The ARN of the telemetry pipeline to update.
	//
	// This member is required.
	PipelineIdentifier *string

	noSmithyDocumentSerde
}

type UpdateTelemetryPipelineOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateTelemetryPipelineMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateTelemetryPipeline{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateTelemetryPipeline{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateTelemetryPipeline"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateTelemetryPipelineValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateTelemetryPipeline(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateTelemetryPipeline(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateTelemetryPipeline",
	}
}
