// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all telemetry rules in your account. You can filter the results by
//
// specifying a rule name prefix.
func (c *Client) ListTelemetryRules(ctx context.Context, params *ListTelemetryRulesInput, optFns ...func(*Options)) (*ListTelemetryRulesOutput, error) {
	if params == nil {
		params = &ListTelemetryRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTelemetryRules", params, optFns, c.addOperationListTelemetryRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTelemetryRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTelemetryRulesInput struct {

	//  The maximum number of telemetry rules to return in a single call.
	MaxResults *int32

	//  The token for the next set of results. A previous call generates this token.
	NextToken *string

	//  A string to filter telemetry rules whose names begin with the specified
	// prefix.
	RuleNamePrefix *string

	noSmithyDocumentSerde
}

type ListTelemetryRulesOutput struct {

	//  A token to resume pagination of results.
	NextToken *string

	//  A list of telemetry rule summaries.
	TelemetryRuleSummaries []types.TelemetryRuleSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTelemetryRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTelemetryRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTelemetryRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTelemetryRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTelemetryRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTelemetryRulesPaginatorOptions is the paginator options for
// ListTelemetryRules
type ListTelemetryRulesPaginatorOptions struct {
	//  The maximum number of telemetry rules to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTelemetryRulesPaginator is a paginator for ListTelemetryRules
type ListTelemetryRulesPaginator struct {
	options   ListTelemetryRulesPaginatorOptions
	client    ListTelemetryRulesAPIClient
	params    *ListTelemetryRulesInput
	nextToken *string
	firstPage bool
}

// NewListTelemetryRulesPaginator returns a new ListTelemetryRulesPaginator
func NewListTelemetryRulesPaginator(client ListTelemetryRulesAPIClient, params *ListTelemetryRulesInput, optFns ...func(*ListTelemetryRulesPaginatorOptions)) *ListTelemetryRulesPaginator {
	if params == nil {
		params = &ListTelemetryRulesInput{}
	}

	options := ListTelemetryRulesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTelemetryRulesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTelemetryRulesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTelemetryRules page.
func (p *ListTelemetryRulesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTelemetryRulesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTelemetryRules(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTelemetryRulesAPIClient is a client that implements the ListTelemetryRules
// operation.
type ListTelemetryRulesAPIClient interface {
	ListTelemetryRules(context.Context, *ListTelemetryRulesInput, ...func(*Options)) (*ListTelemetryRulesOutput, error)
}

var _ ListTelemetryRulesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTelemetryRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTelemetryRules",
	}
}
