// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of telemetry pipelines in your account. Returns up to 100
// results. If more than 100 telemetry pipelines exist, include the NextToken
// value from the response to retrieve the next set of results.
func (c *Client) ListTelemetryPipelines(ctx context.Context, params *ListTelemetryPipelinesInput, optFns ...func(*Options)) (*ListTelemetryPipelinesOutput, error) {
	if params == nil {
		params = &ListTelemetryPipelinesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTelemetryPipelines", params, optFns, c.addOperationListTelemetryPipelinesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTelemetryPipelinesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTelemetryPipelinesInput struct {

	// The maximum number of telemetry pipelines to return in a single call.
	MaxResults *int32

	// The token for the next set of results. A previous call generates this token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTelemetryPipelinesOutput struct {

	// A token to resume pagination of results.
	NextToken *string

	// A list of telemetry pipeline summaries containing key information about each
	// pipeline.
	PipelineSummaries []types.TelemetryPipelineSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTelemetryPipelinesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTelemetryPipelines{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTelemetryPipelines{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTelemetryPipelines"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTelemetryPipelines(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTelemetryPipelinesPaginatorOptions is the paginator options for
// ListTelemetryPipelines
type ListTelemetryPipelinesPaginatorOptions struct {
	// The maximum number of telemetry pipelines to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTelemetryPipelinesPaginator is a paginator for ListTelemetryPipelines
type ListTelemetryPipelinesPaginator struct {
	options   ListTelemetryPipelinesPaginatorOptions
	client    ListTelemetryPipelinesAPIClient
	params    *ListTelemetryPipelinesInput
	nextToken *string
	firstPage bool
}

// NewListTelemetryPipelinesPaginator returns a new ListTelemetryPipelinesPaginator
func NewListTelemetryPipelinesPaginator(client ListTelemetryPipelinesAPIClient, params *ListTelemetryPipelinesInput, optFns ...func(*ListTelemetryPipelinesPaginatorOptions)) *ListTelemetryPipelinesPaginator {
	if params == nil {
		params = &ListTelemetryPipelinesInput{}
	}

	options := ListTelemetryPipelinesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTelemetryPipelinesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTelemetryPipelinesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTelemetryPipelines page.
func (p *ListTelemetryPipelinesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTelemetryPipelinesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTelemetryPipelines(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTelemetryPipelinesAPIClient is a client that implements the
// ListTelemetryPipelines operation.
type ListTelemetryPipelinesAPIClient interface {
	ListTelemetryPipelines(context.Context, *ListTelemetryPipelinesInput, ...func(*Options)) (*ListTelemetryPipelinesOutput, error)
}

var _ ListTelemetryPipelinesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTelemetryPipelines(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTelemetryPipelines",
	}
}
