// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a list of NotificationEvents according to specified filters, in reverse
// chronological order (newest first).
//
// User Notifications stores notifications in the individual Regions you register
// as notification hubs and the Region of the source event rule.
// ListNotificationEvents only returns notifications stored in the same Region in
// which the action is called. User Notifications doesn't backfill notifications to
// new Regions selected as notification hubs. For this reason, we recommend that
// you make calls in your oldest registered notification hub. For more information,
// see [Notification hubs]in the Amazon Web Services User Notifications User Guide.
//
// [Notification hubs]: https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html
func (c *Client) ListNotificationEvents(ctx context.Context, params *ListNotificationEventsInput, optFns ...func(*Options)) (*ListNotificationEventsOutput, error) {
	if params == nil {
		params = &ListNotificationEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListNotificationEvents", params, optFns, c.addOperationListNotificationEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListNotificationEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListNotificationEventsInput struct {

	// The Amazon Resource Name (ARN) of the aggregatedNotificationEventArn to match.
	AggregateNotificationEventArn *string

	// Latest time of events to return from this call.
	EndTime *time.Time

	// Include aggregated child events in the result.
	IncludeChildEvents *bool

	// The locale code of the language used for the retrieved NotificationEvent . The
	// default locale is English (en_US) .
	Locale types.LocaleCode

	// The maximum number of results to be returned in this call. Defaults to 20.
	MaxResults *int32

	// The start token for paginated calls. Retrieved from the response of a previous
	// ListEventRules call. Next token uses Base64 encoding.
	NextToken *string

	// The unique identifier of the organizational unit used to filter notification
	// events.
	OrganizationalUnitId *string

	// The matched event source.
	//
	// Must match one of the valid EventBridge sources. Only Amazon Web Services
	// service sourced events are supported. For example, aws.ec2 and aws.cloudwatch .
	// For more information, see [Event delivery from Amazon Web Services services]in the Amazon EventBridge User Guide.
	//
	// [Event delivery from Amazon Web Services services]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level
	Source *string

	// The earliest time of events to return from this call.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type ListNotificationEventsOutput struct {

	// The list of notification events.
	//
	// This member is required.
	NotificationEvents []types.NotificationEventOverview

	// A pagination token. If a non-null pagination token is returned in a result,
	// pass its value in another request to retrieve more entries.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListNotificationEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListNotificationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListNotificationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListNotificationEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListNotificationEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListNotificationEventsPaginatorOptions is the paginator options for
// ListNotificationEvents
type ListNotificationEventsPaginatorOptions struct {
	// The maximum number of results to be returned in this call. Defaults to 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListNotificationEventsPaginator is a paginator for ListNotificationEvents
type ListNotificationEventsPaginator struct {
	options   ListNotificationEventsPaginatorOptions
	client    ListNotificationEventsAPIClient
	params    *ListNotificationEventsInput
	nextToken *string
	firstPage bool
}

// NewListNotificationEventsPaginator returns a new ListNotificationEventsPaginator
func NewListNotificationEventsPaginator(client ListNotificationEventsAPIClient, params *ListNotificationEventsInput, optFns ...func(*ListNotificationEventsPaginatorOptions)) *ListNotificationEventsPaginator {
	if params == nil {
		params = &ListNotificationEventsInput{}
	}

	options := ListNotificationEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListNotificationEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListNotificationEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListNotificationEvents page.
func (p *ListNotificationEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListNotificationEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListNotificationEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListNotificationEventsAPIClient is a client that implements the
// ListNotificationEvents operation.
type ListNotificationEventsAPIClient interface {
	ListNotificationEvents(context.Context, *ListNotificationEventsInput, ...func(*Options)) (*ListNotificationEventsOutput, error)
}

var _ ListNotificationEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListNotificationEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListNotificationEvents",
	}
}
