// Code generated by smithy-go-codegen DO NOT EDIT.

package networkflowmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkflowmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Update a monitor to add or remove local or remote resources.
func (c *Client) UpdateMonitor(ctx context.Context, params *UpdateMonitorInput, optFns ...func(*Options)) (*UpdateMonitorOutput, error) {
	if params == nil {
		params = &UpdateMonitorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMonitor", params, optFns, c.addOperationUpdateMonitorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMonitorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMonitorInput struct {

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// A unique, case-sensitive string of up to 64 ASCII characters that you specify
	// to make an idempotent API request. Don't reuse the same client token for other
	// API requests.
	ClientToken *string

	// Additional local resources to specify network flows for a monitor, as an array
	// of resources with identifiers and types. A local resource in a workload is the
	// location of hosts where the Network Flow Monitor agent is installed.
	LocalResourcesToAdd []types.MonitorLocalResource

	// The local resources to remove, as an array of resources with identifiers and
	// types.
	LocalResourcesToRemove []types.MonitorLocalResource

	// The remote resources to add, as an array of resources with identifiers and
	// types.
	//
	// A remote resource is the other endpoint in the flow of a workload, with a local
	// resource. For example, Amazon Dynamo DB can be a remote resource.
	RemoteResourcesToAdd []types.MonitorRemoteResource

	// The remote resources to remove, as an array of resources with identifiers and
	// types.
	//
	// A remote resource is the other endpoint specified for the network flow of a
	// workload, with a local resource. For example, Amazon Dynamo DB can be a remote
	// resource.
	RemoteResourcesToRemove []types.MonitorRemoteResource

	noSmithyDocumentSerde
}

type UpdateMonitorOutput struct {

	// The date and time when the monitor was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The local resources to monitor. A local resource in a workload is the location
	// of hosts where the Network Flow Monitor agent is installed.
	//
	// This member is required.
	LocalResources []types.MonitorLocalResource

	// The last date and time that the monitor was modified.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// This member is required.
	MonitorArn *string

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The status of a monitor. The status can be one of the following
	//
	//   - PENDING : The monitor is in the process of being created.
	//
	//   - ACTIVE : The monitor is active.
	//
	//   - INACTIVE : The monitor is inactive.
	//
	//   - ERROR : Monitor creation failed due to an error.
	//
	//   - DELETING : The monitor is in the process of being deleted.
	//
	// This member is required.
	MonitorStatus types.MonitorStatus

	// The remote resources updated for a monitor, as an array of resources with
	// identifiers and types.
	//
	// A remote resource is the other endpoint specified for the network flow of a
	// workload, with a local resource. For example, Amazon Dynamo DB can be a remote
	// resource.
	//
	// This member is required.
	RemoteResources []types.MonitorRemoteResource

	// The tags for a monitor.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMonitorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateMonitor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateMonitor{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateMonitor"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateMonitorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateMonitorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMonitor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateMonitor struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateMonitor) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateMonitor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateMonitorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateMonitorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateMonitorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateMonitor{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateMonitor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateMonitor",
	}
}
