// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the data objects for the specified proxy configuration for the
// specified proxy rule group.
func (c *Client) DescribeProxyRule(ctx context.Context, params *DescribeProxyRuleInput, optFns ...func(*Options)) (*DescribeProxyRuleOutput, error) {
	if params == nil {
		params = &DescribeProxyRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeProxyRule", params, optFns, c.addOperationDescribeProxyRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeProxyRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeProxyRuleInput struct {

	// The descriptive name of the proxy rule. You can't change the name of a proxy
	// rule after you create it.
	//
	// This member is required.
	ProxyRuleName *string

	// The Amazon Resource Name (ARN) of a proxy rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupArn *string

	// The descriptive name of the proxy rule group. You can't change the name of a
	// proxy rule group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	ProxyRuleGroupName *string

	noSmithyDocumentSerde
}

type DescribeProxyRuleOutput struct {

	// The configuration for the specified proxy rule.
	ProxyRule *types.ProxyRule

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the proxy rule. The token marks the state of the proxy rule
	// resource at the time of the request.
	//
	// To make changes to the proxy rule, you provide the token in your request.
	// Network Firewall uses the token to ensure that the proxy rule hasn't changed
	// since you last retrieved it. If it has changed, the operation fails with an
	// InvalidTokenException . If this happens, retrieve the proxy rule again to get a
	// current copy of it with a current token. Reapply your changes as needed, then
	// try the operation again using the new token.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeProxyRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeProxyRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeProxyRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeProxyRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeProxyRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeProxyRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeProxyRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeProxyRule",
	}
}
