// Code generated by smithy-go-codegen DO NOT EDIT.

package neptune

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/neptune/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modify a setting for an Amazon Neptune global cluster. You can change one or
// more database configuration parameters by specifying these parameters and their
// new values in the request.
func (c *Client) ModifyGlobalCluster(ctx context.Context, params *ModifyGlobalClusterInput, optFns ...func(*Options)) (*ModifyGlobalClusterOutput, error) {
	if params == nil {
		params = &ModifyGlobalClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyGlobalCluster", params, optFns, c.addOperationModifyGlobalClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyGlobalClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyGlobalClusterInput struct {

	// The DB cluster identifier for the global cluster being modified. This parameter
	// is not case-sensitive.
	//
	// Constraints: Must match the identifier of an existing global database cluster.
	//
	// This member is required.
	GlobalClusterIdentifier *string

	// A value that indicates whether major version upgrades are allowed.
	//
	// Constraints: You must allow major version upgrades if you specify a value for
	// the EngineVersion parameter that is a different major version than the DB
	// cluster's current version.
	//
	// If you upgrade the major version of a global database, the cluster and DB
	// instance parameter groups are set to the default parameter groups for the new
	// version, so you will need to apply any custom parameter groups after completing
	// the upgrade.
	AllowMajorVersionUpgrade *bool

	// Indicates whether the global database has deletion protection enabled. The
	// global database cannot be deleted when deletion protection is enabled.
	DeletionProtection *bool

	// The version number of the database engine to which you want to upgrade.
	// Changing this parameter will result in an outage. The change is applied during
	// the next maintenance window unless ApplyImmediately is enabled.
	//
	// To list all of the available Neptune engine versions, use the following command:
	EngineVersion *string

	// A new cluster identifier to assign to the global database. This value is stored
	// as a lowercase string.
	//
	// Constraints:
	//
	//   - Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//   - The first character must be a letter.
	//
	//   - Can't end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster2
	NewGlobalClusterIdentifier *string

	noSmithyDocumentSerde
}

type ModifyGlobalClusterOutput struct {

	// Contains the details of an Amazon Neptune global database.
	//
	// This data type is used as a response element for the CreateGlobalCluster, DescribeGlobalClusters, ModifyGlobalCluster, DeleteGlobalCluster, FailoverGlobalCluster, and RemoveFromGlobalCluster actions.
	GlobalCluster *types.GlobalCluster

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyGlobalClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpModifyGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpModifyGlobalCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyGlobalCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyGlobalClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyGlobalCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyGlobalCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyGlobalCluster",
	}
}
