// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all task instances for a specific workflow run, with optional pagination
// support.
func (c *Client) ListTaskInstances(ctx context.Context, params *ListTaskInstancesInput, optFns ...func(*Options)) (*ListTaskInstancesOutput, error) {
	if params == nil {
		params = &ListTaskInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTaskInstances", params, optFns, c.addOperationListTaskInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTaskInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTaskInstancesInput struct {

	// The unique identifier of the workflow run for which you want a list of task
	// instances.
	//
	// This member is required.
	RunId *string

	// The Amazon Resource Name (ARN) of the workflow that contains the run.
	//
	// This member is required.
	WorkflowArn *string

	// The maximum number of task instances to return in a single response.
	MaxResults *int32

	// The pagination token you need to use to retrieve the next set of results. This
	// value is returned from a previous call to ListTaskInstances .
	NextToken *string

	noSmithyDocumentSerde
}

type ListTaskInstancesOutput struct {

	// The pagination token you need to use to retrieve the next set of results. This
	// value is null if there are no more results.
	NextToken *string

	// A list of task instance summaries for the specified workflow run.
	TaskInstances []types.TaskInstanceSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTaskInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListTaskInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListTaskInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTaskInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTaskInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTaskInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTaskInstancesPaginatorOptions is the paginator options for ListTaskInstances
type ListTaskInstancesPaginatorOptions struct {
	// The maximum number of task instances to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTaskInstancesPaginator is a paginator for ListTaskInstances
type ListTaskInstancesPaginator struct {
	options   ListTaskInstancesPaginatorOptions
	client    ListTaskInstancesAPIClient
	params    *ListTaskInstancesInput
	nextToken *string
	firstPage bool
}

// NewListTaskInstancesPaginator returns a new ListTaskInstancesPaginator
func NewListTaskInstancesPaginator(client ListTaskInstancesAPIClient, params *ListTaskInstancesInput, optFns ...func(*ListTaskInstancesPaginatorOptions)) *ListTaskInstancesPaginator {
	if params == nil {
		params = &ListTaskInstancesInput{}
	}

	options := ListTaskInstancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTaskInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTaskInstancesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTaskInstances page.
func (p *ListTaskInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTaskInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTaskInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTaskInstancesAPIClient is a client that implements the ListTaskInstances
// operation.
type ListTaskInstancesAPIClient interface {
	ListTaskInstances(context.Context, *ListTaskInstancesInput, ...func(*Options)) (*ListTaskInstancesOutput, error)
}

var _ ListTaskInstancesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTaskInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTaskInstances",
	}
}
