// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves information about a specific router output in AWS Elemental
// MediaConnect.
func (c *Client) GetRouterOutput(ctx context.Context, params *GetRouterOutputInput, optFns ...func(*Options)) (*GetRouterOutputOutput, error) {
	if params == nil {
		params = &GetRouterOutputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRouterOutput", params, optFns, c.addOperationGetRouterOutputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRouterOutputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRouterOutputInput struct {

	// The Amazon Resource Name (ARN) of the router output that you want to retrieve
	// information about.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type GetRouterOutputOutput struct {

	// The details of the requested router output, including its configuration, state,
	// and other attributes.
	//
	// This member is required.
	RouterOutput *types.RouterOutput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRouterOutputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRouterOutput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRouterOutput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRouterOutput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetRouterOutputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRouterOutput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// OutputDeletedWaiterOptions are waiter options for OutputDeletedWaiter
type OutputDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// OutputDeletedWaiter will use default minimum delay of 3 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, OutputDeletedWaiter will use default max delay of 120 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetRouterOutputInput, *GetRouterOutputOutput, error) (bool, error)
}

// OutputDeletedWaiter defines the waiters for OutputDeleted
type OutputDeletedWaiter struct {
	client GetRouterOutputAPIClient

	options OutputDeletedWaiterOptions
}

// NewOutputDeletedWaiter constructs a OutputDeletedWaiter.
func NewOutputDeletedWaiter(client GetRouterOutputAPIClient, optFns ...func(*OutputDeletedWaiterOptions)) *OutputDeletedWaiter {
	options := OutputDeletedWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = outputDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &OutputDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for OutputDeleted waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *OutputDeletedWaiter) Wait(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for OutputDeleted waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *OutputDeletedWaiter) WaitForOutput(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputDeletedWaiterOptions)) (*GetRouterOutputOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetRouterOutput(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for OutputDeleted waiter")
}

func outputDeletedStateRetryable(ctx context.Context, input *GetRouterOutputInput, output *GetRouterOutputOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "DELETING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.ServiceUnavailableException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "ERROR"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		var errorType *types.NotFoundException
		if errors.As(err, &errorType) {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// OutputActiveWaiterOptions are waiter options for OutputActiveWaiter
type OutputActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// OutputActiveWaiter will use default minimum delay of 3 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, OutputActiveWaiter will use default max delay of 120 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetRouterOutputInput, *GetRouterOutputOutput, error) (bool, error)
}

// OutputActiveWaiter defines the waiters for OutputActive
type OutputActiveWaiter struct {
	client GetRouterOutputAPIClient

	options OutputActiveWaiterOptions
}

// NewOutputActiveWaiter constructs a OutputActiveWaiter.
func NewOutputActiveWaiter(client GetRouterOutputAPIClient, optFns ...func(*OutputActiveWaiterOptions)) *OutputActiveWaiter {
	options := OutputActiveWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = outputActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &OutputActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for OutputActive waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *OutputActiveWaiter) Wait(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for OutputActive waiter and returns the
// output of the successful operation. The maxWaitDur is the maximum wait duration
// the waiter will wait. The maxWaitDur is required and must be greater than zero.
func (w *OutputActiveWaiter) WaitForOutput(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputActiveWaiterOptions)) (*GetRouterOutputOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetRouterOutput(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for OutputActive waiter")
}

func outputActiveStateRetryable(ctx context.Context, input *GetRouterOutputInput, output *GetRouterOutputOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "STARTING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "UPDATING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.ServiceUnavailableException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "ERROR"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// OutputStandbyWaiterOptions are waiter options for OutputStandbyWaiter
type OutputStandbyWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// OutputStandbyWaiter will use default minimum delay of 3 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, OutputStandbyWaiter will use default max delay of 120 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetRouterOutputInput, *GetRouterOutputOutput, error) (bool, error)
}

// OutputStandbyWaiter defines the waiters for OutputStandby
type OutputStandbyWaiter struct {
	client GetRouterOutputAPIClient

	options OutputStandbyWaiterOptions
}

// NewOutputStandbyWaiter constructs a OutputStandbyWaiter.
func NewOutputStandbyWaiter(client GetRouterOutputAPIClient, optFns ...func(*OutputStandbyWaiterOptions)) *OutputStandbyWaiter {
	options := OutputStandbyWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = outputStandbyStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &OutputStandbyWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for OutputStandby waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *OutputStandbyWaiter) Wait(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputStandbyWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for OutputStandby waiter and returns
// the output of the successful operation. The maxWaitDur is the maximum wait
// duration the waiter will wait. The maxWaitDur is required and must be greater
// than zero.
func (w *OutputStandbyWaiter) WaitForOutput(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputStandbyWaiterOptions)) (*GetRouterOutputOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetRouterOutput(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for OutputStandby waiter")
}

func outputStandbyStateRetryable(ctx context.Context, input *GetRouterOutputInput, output *GetRouterOutputOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "STANDBY"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "STOPPING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.ServiceUnavailableException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputState
		if v1 != nil {
			v3 := v1.State
			v2 = v3
		}
		expectedValue := "ERROR"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// OutputRoutedWaiterOptions are waiter options for OutputRoutedWaiter
type OutputRoutedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// OutputRoutedWaiter will use default minimum delay of 3 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, OutputRoutedWaiter will use default max delay of 120 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetRouterOutputInput, *GetRouterOutputOutput, error) (bool, error)
}

// OutputRoutedWaiter defines the waiters for OutputRouted
type OutputRoutedWaiter struct {
	client GetRouterOutputAPIClient

	options OutputRoutedWaiterOptions
}

// NewOutputRoutedWaiter constructs a OutputRoutedWaiter.
func NewOutputRoutedWaiter(client GetRouterOutputAPIClient, optFns ...func(*OutputRoutedWaiterOptions)) *OutputRoutedWaiter {
	options := OutputRoutedWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = outputRoutedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &OutputRoutedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for OutputRouted waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *OutputRoutedWaiter) Wait(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputRoutedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for OutputRouted waiter and returns the
// output of the successful operation. The maxWaitDur is the maximum wait duration
// the waiter will wait. The maxWaitDur is required and must be greater than zero.
func (w *OutputRoutedWaiter) WaitForOutput(ctx context.Context, params *GetRouterOutputInput, maxWaitDur time.Duration, optFns ...func(*OutputRoutedWaiterOptions)) (*GetRouterOutputOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetRouterOutput(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for OutputRouted waiter")
}

func outputRoutedStateRetryable(ctx context.Context, input *GetRouterOutputInput, output *GetRouterOutputOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputRoutedState
		if v1 != nil {
			v3 := v1.RoutedState
			v2 = v3
		}
		expectedValue := "ROUTED"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.RouterOutput
		var v2 types.RouterOutputRoutedState
		if v1 != nil {
			v3 := v1.RoutedState
			v2 = v3
		}
		expectedValue := "ROUTING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.ServiceUnavailableException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetRouterOutputAPIClient is a client that implements the GetRouterOutput
// operation.
type GetRouterOutputAPIClient interface {
	GetRouterOutput(context.Context, *GetRouterOutputInput, ...func(*Options)) (*GetRouterOutputOutput, error)
}

var _ GetRouterOutputAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetRouterOutput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRouterOutput",
	}
}
