// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new router input in AWS Elemental MediaConnect.
func (c *Client) CreateRouterInput(ctx context.Context, params *CreateRouterInputInput, optFns ...func(*Options)) (*CreateRouterInputOutput, error) {
	if params == nil {
		params = &CreateRouterInputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRouterInput", params, optFns, c.addOperationCreateRouterInputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRouterInputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRouterInputInput struct {

	// The configuration settings for the router input, which can include the
	// protocol, network interface, and other details.
	//
	// This member is required.
	Configuration types.RouterInputConfiguration

	// The maximum bitrate for the router input.
	//
	// This member is required.
	MaximumBitrate *int64

	// The name of the router input.
	//
	// This member is required.
	Name *string

	// Specifies whether the router input can be assigned to outputs in different
	// Regions. REGIONAL (default) - connects only to outputs in same Region. GLOBAL -
	// connects to outputs in any Region.
	//
	// This member is required.
	RoutingScope types.RoutingScope

	// The tier level for the router input.
	//
	// This member is required.
	Tier types.RouterInputTier

	// The Availability Zone where you want to create the router input. This must be a
	// valid Availability Zone for the region specified by regionName , or the current
	// region if no regionName is provided.
	AvailabilityZone *string

	// A unique identifier for the request to ensure idempotency.
	ClientToken *string

	// The maintenance configuration settings for the router input, including
	// preferred maintenance windows and schedules.
	MaintenanceConfiguration types.MaintenanceConfiguration

	// The AWS Region for the router input. Defaults to the current region if not
	// specified.
	RegionName *string

	// Key-value pairs that can be used to tag and organize this router input.
	Tags map[string]string

	// The transit encryption settings for the router input.
	TransitEncryption *types.RouterInputTransitEncryption

	noSmithyDocumentSerde
}

type CreateRouterInputOutput struct {

	// The newly-created router input.
	//
	// This member is required.
	RouterInput *types.RouterInput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRouterInputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRouterInput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRouterInput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRouterInput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateRouterInputMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRouterInputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRouterInput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateRouterInput struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateRouterInput) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateRouterInput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateRouterInputInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateRouterInputInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateRouterInputMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateRouterInput{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateRouterInput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRouterInput",
	}
}
