// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplaceagreement

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/marketplaceagreement/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches across all agreements that a proposer has in AWS Marketplace. The
// search returns a list of agreements with basic agreement information.
//
// The following filter combinations are supported when the PartyType is Proposer :
//
//   - AgreementType
//
//   - AgreementType + EndTime
//
//   - AgreementType + ResourceType
//
//   - AgreementType + ResourceType + EndTime
//
//   - AgreementType + ResourceType + Status
//
//   - AgreementType + ResourceType + Status + EndTime
//
//   - AgreementType + ResourceId
//
//   - AgreementType + ResourceId + EndTime
//
//   - AgreementType + ResourceId + Status
//
//   - AgreementType + ResourceId + Status + EndTime
//
//   - AgreementType + AcceptorAccountId
//
//   - AgreementType + AcceptorAccountId + EndTime
//
//   - AgreementType + AcceptorAccountId + Status
//
//   - AgreementType + AcceptorAccountId + Status + EndTime
//
//   - AgreementType + AcceptorAccountId + OfferId
//
//   - AgreementType + AcceptorAccountId + OfferId + Status
//
//   - AgreementType + AcceptorAccountId + OfferId + EndTime
//
//   - AgreementType + AcceptorAccountId + OfferId + Status + EndTime
//
//   - AgreementType + AcceptorAccountId + ResourceId
//
//   - AgreementType + AcceptorAccountId + ResourceId + Status
//
//   - AgreementType + AcceptorAccountId + ResourceId + EndTime
//
//   - AgreementType + AcceptorAccountId + ResourceId + Status + EndTime
//
//   - AgreementType + AcceptorAccountId + ResourceType
//
//   - AgreementType + AcceptorAccountId + ResourceType + EndTime
//
//   - AgreementType + AcceptorAccountId + ResourceType + Status
//
//   - AgreementType + AcceptorAccountId + ResourceType + Status + EndTime
//
//   - AgreementType + Status
//
//   - AgreementType + Status + EndTime
//
//   - AgreementType + OfferId
//
//   - AgreementType + OfferId + EndTime
//
//   - AgreementType + OfferId + Status
//
//   - AgreementType + OfferId + Status + EndTime
//
//   - AgreementType + OfferSetId
//
//   - AgreementType + OfferSetId + EndTime
//
//   - AgreementType + OfferSetId + Status
//
//   - AgreementType + OfferSetId + Status + EndTime
//
// To filter by EndTime , you can use either BeforeEndTime or AfterEndTime . Only
// EndTime is supported for sorting.
func (c *Client) SearchAgreements(ctx context.Context, params *SearchAgreementsInput, optFns ...func(*Options)) (*SearchAgreementsOutput, error) {
	if params == nil {
		params = &SearchAgreementsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchAgreements", params, optFns, c.addOperationSearchAgreementsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchAgreementsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchAgreementsInput struct {

	// The catalog in which the agreement was created.
	Catalog *string

	// The filter name and value pair used to return a specific list of results.
	//
	// The following filters are supported:
	//
	//   - ResourceIdentifier – The unique identifier of the resource.
	//
	//   - ResourceType – Type of the resource, which is the product ( AmiProduct ,
	//   ContainerProduct , SaaSProduct , ProfessionalServicesProduct , or
	//   MachineLearningProduct ).
	//
	//   - PartyType – The party type of the caller. For agreements where the caller is
	//   the proposer, use the Proposer filter.
	//
	//   - AcceptorAccountId – The AWS account ID of the party accepting the agreement
	//   terms.
	//
	//   - OfferId – The unique identifier of the offer in which the terms are
	//   registered in the agreement token.
	//
	//   - Status – The current status of the agreement. Values include ACTIVE ,
	//   ARCHIVED , CANCELLED , EXPIRED , RENEWED , REPLACED , and TERMINATED .
	//
	//   - BeforeEndTime – A date used to filter agreements with a date before the
	//   endTime of an agreement.
	//
	//   - AfterEndTime – A date used to filter agreements with a date after the
	//   endTime of an agreement.
	//
	//   - AgreementType – The type of agreement. Supported value includes
	//   PurchaseAgreement .
	//
	//   - OfferSetId – A unique identifier for the offer set containing this offer.
	//   All agreements created from offers in this set include this identifier as
	//   context.
	Filters []types.Filter

	// The maximum number of agreements to return in the response.
	MaxResults *int32

	// A token to specify where to start pagination.
	NextToken *string

	// An object that contains the SortBy and SortOrder attributes. Only EndTime is
	// supported for SearchAgreements . The default sort is EndTime descending.
	Sort *types.Sort

	noSmithyDocumentSerde
}

type SearchAgreementsOutput struct {

	// A summary of the agreement, including top-level attributes (for example, the
	// agreement ID, proposer, and acceptor).
	AgreementViewSummaries []types.AgreementViewSummary

	// The token used for pagination. The field is null if there are no more results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchAgreementsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpSearchAgreements{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpSearchAgreements{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchAgreements"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchAgreements(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchAgreementsPaginatorOptions is the paginator options for SearchAgreements
type SearchAgreementsPaginatorOptions struct {
	// The maximum number of agreements to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchAgreementsPaginator is a paginator for SearchAgreements
type SearchAgreementsPaginator struct {
	options   SearchAgreementsPaginatorOptions
	client    SearchAgreementsAPIClient
	params    *SearchAgreementsInput
	nextToken *string
	firstPage bool
}

// NewSearchAgreementsPaginator returns a new SearchAgreementsPaginator
func NewSearchAgreementsPaginator(client SearchAgreementsAPIClient, params *SearchAgreementsInput, optFns ...func(*SearchAgreementsPaginatorOptions)) *SearchAgreementsPaginator {
	if params == nil {
		params = &SearchAgreementsInput{}
	}

	options := SearchAgreementsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchAgreementsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchAgreementsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchAgreements page.
func (p *SearchAgreementsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchAgreementsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchAgreements(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchAgreementsAPIClient is a client that implements the SearchAgreements
// operation.
type SearchAgreementsAPIClient interface {
	SearchAgreements(context.Context, *SearchAgreementsInput, ...func(*Options)) (*SearchAgreementsOutput, error)
}

var _ SearchAgreementsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchAgreements(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchAgreements",
	}
}
