// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation is no longer current and may be deprecated in the future. We
// recommend upgrading to the Maps API V2 unless you require Grab data.
//
//   - CreateMap is part of a previous Amazon Location Service Maps API (version 1)
//     which has been superseded by a more intuitive, powerful, and complete API
//     (version 2).
//
//   - The Maps API version 2 has a simplified interface that can be used without
//     creating or managing map resources.
//
//   - If you are using an AWS SDK or the AWS CLI, note that the Maps API version
//     2 is found under geo-maps or geo_maps , not under location .
//
//   - Since Grab is not yet fully supported in Maps API version 2, we recommend
//     you continue using API version 1 when using Grab .
//
//   - Start your version 2 API journey with the [Maps V2 API Reference]or the [Developer Guide].
//
// Creates a map resource in your Amazon Web Services account, which provides map
// tiles of different styles sourced from global location data providers.
//
// If your application is tracking or routing assets you use in your business,
// such as delivery vehicles or employees, you must not use Esri as your
// geolocation provider. See section 82 of the [Amazon Web Services service terms]for more details.
//
// [Amazon Web Services service terms]: http://aws.amazon.com/service-terms
// [Maps V2 API Reference]: https://docs.aws.amazon.com/location/latest/APIReference/API_Operations_Amazon_Location_Service_Maps_V2.html
// [Developer Guide]: https://docs.aws.amazon.com/location/latest/developerguide/maps.html
func (c *Client) CreateMap(ctx context.Context, params *CreateMapInput, optFns ...func(*Options)) (*CreateMapOutput, error) {
	if params == nil {
		params = &CreateMapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMap", params, optFns, c.addOperationCreateMapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMapInput struct {

	// Specifies the MapConfiguration , including the map style, for the map resource
	// that you create. The map style defines the look of maps and the data provider
	// for your map resource.
	//
	// This member is required.
	Configuration *types.MapConfiguration

	// The name for the map resource.
	//
	// Requirements:
	//
	//   - Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-),
	//   periods (.), and underscores (_).
	//
	//   - Must be a unique map resource name.
	//
	//   - No spaces allowed. For example, ExampleMap .
	//
	// This member is required.
	MapName *string

	// An optional description for the map resource.
	Description *string

	// No longer used. If included, the only allowed value is RequestBasedUsage .
	//
	// Deprecated: Deprecated. If included, the only allowed value is
	// RequestBasedUsage.
	PricingPlan types.PricingPlan

	// Applies one or more tags to the map resource. A tag is a key-value pair helps
	// manage, identify, search, and filter your resources by labelling them.
	//
	// Format: "key" : "value"
	//
	// Restrictions:
	//
	//   - Maximum 50 tags per resource
	//
	//   - Each resource tag must be unique with a maximum of one value.
	//
	//   - Maximum key length: 128 Unicode characters in UTF-8
	//
	//   - Maximum value length: 256 Unicode characters in UTF-8
	//
	//   - Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
	//   characters: + - = . _ : / @.
	//
	//   - Cannot use "aws:" as a prefix for a key.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateMapOutput struct {

	// The timestamp for when the map resource was created in [ISO 8601] format:
	// YYYY-MM-DDThh:mm:ss.sssZ .
	//
	// [ISO 8601]: https://www.iso.org/iso-8601-date-and-time-format.html
	//
	// This member is required.
	CreateTime *time.Time

	// The Amazon Resource Name (ARN) for the map resource. Used to specify a resource
	// across all Amazon Web Services.
	//
	//   - Format example: arn:aws:geo:region:account-id:map/ExampleMap
	//
	// This member is required.
	MapArn *string

	// The name of the map resource.
	//
	// This member is required.
	MapName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateMapMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateMapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateMapMiddleware struct {
}

func (*endpointPrefix_opCreateMapMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateMapMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "cp.maps." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateMapMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateMapMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreateMap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMap",
	}
}
