// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The active context used in the test execution.
type ActiveContext struct {

	// The name of active context.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Provides settings that enable advanced recognition settings for slot values.
type AdvancedRecognitionSetting struct {

	// Enables using the slot values as a custom vocabulary for recognizing user
	// utterances.
	AudioRecognitionStrategy AudioRecognitionStrategy

	noSmithyDocumentSerde
}

// The information about the agent turn in a test set execution.
type AgentTurnResult struct {

	// The expected agent prompt for the agent turn in a test set execution.
	//
	// This member is required.
	ExpectedAgentPrompt *string

	// The actual agent prompt for the agent turn in a test set execution.
	ActualAgentPrompt *string

	// The actual elicited slot for the agent turn in a test set execution.
	ActualElicitedSlot *string

	// The actual intent for the agent turn in a test set execution.
	ActualIntent *string

	// Details about an error in an execution of a test set.
	ErrorDetails *ExecutionErrorDetails

	noSmithyDocumentSerde
}

// The specification of an agent turn.
type AgentTurnSpecification struct {

	// The agent prompt for the agent turn in a test set.
	//
	// This member is required.
	AgentPrompt *string

	noSmithyDocumentSerde
}

// Filters responses returned by the ListAggregatedUtterances operation.
type AggregatedUtterancesFilter struct {

	// The name of the field to filter the utterance list.
	//
	// This member is required.
	Name AggregatedUtterancesFilterName

	// The operator to use for the filter. Specify EQ when the ListAggregatedUtterances
	// operation should return only utterances that equal the specified value. Specify
	// CO when the ListAggregatedUtterances operation should return utterances that
	// contain the specified value.
	//
	// This member is required.
	Operator AggregatedUtterancesFilterOperator

	// The value to use for filtering the list of bots.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of utterances.
type AggregatedUtterancesSortBy struct {

	// The utterance attribute to sort by.
	//
	// This member is required.
	Attribute AggregatedUtterancesSortAttribute

	// Specifies whether to sort the aggregated utterances in ascending or descending
	// order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Provides summary information for aggregated utterances. The
// ListAggregatedUtterances operations combines all instances of the same utterance
// into a single aggregated summary.
type AggregatedUtterancesSummary struct {

	// Aggregated utterance data may contain utterances from versions of your bot that
	// have since been deleted. When the aggregated contains this kind of data, this
	// field is set to true.
	ContainsDataFromDeletedResources *bool

	// The number of times that the utterance was detected by Amazon Lex during the
	// time period. When an utterance is detected, it activates an intent or a slot.
	HitCount *int32

	// The number of times that the utterance was missed by Amazon Lex An utterance is
	// missed when it doesn't activate an intent or slot.
	MissedCount *int32

	// The text of the utterance. If the utterance was used with the RecognizeUtterance
	// operation, the text is the transcription of the audio utterance.
	Utterance *string

	// The date and time that the utterance was first recorded in the time window for
	// aggregation. An utterance may have been sent to Amazon Lex before that time, but
	// only utterances within the time window are counted.
	UtteranceFirstRecordedInAggregationDuration *time.Time

	// The last date and time that an utterance was recorded in the time window for
	// aggregation. An utterance may be sent to Amazon Lex after that time, but only
	// utterances within the time window are counted.
	UtteranceLastRecordedInAggregationDuration *time.Time

	noSmithyDocumentSerde
}

// Specifies the allowed input types.
type AllowedInputTypes struct {

	// Indicates whether audio input is allowed.
	//
	// This member is required.
	AllowAudioInput *bool

	// Indicates whether DTMF input is allowed.
	//
	// This member is required.
	AllowDTMFInput *bool

	noSmithyDocumentSerde
}

// Contains the time metric, interval, and method by which to bin the analytics
// data.
type AnalyticsBinBySpecification struct {

	// Specifies the interval of time by which to bin the analytics data.
	//
	// This member is required.
	Interval AnalyticsInterval

	// Specifies the time metric by which to bin the analytics data.
	//
	// This member is required.
	Name AnalyticsBinByName

	// Specifies whether to bin the analytics data in ascending or descending order.
	// If this field is left blank, the default order is by the key of the bin in
	// descending order.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing the criterion by which to bin the results and the value
// that defines that bin.
type AnalyticsBinKey struct {

	// The criterion by which to bin the results.
	Name AnalyticsBinByName

	// The value of the criterion that defines the bin.
	Value *int64

	noSmithyDocumentSerde
}

// Contains fields describing a condition by which to filter the intents. The
// expression may be understood as name
//
//	operator
//
// values . For example:
//
//   - IntentName CO Book – The intent name contains the string "Book."
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ .
//
//   - BotVersion – EQ .
//
//   - LocaleId – EQ .
//
//   - Modality – EQ .
//
//   - Channel – EQ .
//
//   - SessionId – EQ .
//
//   - OriginatingRequestId – EQ .
//
//   - IntentName – EQ , CO .
//
//   - IntentEndState – EQ , CO .
type AnalyticsIntentFilter struct {

	// The category by which to filter the intents. The descriptions for each option
	// are as follows:
	//
	//   - BotAlias – The name of the bot alias.
	//
	//   - BotVersion – The version of the bot.
	//
	//   - LocaleId – The locale of the bot.
	//
	//   - Modality – The modality of the session with the bot (audio, DTMF, or text).
	//
	//   - Channel – The channel that the bot is integrated with.
	//
	//   - SessionId – The identifier of the session with the bot.
	//
	//   - OriginatingRequestId – The identifier of the first request in a session.
	//
	//   - IntentName – The name of the intent.
	//
	//   - IntentEndState – The final state of the intent.
	//
	// This member is required.
	Name AnalyticsIntentFilterName

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//   - CO – Contains
	//
	//   - EQ – Equals
	//
	//   - GT – Greater than
	//
	//   - LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//   - BotAlias – EQ .
	//
	//   - BotVersion – EQ .
	//
	//   - LocaleId – EQ .
	//
	//   - Modality – EQ .
	//
	//   - Channel – EQ .
	//
	//   - SessionId – EQ .
	//
	//   - OriginatingRequestId – EQ .
	//
	//   - IntentName – EQ , CO .
	//
	//   - IntentEndState – EQ , CO .
	//
	// This member is required.
	Operator AnalyticsFilterOperator

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is EQ or
	// CO . If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name , operator , and values fields are
	// Modality , EQ , and [Speech, Text] , the operation filters for results where the
	// modality was either Speech or Text .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the category by which the intent analytics were grouped and a member
// of that category.
type AnalyticsIntentGroupByKey struct {

	// A category by which the intent analytics were grouped.
	Name AnalyticsIntentField

	// A member of the category by which the intent analytics were grouped.
	Value *string

	noSmithyDocumentSerde
}

// Contains the category by which to group the intents.
type AnalyticsIntentGroupBySpecification struct {

	// Specifies whether to group the intent stages by their name or their end state.
	//
	// This member is required.
	Name AnalyticsIntentField

	noSmithyDocumentSerde
}

// Contains the metric and the summary statistic you want to calculate, and the
// order in which to sort the results, for the intents in the bot.
type AnalyticsIntentMetric struct {

	// The metric for which you want to get intent summary statistics.
	//
	//   - Count – The number of times the intent was invoked.
	//
	//   - Success – The number of times the intent succeeded.
	//
	//   - Failure – The number of times the intent failed.
	//
	//   - Switched – The number of times there was a switch to a different intent.
	//
	//   - Dropped – The number of times the user dropped the intent.
	//
	// This member is required.
	Name AnalyticsIntentMetricName

	// The summary statistic to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of intents in the category
	//   you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	//
	// This member is required.
	Statistic AnalyticsMetricStatistic

	// Specifies whether to sort the results in ascending or descending order.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing the results for the intent metric you requested.
type AnalyticsIntentMetricResult struct {

	// The metric that you requested. See [Key definitions] for more details about these metrics.
	//
	//   - Count – The number of times the intent was invoked.
	//
	//   - Success – The number of times the intent succeeded.
	//
	//   - Failure – The number of times the intent failed.
	//
	//   - Switched – The number of times there was a switch to a different intent.
	//
	//   - Dropped – The number of times the user dropped the intent.
	//
	// [Key definitions]: https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html
	Name AnalyticsIntentMetricName

	// The statistic that you requested to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of intents in the category
	//   you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	Statistic AnalyticsMetricStatistic

	// The value of the summary statistic for the metric that you requested.
	Value *float64

	noSmithyDocumentSerde
}

// An object containing information about the requested path.
type AnalyticsIntentNodeSummary struct {

	// The total number of sessions that follow the given path to the given intent.
	IntentCount *int32

	// The number of intents up to and including the requested path.
	IntentLevel *int32

	// The name of the intent at the end of the requested path.
	IntentName *string

	// The path.
	IntentPath *string

	// Specifies whether the node is the end of a path ( Exit ) or not ( Inner ).
	NodeType AnalyticsNodeType

	noSmithyDocumentSerde
}

// An object containing the results for the intent metrics you requested and the
// bin and/or group(s) they refer to, if applicable.
type AnalyticsIntentResult struct {

	// A list of objects containing the criteria you requested for binning results and
	// the values of the bins.
	BinKeys []AnalyticsBinKey

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the groups.
	GroupByKeys []AnalyticsIntentGroupByKey

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []AnalyticsIntentMetricResult

	noSmithyDocumentSerde
}

// Contains fields describing a condition by which to filter the intent stages.
// The expression may be understood as name
//
//	operator
//
// values . For example:
//
//   - IntentName CO Book – The intent name contains the string "Book."
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ .
//
//   - BotVersion – EQ .
//
//   - LocaleId – EQ .
//
//   - Modality – EQ .
//
//   - Channel – EQ .
//
//   - SessionId – EQ .
//
//   - OriginatingRequestId – EQ .
//
//   - IntentName – EQ , CO .
//
//   - IntentStageName – EQ , CO .
type AnalyticsIntentStageFilter struct {

	// The category by which to filter the intent stages. The descriptions for each
	// option are as follows:
	//
	//   - BotAlias – The name of the bot alias.
	//
	//   - BotVersion – The version of the bot.
	//
	//   - LocaleId – The locale of the bot.
	//
	//   - Modality – The modality of the session with the bot (audio, DTMF, or text).
	//
	//   - Channel – The channel that the bot is integrated with.
	//
	//   - SessionId – The identifier of the session with the bot.
	//
	//   - OriginatingRequestId – The identifier of the first request in a session.
	//
	//   - IntentName – The name of the intent.
	//
	//   - IntentStageName – The stage in the intent.
	//
	// This member is required.
	Name AnalyticsIntentStageFilterName

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//   - CO – Contains
	//
	//   - EQ – Equals
	//
	//   - GT – Greater than
	//
	//   - LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//   - BotAlias – EQ .
	//
	//   - BotVersion – EQ .
	//
	//   - LocaleId – EQ .
	//
	//   - Modality – EQ .
	//
	//   - Channel – EQ .
	//
	//   - SessionId – EQ .
	//
	//   - OriginatingRequestId – EQ .
	//
	//   - IntentName – EQ , CO .
	//
	//   - IntentStageName – EQ , CO .
	//
	// This member is required.
	Operator AnalyticsFilterOperator

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is EQ or
	// CO . If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name , operator , and values fields are
	// Modality , EQ , and [Speech, Text] , the operation filters for results where the
	// modality was either Speech or Text .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the category by which the intent stage analytics and the values for
// that category were grouped.
type AnalyticsIntentStageGroupByKey struct {

	// A category by which the intent stage analytics were grouped.
	Name AnalyticsIntentStageField

	// A member of the category by which the intent stage analytics were grouped.
	Value *string

	noSmithyDocumentSerde
}

// Contains the category by which to group the intent stages.
type AnalyticsIntentStageGroupBySpecification struct {

	// Specifies whether to group the intent stages by their name or the intent to
	// which the session was switched.
	//
	// This member is required.
	Name AnalyticsIntentStageField

	noSmithyDocumentSerde
}

// Contains the metric and the summary statistic you want to calculate, and the
// order in which to sort the results, for the intent stages across the user
// sessions with the bot.
type AnalyticsIntentStageMetric struct {

	// The metric for which you want to get intent stage summary statistics. See [Key definitions] for
	// more details about these metrics.
	//
	//   - Count – The number of times the intent stage occurred.
	//
	//   - Success – The number of times the intent stage succeeded.
	//
	//   - Failure – The number of times the intent stage failed.
	//
	//   - Dropped – The number of times the user dropped the intent stage.
	//
	//   - Retry – The number of times the bot tried to elicit a response from the user
	//   at this stage.
	//
	// [Key definitions]: https://docs.aws.amazon.com/lexv2/latest/dg/analytics-key-definitions.html
	//
	// This member is required.
	Name AnalyticsIntentStageMetricName

	// The summary statistic to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of intent stages in the
	//   category you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	//
	// This member is required.
	Statistic AnalyticsMetricStatistic

	// Specifies whether to sort the results in ascending or descending order of the
	// summary statistic ( value in the response).
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing the results for an intent stage metric you requested.
type AnalyticsIntentStageMetricResult struct {

	// The metric that you requested.
	//
	//   - Count – The number of times the intent stage occurred.
	//
	//   - Success – The number of times the intent stage succeeded.
	//
	//   - Failure – The number of times the intent stage failed.
	//
	//   - Dropped – The number of times the user dropped the intent stage.
	//
	//   - Retry – The number of times the bot tried to elicit a response from the user
	//   at this stage.
	Name AnalyticsIntentStageMetricName

	// The summary statistic that you requested to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of intent stages in the
	//   category you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	Statistic AnalyticsMetricStatistic

	// The value of the summary statistic for the metric that you requested.
	Value *float64

	noSmithyDocumentSerde
}

// An object containing the results for the intent stage metrics you requested and
// the bin and/or group they refer to, if applicable.
type AnalyticsIntentStageResult struct {

	// A list of objects containing the criteria you requested for binning results and
	// the values of the bins.
	BinKeys []AnalyticsBinKey

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []AnalyticsIntentStageGroupByKey

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []AnalyticsIntentStageMetricResult

	noSmithyDocumentSerde
}

// Contains fields describing a condition by which to filter the paths. The
// expression may be understood as name
//
//	operator
//
// values . For example:
//
//   - LocaleId EQ en – The locale is "en".
//
//   - BotVersion EQ 2 – The bot version is equal to two.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ .
//
//   - BotVersion – EQ .
//
//   - LocaleId – EQ .
//
//   - Modality – EQ .
//
//   - Channel – EQ .
type AnalyticsPathFilter struct {

	// The category by which to filter the intent paths. The descriptions for each
	// option are as follows:
	//
	//   - BotAlias – The name of the bot alias.
	//
	//   - BotVersion – The version of the bot.
	//
	//   - LocaleId – The locale of the bot.
	//
	//   - Modality – The modality of the session with the bot (audio, DTMF, or text).
	//
	//   - Channel – The channel that the bot is integrated with.
	//
	// This member is required.
	Name AnalyticsCommonFilterName

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//   - CO – Contains
	//
	//   - EQ – Equals
	//
	//   - GT – Greater than
	//
	//   - LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//   - BotAlias – EQ .
	//
	//   - BotVersion – EQ .
	//
	//   - LocaleId – EQ .
	//
	//   - Modality – EQ .
	//
	//   - Channel – EQ .
	//
	// This member is required.
	Operator AnalyticsFilterOperator

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is EQ or
	// CO . If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name , operator , and values fields are
	// Modality , EQ , and [Speech, Text] , the operation filters for results where the
	// modality was either Speech or Text .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains fields describing a condition by which to filter the sessions. The
// expression may be understood as name
//
//	operator
//
// values . For example:
//
//   - LocaleId EQ en – The locale is "en".
//
//   - Duration GT 200 – The duration is greater than 200 seconds.
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ .
//
//   - BotVersion – EQ .
//
//   - LocaleId – EQ .
//
//   - Modality – EQ .
//
//   - Channel – EQ .
//
//   - Duration – EQ , GT , LT .
//
//   - conversationEndState – EQ , CO .
//
//   - SessionId – EQ .
//
//   - OriginatingRequestId – EQ .
//
//   - IntentPath – EQ .
type AnalyticsSessionFilter struct {

	// The category by which to filter the sessions. The descriptions for each option
	// are as follows:
	//
	//   - BotAlias – The name of the bot alias.
	//
	//   - BotVersion – The version of the bot.
	//
	//   - LocaleId – The locale of the bot.
	//
	//   - Modality – The modality of the session with the bot (audio, DTMF, or text).
	//
	//   - Channel – The channel that the bot is integrated with.
	//
	//   - Duration – The duration of the session.
	//
	//   - conversationEndState – The final state of the session.
	//
	//   - SessionId – The identifier of the session with the bot.
	//
	//   - OriginatingRequestId – The identifier of the first request in a session.
	//
	//   - IntentPath – The order of intents taken in a session.
	//
	// This member is required.
	Name AnalyticsSessionFilterName

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//   - CO – Contains
	//
	//   - EQ – Equals
	//
	//   - GT – Greater than
	//
	//   - LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//   - BotAlias – EQ .
	//
	//   - BotVersion – EQ .
	//
	//   - LocaleId – EQ .
	//
	//   - Modality – EQ .
	//
	//   - Channel – EQ .
	//
	//   - Duration – EQ , GT , LT .
	//
	//   - conversationEndState – EQ , CO .
	//
	//   - SessionId – EQ .
	//
	//   - OriginatingRequestId – EQ .
	//
	//   - IntentPath – EQ .
	//
	// This member is required.
	Operator AnalyticsFilterOperator

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is EQ or
	// CO . If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name , operator , and values fields are
	// Modality , EQ , and [Speech, Text] , the operation filters for results where the
	// modality was either Speech or Text .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the category by which the session analytics were grouped and a member
// of that category.
type AnalyticsSessionGroupByKey struct {

	// The category by which the session analytics were grouped.
	Name AnalyticsSessionField

	// A member of the category by which the session analytics were grouped.
	Value *string

	noSmithyDocumentSerde
}

// Contains the category by which to group the sessions.
type AnalyticsSessionGroupBySpecification struct {

	// Specifies whether to group the session by their end state or their locale.
	//
	// This member is required.
	Name AnalyticsSessionField

	noSmithyDocumentSerde
}

// Contains the metric and the summary statistic you want to calculate, and the
// order in which to sort the results, for the user sessions with the bot.
type AnalyticsSessionMetric struct {

	// The metric for which you want to get session summary statistics.
	//
	//   - Count – The number of sessions.
	//
	//   - Success – The number of sessions that succeeded.
	//
	//   - Failure – The number of sessions that failed.
	//
	//   - Dropped – The number of sessions that the user dropped.
	//
	//   - Duration – The duration of sessions.
	//
	//   - TurnsPerSession – The number of turns in the sessions.
	//
	//   - Concurrency – The number of sessions occurring in the same period of time.
	//
	// This member is required.
	Name AnalyticsSessionMetricName

	// The summary statistic to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of sessions in the category
	//   you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	//
	// This member is required.
	Statistic AnalyticsMetricStatistic

	// Specifies whether to sort the results in ascending or descending order.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing the results for a session metric you requested.
type AnalyticsSessionMetricResult struct {

	// The metric that you requested.
	//
	//   - Count – The number of sessions.
	//
	//   - Success – The number of sessions that succeeded.
	//
	//   - Failure – The number of sessions that failed.
	//
	//   - Dropped – The number of sessions that the user dropped.
	//
	//   - Duration – The duration of sessions.
	//
	//   - TurnPersession – The number of turns in the sessions.
	//
	//   - Concurrency – The number of sessions occurring in the same period of time.
	Name AnalyticsSessionMetricName

	// The summary statistic that you requested to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of sessions in the category
	//   you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	Statistic AnalyticsMetricStatistic

	// The value of the summary statistic for the metric that you requested.
	Value *float64

	noSmithyDocumentSerde
}

// An object containing the results for the session metrics you requested and the
// bin and/or group(s) they refer to, if applicable.
type AnalyticsSessionResult struct {

	// A list of objects containing the criteria you requested for binning results and
	// the values of the bins.
	BinKeys []AnalyticsBinKey

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []AnalyticsSessionGroupByKey

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []AnalyticsSessionMetricResult

	noSmithyDocumentSerde
}

// An object that specifies the last used intent at the time of the utterance as
// an attribute to return.
type AnalyticsUtteranceAttribute struct {

	// An attribute to return. The only available attribute is the intent that the bot
	// mapped the utterance to.
	//
	// This member is required.
	Name AnalyticsUtteranceAttributeName

	noSmithyDocumentSerde
}

// An object containing the intent that the bot mapped the utterance to.
type AnalyticsUtteranceAttributeResult struct {

	// The intent that the bot mapped the utterance to.
	LastUsedIntent *string

	noSmithyDocumentSerde
}

// Contains fields describing a condition by which to filter the utterances. The
// expression may be understood as name
//
//	operator
//
// values . For example:
//
//   - LocaleId EQ Book – The locale is the string "en".
//
//   - UtteranceText CO help – The text of the utterance contains the string "help".
//
// The operators that each filter supports are listed below:
//
//   - BotAlias – EQ .
//
//   - BotVersion – EQ .
//
//   - LocaleId – EQ .
//
//   - Modality – EQ .
//
//   - Channel – EQ .
//
//   - SessionId – EQ .
//
//   - OriginatingRequestId – EQ .
//
//   - UtteranceState – EQ .
//
//   - UtteranceText – EQ , CO .
type AnalyticsUtteranceFilter struct {

	// The category by which to filter the utterances. The descriptions for each
	// option are as follows:
	//
	//   - BotAlias – The name of the bot alias.
	//
	//   - BotVersion – The version of the bot.
	//
	//   - LocaleId – The locale of the bot.
	//
	//   - Modality – The modality of the session with the bot (audio, DTMF, or text).
	//
	//   - Channel – The channel that the bot is integrated with.
	//
	//   - SessionId – The identifier of the session with the bot.
	//
	//   - OriginatingRequestId – The identifier of the first request in a session.
	//
	//   - UtteranceState – The state of the utterance.
	//
	//   - UtteranceText – The text in the utterance.
	//
	// This member is required.
	Name AnalyticsUtteranceFilterName

	// The operation by which to filter the category. The following operations are
	// possible:
	//
	//   - CO – Contains
	//
	//   - EQ – Equals
	//
	//   - GT – Greater than
	//
	//   - LT – Less than
	//
	// The operators that each filter supports are listed below:
	//
	//   - BotAlias – EQ .
	//
	//   - BotVersion – EQ .
	//
	//   - LocaleId – EQ .
	//
	//   - Modality – EQ .
	//
	//   - Channel – EQ .
	//
	//   - SessionId – EQ .
	//
	//   - OriginatingRequestId – EQ .
	//
	//   - UtteranceState – EQ .
	//
	//   - UtteranceText – EQ , CO .
	//
	// This member is required.
	Operator AnalyticsFilterOperator

	// An array containing the values of the category by which to apply the operator
	// to filter the results. You can provide multiple values if the operator is EQ or
	// CO . If you provide multiple values, you filter for results that equal/contain
	// any of the values. For example, if the name , operator , and values fields are
	// Modality , EQ , and [Speech, Text] , the operation filters for results where the
	// modality was either Speech or Text .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the category by which the utterance analytics were grouped and the
// values for that category.
type AnalyticsUtteranceGroupByKey struct {

	// The category by which the utterance analytics were grouped.
	Name AnalyticsUtteranceField

	// A member of the category by which the utterance analytics were grouped.
	Value *string

	noSmithyDocumentSerde
}

// Contains the category by which to group the utterances.
type AnalyticsUtteranceGroupBySpecification struct {

	// Specifies whether to group the utterances by their text or their state.
	//
	// This member is required.
	Name AnalyticsUtteranceField

	noSmithyDocumentSerde
}

// Contains the metric and the summary statistic you want to calculate, and the
// order in which to sort the results, for the utterances across the user sessions
// with the bot.
type AnalyticsUtteranceMetric struct {

	// The metric for which you want to get utterance summary statistics.
	//
	//   - Count – The number of utterances.
	//
	//   - Missed – The number of utterances that Amazon Lex failed to recognize.
	//
	//   - Detected – The number of utterances that Amazon Lex managed to detect.
	//
	//   - UtteranceTimestamp – The date and time of the utterance.
	//
	// This member is required.
	Name AnalyticsUtteranceMetricName

	// The summary statistic to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of utterances in the
	//   category you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	//
	// This member is required.
	Statistic AnalyticsMetricStatistic

	// Specifies whether to sort the results in ascending or descending order.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing the results for the utterance metric you requested.
type AnalyticsUtteranceMetricResult struct {

	// The metric that you requested.
	//
	//   - Count – The number of utterances.
	//
	//   - Missed – The number of utterances that Amazon Lex failed to recognize.
	//
	//   - Detected – The number of utterances that Amazon Lex managed to detect.
	//
	//   - UtteranceTimestamp – The date and time of the utterance.
	Name AnalyticsUtteranceMetricName

	// The summary statistic that you requested to calculate.
	//
	//   - Sum – The total count for the category you provide in name .
	//
	//   - Average – The total count divided by the number of utterances in the
	//   category you provide in name .
	//
	//   - Max – The highest count in the category you provide in name .
	Statistic AnalyticsMetricStatistic

	// The value of the summary statistic for the metric that you requested.
	Value *float64

	noSmithyDocumentSerde
}

// An object containing the results for the utterance metrics you requested and
// the bin and/or group(s) they refer to, if applicable.
type AnalyticsUtteranceResult struct {

	// A list of objects containing information about the last used intent at the time
	// of an utterance.
	AttributeResults []AnalyticsUtteranceAttributeResult

	// A list of objects containing the criteria you requested for binning results and
	// the values of the bins.
	BinKeys []AnalyticsBinKey

	// A list of objects containing the criteria you requested for grouping results
	// and the values of the bins.
	GroupByKeys []AnalyticsUtteranceGroupByKey

	// A list of objects, each of which contains a metric you want to list, the
	// statistic for the metric you want to return, and the method by which to organize
	// the results.
	MetricsResults []AnalyticsUtteranceMetricResult

	noSmithyDocumentSerde
}

// The object containing information that associates the recommended intent/slot
// type with a conversation.
type AssociatedTranscript struct {

	// The content of the transcript that meets the search filter criteria. For the
	// JSON format of the transcript, see [Output transcript format].
	//
	// [Output transcript format]: https://docs.aws.amazon.com/lexv2/latest/dg/designing-output-format.html
	Transcript *string

	noSmithyDocumentSerde
}

// Filters to search for the associated transcript.
type AssociatedTranscriptFilter struct {

	// The name of the field to use for filtering. The allowed names are IntentId and
	// SlotTypeId.
	//
	// This member is required.
	Name AssociatedTranscriptFilterName

	// The values to use to filter the transcript.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies the audio and DTMF input specification.
type AudioAndDTMFInputSpecification struct {

	// Time for which a bot waits before assuming that the customer isn't going to
	// speak or press a key. This timeout is shared between Audio and DTMF inputs.
	//
	// This member is required.
	StartTimeoutMs *int32

	// Specifies the settings on audio input.
	AudioSpecification *AudioSpecification

	// Specifies the settings on DTMF input.
	DtmfSpecification *DTMFSpecification

	noSmithyDocumentSerde
}

// The location of audio log files collected when conversation logging is enabled
// for a bot.
type AudioLogDestination struct {

	// The Amazon S3 bucket where the audio log files are stored. The IAM role
	// specified in the roleArn parameter of the [CreateBot] operation must have permission to
	// write to this bucket.
	//
	// [CreateBot]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_CreateBot.html
	//
	// This member is required.
	S3Bucket *S3BucketLogDestination

	noSmithyDocumentSerde
}

// Settings for logging audio of conversations between Amazon Lex and a user. You
// specify whether to log audio and the Amazon S3 bucket where the audio file is
// stored.
type AudioLogSetting struct {

	// The location of audio log files collected when conversation logging is enabled
	// for a bot.
	//
	// This member is required.
	Destination *AudioLogDestination

	// Determines whether audio logging in enabled for the bot.
	//
	// This member is required.
	Enabled bool

	// The option to enable selective conversation log capture for audio.
	SelectiveLoggingEnabled *bool

	noSmithyDocumentSerde
}

// Specifies the audio input specifications.
type AudioSpecification struct {

	// Time for which a bot waits after the customer stops speaking to assume the
	// utterance is finished.
	//
	// This member is required.
	EndTimeoutMs *int32

	// Time for how long Amazon Lex waits before speech input is truncated and the
	// speech is returned to application.
	//
	// This member is required.
	MaxLengthMs *int32

	noSmithyDocumentSerde
}

// The details on the Bedrock guardrail configuration.
type BedrockGuardrailConfiguration struct {

	// The unique guardrail id for the Bedrock guardrail configuration.
	//
	// This member is required.
	Identifier *string

	// The guardrail version for the Bedrock guardrail configuration.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Contains details about the configuration of a Amazon Bedrock knowledge base.
type BedrockKnowledgeStoreConfiguration struct {

	// The base ARN of the knowledge base used.
	//
	// This member is required.
	BedrockKnowledgeBaseArn *string

	// Specifies whether to return an exact response, or to return an answer generated
	// by the model, using the fields you specify from the database.
	ExactResponse bool

	// Contains the names of the fields used for an exact response to the user.
	ExactResponseFields *BedrockKnowledgeStoreExactResponseFields

	noSmithyDocumentSerde
}

// The exact response fields given by the Bedrock knowledge store.
type BedrockKnowledgeStoreExactResponseFields struct {

	// The answer field used for an exact response from Bedrock Knowledge Store.
	AnswerField *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon Bedrock model used to interpret the
// prompt used in descriptive bot building.
type BedrockModelSpecification struct {

	// The ARN of the foundation model used in descriptive bot building.
	//
	// This member is required.
	ModelArn *string

	// The custom prompt used in the Bedrock model specification details.
	CustomPrompt *string

	// The guardrail configuration in the Bedrock model specification details.
	Guardrail *BedrockGuardrailConfiguration

	// The Bedrock trace status in the Bedrock model specification details.
	TraceStatus BedrockTraceStatus

	noSmithyDocumentSerde
}

// Provides a record of an event that affects a bot alias. For example, when the
// version of a bot that the alias points to changes.
type BotAliasHistoryEvent struct {

	// The version of the bot that was used in the event.
	BotVersion *string

	// The date and time that the event ended.
	EndDate *time.Time

	// The date and time that the event started.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Specifies settings that are unique to a locale. For example, you can use
// different Lambda function depending on the bot's locale.
type BotAliasLocaleSettings struct {

	// Determines whether the locale is enabled for the bot. If the value is false ,
	// the locale isn't available for use.
	//
	// This member is required.
	Enabled bool

	// Specifies the Lambda function that should be used in the locale.
	CodeHookSpecification *CodeHookSpecification

	noSmithyDocumentSerde
}

// Contains information about all the aliases replication statuses applicable for
// global resiliency.
type BotAliasReplicaSummary struct {

	// The bot alias ID for all the alias bot replications.
	BotAliasId *string

	// The replication statuses for all the alias bot replications.
	BotAliasReplicationStatus BotAliasReplicationStatus

	// The bot version for all the alias bot replications.
	BotVersion *string

	// The creation time and date for all the alias bot replications.
	CreationDateTime *time.Time

	// The reasons for failure for the aliases bot replications.
	FailureReasons []string

	// The last time and date updated for all the alias bot replications.
	LastUpdatedDateTime *time.Time

	noSmithyDocumentSerde
}

// Summary information about bot aliases returned from the [ListBotAliases] operation.
//
// [ListBotAliases]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotAliases.html
type BotAliasSummary struct {

	// The unique identifier assigned to the bot alias. You can use this ID to get
	// detailed information about the alias using the [DescribeBotAlias]operation.
	//
	// [DescribeBotAlias]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBotAlias.html
	BotAliasId *string

	// The name of the bot alias.
	BotAliasName *string

	// The current state of the bot alias. If the status is Available , the alias is
	// ready for use.
	BotAliasStatus BotAliasStatus

	// The version of the bot that the bot alias references.
	BotVersion *string

	// A timestamp of the date and time that the bot alias was created.
	CreationDateTime *time.Time

	// The description of the bot alias.
	Description *string

	// A timestamp of the date and time that the bot alias was last updated.
	LastUpdatedDateTime *time.Time

	noSmithyDocumentSerde
}

// The target Amazon S3 location for the test set execution using a bot alias.
type BotAliasTestExecutionTarget struct {

	// The bot alias Id of the bot alias used in the test set execution.
	//
	// This member is required.
	BotAliasId *string

	// The bot Id of the bot alias used in the test set execution.
	//
	// This member is required.
	BotId *string

	// The locale Id of the bot alias used in the test set execution.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// Provides the identity of a the bot that was exported.
type BotExportSpecification struct {

	// The identifier of the bot assigned by Amazon Lex.
	//
	// This member is required.
	BotId *string

	// The version of the bot that was exported. This will be either DRAFT or the
	// version number.
	//
	// This member is required.
	BotVersion *string

	noSmithyDocumentSerde
}

// Filters the responses returned by the ListBots operation.
type BotFilter struct {

	// The name of the field to filter the list of bots.
	//
	// This member is required.
	Name BotFilterName

	// The operator to use for the filter. Specify EQ when the ListBots operation
	// should return only aliases that equal the specified value. Specify CO when the
	// ListBots operation should return aliases that contain the specified value.
	//
	// This member is required.
	Operator BotFilterOperator

	// The value to use for filtering the list of bots.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides the bot parameters required for importing a bot.
type BotImportSpecification struct {

	// The name that Amazon Lex should use for the bot.
	//
	// This member is required.
	BotName *string

	// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
	// provides settings that determine how Amazon Lex handles special cases of
	// securing the data for your bot.
	//
	// This member is required.
	DataPrivacy *DataPrivacy

	// The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
	//
	// This member is required.
	RoleArn *string

	// A list of tags to add to the bot. You can only add tags when you import a bot.
	// You can't use the UpdateBot operation to update tags. To update tags, use the
	// TagResource operation.
	BotTags map[string]string

	// Allows you to configure destinations where error logs will be published during
	// the bot import process.
	ErrorLogSettings *ErrorLogSettings

	// The time, in seconds, that Amazon Lex should keep information about a user's
	// conversation with the bot.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Lex deletes
	// any data provided before the timeout.
	//
	// You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
	IdleSessionTTLInSeconds *int32

	// A list of tags to add to the test alias for a bot. You can only add tags when
	// you import a bot. You can't use the UpdateAlias operation to update tags. To
	// update tags on the test alias, use the TagResource operation.
	TestBotAliasTags map[string]string

	noSmithyDocumentSerde
}

// Provides the bot locale parameters required for exporting a bot locale.
type BotLocaleExportSpecification struct {

	// The identifier of the bot to create the locale for.
	//
	// This member is required.
	BotId *string

	// The version of the bot to export.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale to export. The string must match one
	// of the locales in the bot.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// Filters responses returned by the ListBotLocales operation.
type BotLocaleFilter struct {

	// The name of the field to filter the list of bots.
	//
	// This member is required.
	Name BotLocaleFilterName

	// The operator to use for the filter. Specify EQ when the ListBotLocales
	// operation should return only aliases that equal the specified value. Specify CO
	// when the ListBotLocales operation should return aliases that contain the
	// specified value.
	//
	// This member is required.
	Operator BotLocaleFilterOperator

	// The value to use for filtering the list of bots.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about an event that occurred affecting the bot locale.
type BotLocaleHistoryEvent struct {

	// A description of the event that occurred.
	//
	// This member is required.
	Event *string

	// A timestamp of the date and time that the event occurred.
	//
	// This member is required.
	EventDate *time.Time

	noSmithyDocumentSerde
}

// Provides the bot locale parameters required for importing a bot locale.
type BotLocaleImportSpecification struct {

	// The identifier of the bot to import the locale to.
	//
	// This member is required.
	BotId *string

	// The version of the bot to import the locale to. This can only be the DRAFT
	// version of the bot.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale that the bot will be used in. The
	// string must match one of the supported locales. All of the intents, slot types,
	// and slots used in the bot must have the same locale. For more information, see [Supported languages].
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	//
	// This member is required.
	LocaleId *string

	// Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent
	// , AMAZON.KendraSearchIntent , or both when returning alternative intents.
	// AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they
	// are configured for the bot.
	//
	// For example, suppose a bot is configured with the confidence threshold of 0.80
	// and the AMAZON.FallbackIntent . Amazon Lex returns three alternative intents
	// with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC
	// (0.50). The response from the PostText operation would be:
	//
	//   - AMAZON.FallbackIntent
	//
	//   - IntentA
	//
	//   - IntentB
	//
	//   - IntentC
	NluIntentConfidenceThreshold *float64

	// The sensitivity level for voice activity detection (VAD) in the bot locale.
	// This setting helps optimize speech recognition accuracy by adjusting how the
	// system responds to background noise during voice interactions.
	SpeechDetectionSensitivity SpeechDetectionSensitivity

	// Speech-to-text settings to apply when importing the bot locale configuration.
	SpeechRecognitionSettings *SpeechRecognitionSettings

	// Unified speech settings to apply when importing the bot locale configuration.
	UnifiedSpeechSettings *UnifiedSpeechSettings

	// Defines settings for using an Amazon Polly voice to communicate with a user.
	//
	// Valid values include:
	//
	//   - standard
	//
	//   - neural
	//
	//   - long-form
	//
	//   - generative
	VoiceSettings *VoiceSettings

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of bot locales.
type BotLocaleSortBy struct {

	// The bot locale attribute to sort by.
	//
	// This member is required.
	Attribute BotLocaleSortAttribute

	// Specifies whether to sort the bot locales in ascending or descending order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Summary information about bot locales returned by the [ListBotLocales] operation.
//
// [ListBotLocales]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotLocales.html
type BotLocaleSummary struct {

	// The current status of the bot locale. When the status is Built the locale is
	// ready for use.
	BotLocaleStatus BotLocaleStatus

	// The description of the bot locale.
	Description *string

	// A timestamp of the date and time that the bot locale was last built.
	LastBuildSubmittedDateTime *time.Time

	// A timestamp of the date and time that the bot locale was last updated.
	LastUpdatedDateTime *time.Time

	// The language and locale of the bot locale.
	LocaleId *string

	// The name of the bot locale.
	LocaleName *string

	noSmithyDocumentSerde
}

// A bot that is a member of a network of bots.
type BotMember struct {

	// The alias ID of a bot that is a member of this network of bots.
	//
	// This member is required.
	BotMemberAliasId *string

	// The alias name of a bot that is a member of this network of bots.
	//
	// This member is required.
	BotMemberAliasName *string

	// The unique ID of a bot that is a member of this network of bots.
	//
	// This member is required.
	BotMemberId *string

	// The unique name of a bot that is a member of this network of bots.
	//
	// This member is required.
	BotMemberName *string

	// The version of a bot that is a member of this network of bots.
	//
	// This member is required.
	BotMemberVersion *string

	noSmithyDocumentSerde
}

// The object representing the URL of the bot definition, the URL of the
// associated transcript, and a statistical summary of the bot recommendation
// results.
type BotRecommendationResults struct {

	// The presigned url link of the associated transcript.
	AssociatedTranscriptsUrl *string

	// The presigned URL link of the recommended bot definition.
	BotLocaleExportUrl *string

	// The statistical summary of the bot recommendation results.
	Statistics *BotRecommendationResultStatistics

	noSmithyDocumentSerde
}

// A statistical summary of the bot recommendation results.
type BotRecommendationResultStatistics struct {

	// Statistical information about about the intents associated with the bot
	// recommendation results.
	Intents *IntentStatistics

	// Statistical information about the slot types associated with the bot
	// recommendation results.
	SlotTypes *SlotTypeStatistics

	noSmithyDocumentSerde
}

// A summary of the bot recommendation.
type BotRecommendationSummary struct {

	// The unique identifier of the bot recommendation to be updated.
	//
	// This member is required.
	BotRecommendationId *string

	// The status of the bot recommendation.
	//
	// If the status is Failed, then the reasons for the failure are listed in the
	// failureReasons field.
	//
	// This member is required.
	BotRecommendationStatus BotRecommendationStatus

	// A timestamp of the date and time that the bot recommendation was created.
	CreationDateTime *time.Time

	// A timestamp of the date and time that the bot recommendation was last updated.
	LastUpdatedDateTime *time.Time

	noSmithyDocumentSerde
}

// Contains summary information about all the replication statuses applicable for
// global resiliency.
type BotReplicaSummary struct {

	// The operation status for the replicated bot applicable.
	BotReplicaStatus BotReplicaStatus

	// The creation time and date for the replicated bots.
	CreationDateTime *time.Time

	// The reasons for the failure for the replicated bot.
	FailureReasons []string

	// The replica region used in the replication statuses summary.
	ReplicaRegion *string

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of bots.
type BotSortBy struct {

	// The attribute to use to sort the list of bots.
	//
	// This member is required.
	Attribute BotSortAttribute

	// The order to sort the list. You can choose ascending or descending.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Summary information about a bot returned by the [ListBots] operation.
//
// [ListBots]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBots.html
type BotSummary struct {

	// The unique identifier assigned to the bot. Use this ID to get detailed
	// information about the bot with the [DescribeBot]operation.
	//
	// [DescribeBot]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_DescribeBot.html
	BotId *string

	// The name of the bot.
	BotName *string

	// The current status of the bot. When the status is Available the bot is ready
	// for use.
	BotStatus BotStatus

	// The type of the bot.
	BotType BotType

	// The description of the bot.
	Description *string

	// The date and time that the bot was last updated.
	LastUpdatedDateTime *time.Time

	// The latest numerical version in use for the bot.
	LatestBotVersion *string

	noSmithyDocumentSerde
}

// The version of a bot used for a bot locale.
type BotVersionLocaleDetails struct {

	// The version of a bot used for a bot locale.
	//
	// This member is required.
	SourceBotVersion *string

	noSmithyDocumentSerde
}

// The sort category for the version replicated bots.
type BotVersionReplicaSortBy struct {

	// The attribute of the sort category for the version replicated bots.
	//
	// This member is required.
	Attribute BotVersionReplicaSortAttribute

	// The order of the sort category for the version replicated bots.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Contains summary information for all the version replication statuses
// applicable for Global resiliency.
type BotVersionReplicaSummary struct {

	// The bot version for the summary information for all the version replication
	// statuses.
	BotVersion *string

	// The version replication status for all the replicated bots.
	BotVersionReplicationStatus BotVersionReplicationStatus

	// The creation date and time of the replication status for all the replicated
	// bots.
	CreationDateTime *time.Time

	// The reasons for replication failure for all the replicated bots.
	FailureReasons []string

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of bot versions.
type BotVersionSortBy struct {

	// The attribute to use to sort the list of versions.
	//
	// This member is required.
	Attribute BotVersionSortAttribute

	// The order to sort the list. You can specify ascending or descending order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Summary information about a bot version returned by the [ListBotVersions] operation.
//
// [ListBotVersions]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html
type BotVersionSummary struct {

	// The name of the bot associated with the version.
	BotName *string

	// The status of the bot. When the status is available, the version of the bot is
	// ready for use.
	BotStatus BotStatus

	// The numeric version of the bot, or DRAFT to indicate that this is the version
	// of the bot that can be updated..
	BotVersion *string

	// A timestamp of the date and time that the version was created.
	CreationDateTime *time.Time

	// The description of the version.
	Description *string

	noSmithyDocumentSerde
}

// Contains specifications about the Amazon Lex build time generative AI
// capabilities from Amazon Bedrock that you can turn on for your bot.
type BuildtimeSettings struct {

	// An object containing specifications for the descriptive bot building feature.
	DescriptiveBotBuilder *DescriptiveBotBuilderSpecification

	// Contains specifications for the sample utterance generation feature.
	SampleUtteranceGeneration *SampleUtteranceGenerationSpecification

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of built-in intents.
type BuiltInIntentSortBy struct {

	// The attribute to use to sort the list of built-in intents.
	//
	// This member is required.
	Attribute BuiltInIntentSortAttribute

	// The order to sort the list. You can specify ascending or descending order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Provides summary information about a built-in intent for the [ListBuiltInIntents] operation.
//
// [ListBuiltInIntents]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInIntents.html
type BuiltInIntentSummary struct {

	// The description of the intent.
	Description *string

	// The signature of the built-in intent. Use this to specify the parent intent of
	// a derived intent.
	IntentSignature *string

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of built-in slot types.
type BuiltInSlotTypeSortBy struct {

	// The attribute to use to sort the list of built-in intents.
	//
	// This member is required.
	Attribute BuiltInSlotTypeSortAttribute

	// The order to sort the list. You can choose ascending or descending.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Provides summary information about a built-in slot type for the [ListBuiltInSlotTypes] operation.
//
// [ListBuiltInSlotTypes]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBuiltInSlotTypes.html
type BuiltInSlotTypeSummary struct {

	// The description of the built-in slot type.
	Description *string

	// The signature of the built-in slot type. Use this to specify the parent slot
	// type of a derived slot type.
	SlotTypeSignature *string

	noSmithyDocumentSerde
}

// Describes a button to use on a response card used to gather slot values from a
// user.
type Button struct {

	// The text that appears on the button. Use this to tell the user what value is
	// returned when they choose this button.
	//
	// This member is required.
	Text *string

	// The value returned to Amazon Lex when the user chooses this button. This must
	// be one of the slot values configured for the slot.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The Amazon CloudWatch Logs log group where the text and metadata logs are
// delivered. The log group must exist before you enable logging.
type CloudWatchLogGroupLogDestination struct {

	// The Amazon Resource Name (ARN) of the log group where text and metadata logs
	// are delivered.
	//
	// This member is required.
	CloudWatchLogGroupArn *string

	// The prefix of the log stream name within the log group that you specified
	//
	// This member is required.
	LogPrefix *string

	noSmithyDocumentSerde
}

// Contains information about code hooks that Amazon Lex calls during a
// conversation.
type CodeHookSpecification struct {

	// Specifies a Lambda function that verifies requests to a bot or fulfills the
	// user's request to a bot.
	//
	// This member is required.
	LambdaCodeHook *LambdaCodeHook

	noSmithyDocumentSerde
}

// A composite slot is a combination of two or more slots that capture multiple
// pieces of information in a single user input.
type CompositeSlotTypeSetting struct {

	// Subslots in the composite slot.
	SubSlots []SubSlotTypeComposition

	noSmithyDocumentSerde
}

// Provides an expression that evaluates to true or false.
type Condition struct {

	// The expression string that is evaluated.
	//
	// This member is required.
	ExpressionString *string

	noSmithyDocumentSerde
}

// A set of actions that Amazon Lex should run if the condition is matched.
type ConditionalBranch struct {

	// Contains the expression to evaluate. If the condition is true, the branch's
	// actions are taken.
	//
	// This member is required.
	Condition *Condition

	// The name of the branch.
	//
	// This member is required.
	Name *string

	// The next step in the conversation.
	//
	// This member is required.
	NextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification

	noSmithyDocumentSerde
}

// Provides a list of conditional branches. Branches are evaluated in the order
// that they are entered in the list. The first branch with a condition that
// evaluates to true is executed. The last branch in the list is the default
// branch. The default branch should not have any condition expression. The default
// branch is executed if no other branch has a matching condition.
type ConditionalSpecification struct {

	// Determines whether a conditional branch is active. When active is false, the
	// conditions are not evaluated.
	//
	// This member is required.
	Active *bool

	// A list of conditional branches. A conditional branch is made up of a condition,
	// a response and a next step. The response and next step are executed when the
	// condition is true.
	//
	// This member is required.
	ConditionalBranches []ConditionalBranch

	// The conditional branch that should be followed when the conditions for other
	// branches are not satisfied. A conditional branch is made up of a condition, a
	// response and a next step.
	//
	// This member is required.
	DefaultBranch *DefaultConditionalBranch

	noSmithyDocumentSerde
}

// The item listing the evaluation of intent level success or failure.
type ConversationLevelIntentClassificationResultItem struct {

	// The intent name used in the evaluation of intent level success or failure.
	//
	// This member is required.
	IntentName *string

	// The number of times the specific intent is used in the evaluation of intent
	// level success or failure.
	//
	// This member is required.
	MatchResult TestResultMatchStatus

	noSmithyDocumentSerde
}

// The conversation level details of the conversation used in the test set.
type ConversationLevelResultDetail struct {

	// The success or failure of the streaming of the conversation.
	//
	// This member is required.
	EndToEndResult TestResultMatchStatus

	// The speech transcription success or failure details of the conversation.
	SpeechTranscriptionResult TestResultMatchStatus

	noSmithyDocumentSerde
}

// The slots used for the slot resolution in the conversation.
type ConversationLevelSlotResolutionResultItem struct {

	// The intents used in the slots list for the slot resolution details.
	//
	// This member is required.
	IntentName *string

	// The number of matching slots used in the slots listings for the slot resolution
	// evaluation.
	//
	// This member is required.
	MatchResult TestResultMatchStatus

	// The slot name in the slots list for the slot resolution details.
	//
	// This member is required.
	SlotName *string

	noSmithyDocumentSerde
}

// The test result evaluation item at the conversation level.
type ConversationLevelTestResultItem struct {

	// The conversation Id of the test result evaluation item.
	//
	// This member is required.
	ConversationId *string

	// The end-to-end success or failure of the test result evaluation item.
	//
	// This member is required.
	EndToEndResult TestResultMatchStatus

	// The intent classification of the test result evaluation item.
	//
	// This member is required.
	IntentClassificationResults []ConversationLevelIntentClassificationResultItem

	// The slot success or failure of the test result evaluation item.
	//
	// This member is required.
	SlotResolutionResults []ConversationLevelSlotResolutionResultItem

	// The speech transcription success or failure of the test result evaluation item.
	SpeechTranscriptionResult TestResultMatchStatus

	noSmithyDocumentSerde
}

// The test set results data at the conversation level.
type ConversationLevelTestResults struct {

	// The item list in the test set results data at the conversation level.
	//
	// This member is required.
	Items []ConversationLevelTestResultItem

	noSmithyDocumentSerde
}

// The selection to filter the test set results data at the conversation level.
type ConversationLevelTestResultsFilterBy struct {

	// The selection of matched or mismatched end-to-end status to filter test set
	// results data at the conversation level.
	EndToEndResult TestResultMatchStatus

	noSmithyDocumentSerde
}

// The data source that uses conversation logs.
type ConversationLogsDataSource struct {

	// The bot alias Id from the conversation logs.
	//
	// This member is required.
	BotAliasId *string

	// The bot Id from the conversation logs.
	//
	// This member is required.
	BotId *string

	// The filter for the data source of the conversation log.
	//
	// This member is required.
	Filter *ConversationLogsDataSourceFilterBy

	// The locale Id of the conversation log.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// The selected data source to filter the conversation log.
type ConversationLogsDataSourceFilterBy struct {

	// The end time for the conversation log.
	//
	// This member is required.
	EndTime *time.Time

	// The selection to filter by input mode for the conversation logs.
	//
	// This member is required.
	InputMode ConversationLogsInputModeFilter

	// The start time for the conversation log.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Configures conversation logging that saves audio, text, and metadata for the
// conversations with your users.
type ConversationLogSettings struct {

	// The Amazon S3 settings for logging audio to an S3 bucket.
	AudioLogSettings []AudioLogSetting

	// The Amazon CloudWatch Logs settings for logging text and metadata.
	TextLogSettings []TextLogSetting

	noSmithyDocumentSerde
}

// A custom response string that Amazon Lex sends to your application. You define
// the content and structure the string.
type CustomPayload struct {

	// The string that is sent to your application.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The unique entry identifier for the custom vocabulary items.
type CustomVocabularyEntryId struct {

	// The unique item identifier for the custom vocabulary items.
	//
	// This member is required.
	ItemId *string

	noSmithyDocumentSerde
}

// Provides the parameters required for exporting a custom vocabulary.
type CustomVocabularyExportSpecification struct {

	// The identifier of the bot that contains the custom vocabulary to export.
	//
	// This member is required.
	BotId *string

	// The version of the bot that contains the custom vocabulary to export.
	//
	// This member is required.
	BotVersion *string

	// The locale of the bot that contains the custom vocabulary to export.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// Provides the parameters required for importing a custom vocabulary.
type CustomVocabularyImportSpecification struct {

	// The identifier of the bot to import the custom vocabulary to.
	//
	// This member is required.
	BotId *string

	// The version of the bot to import the custom vocabulary to.
	//
	// This member is required.
	BotVersion *string

	// The identifier of the local to import the custom vocabulary to. The value must
	// be en_GB .
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// The unique custom vocabulary item from the custom vocabulary list.
type CustomVocabularyItem struct {

	// The unique item identifer for the custom vocabulary item from the custom
	// vocabulary list.
	//
	// This member is required.
	ItemId *string

	// The unique phrase for the custom vocabulary item from the custom vocabulary
	// list.
	//
	// This member is required.
	Phrase *string

	// The DisplayAs value for the custom vocabulary item from the custom vocabulary
	// list.
	DisplayAs *string

	// The weight assigned for the custom vocabulary item from the custom vocabulary
	// list.
	Weight *int32

	noSmithyDocumentSerde
}

// By default, data stored by Amazon Lex is encrypted. The DataPrivacy structure
// provides settings that determine how Amazon Lex handles special cases of
// securing the data for your bot.
type DataPrivacy struct {

	// For each Amazon Lex bot created with the Amazon Lex Model Building Service, you
	// must specify whether your use of Amazon Lex is related to a website, program, or
	// other application that is directed or targeted, in whole or in part, to children
	// under age 13 and subject to the Children's Online Privacy Protection Act (COPPA)
	// by specifying true or false in the childDirected field. By specifying true in
	// the childDirected field, you confirm that your use of Amazon Lex is related to
	// a website, program, or other application that is directed or targeted, in whole
	// or in part, to children under age 13 and subject to COPPA. By specifying false
	// in the childDirected field, you confirm that your use of Amazon Lex is not
	// related to a website, program, or other application that is directed or
	// targeted, in whole or in part, to children under age 13 and subject to COPPA.
	// You may not specify a default value for the childDirected field that does not
	// accurately reflect whether your use of Amazon Lex is related to a website,
	// program, or other application that is directed or targeted, in whole or in part,
	// to children under age 13 and subject to COPPA. If your use of Amazon Lex relates
	// to a website, program, or other application that is directed in whole or in
	// part, to children under age 13, you must obtain any required verifiable parental
	// consent under COPPA. For information regarding the use of Amazon Lex in
	// connection with websites, programs, or other applications that are directed or
	// targeted, in whole or in part, to children under age 13, see the [Amazon Lex FAQ].
	//
	// [Amazon Lex FAQ]: http://aws.amazon.com/lex/faqs#data-security
	//
	// This member is required.
	ChildDirected bool

	noSmithyDocumentSerde
}

// Contains details about the configuration of the knowledge store used for the
// AMAZON.QnAIntent . You must have already created the knowledge store and indexed
// the documents within it.
type DataSourceConfiguration struct {

	// Contains details about the configuration of the Amazon Bedrock knowledge base
	// used for the AMAZON.QnAIntent . To set up a knowledge base, follow the steps at [Building a knowledge base]
	// .
	//
	// [Building a knowledge base]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html
	BedrockKnowledgeStoreConfiguration *BedrockKnowledgeStoreConfiguration

	// Contains details about the configuration of the Amazon Kendra index used for
	// the AMAZON.QnAIntent . To create a Amazon Kendra index, follow the steps at [Creating an index].
	//
	// [Creating an index]: https://docs.aws.amazon.com/kendra/latest/dg/create-index.html
	KendraConfiguration *QnAKendraConfiguration

	// Contains details about the configuration of the Amazon OpenSearch Service
	// database used for the AMAZON.QnAIntent . To create a domain, follow the steps at [Creating and managing Amazon OpenSearch Service domains]
	// .
	//
	// [Creating and managing Amazon OpenSearch Service domains]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html
	OpensearchConfiguration *OpensearchConfiguration

	noSmithyDocumentSerde
}

// The object used for specifying the data range that the customer wants Amazon
// Lex to read through in the input transcripts.
type DateRangeFilter struct {

	// A timestamp indicating the end date for the date range filter.
	//
	// This member is required.
	EndDateTime *time.Time

	// A timestamp indicating the start date for the date range filter.
	//
	// This member is required.
	StartDateTime *time.Time

	noSmithyDocumentSerde
}

// Configuration settings for integrating Deepgram speech-to-text models with
// Amazon Lex.
type DeepgramSpeechModelConfig struct {

	// The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the
	// Deepgram API token.
	//
	// This member is required.
	ApiTokenSecretArn *string

	// The identifier of the Deepgram speech-to-text model to use for processing
	// speech input.
	ModelId *string

	noSmithyDocumentSerde
}

// A set of actions that Amazon Lex should run if none of the other conditions are
// met.
type DefaultConditionalBranch struct {

	// The next step in the conversation.
	NextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	Response *ResponseSpecification

	noSmithyDocumentSerde
}

// Contains specifications for the descriptive bot building feature.
type DescriptiveBotBuilderSpecification struct {

	// Specifies whether the descriptive bot building feature is activated or not.
	//
	// This member is required.
	Enabled bool

	// An object containing information about the Amazon Bedrock model used to
	// interpret the prompt used in descriptive bot building.
	BedrockModelSpecification *BedrockModelSpecification

	noSmithyDocumentSerde
}

// Defines the action that the bot executes at runtime when the conversation
// reaches this step.
type DialogAction struct {

	// The action that the bot should execute.
	//
	// This member is required.
	Type DialogActionType

	// If the dialog action is ElicitSlot , defines the slot to elicit from the user.
	SlotToElicit *string

	// When true the next message for the intent is not used.
	SuppressNextMessage *bool

	noSmithyDocumentSerde
}

// Settings that specify the dialog code hook that is called by Amazon Lex at a
// step of the conversation.
type DialogCodeHookInvocationSetting struct {

	// Determines whether a dialog code hook is used when the intent is activated.
	//
	// This member is required.
	Active *bool

	// Indicates whether a Lambda function should be invoked for the dialog.
	//
	// This member is required.
	EnableCodeHookInvocation *bool

	// Contains the responses and actions that Amazon Lex takes after the Lambda
	// function is complete.
	//
	// This member is required.
	PostCodeHookSpecification *PostDialogCodeHookInvocationSpecification

	// A label that indicates the dialog step from which the dialog code hook is
	// happening.
	InvocationLabel *string

	noSmithyDocumentSerde
}

// Settings that determine the Lambda function that Amazon Lex uses for processing
// user responses.
type DialogCodeHookSettings struct {

	// Enables the dialog code hook so that it processes user requests.
	//
	// This member is required.
	Enabled bool

	noSmithyDocumentSerde
}

// The current state of the conversation with the user.
type DialogState struct {

	// Defines the action that the bot executes at runtime when the conversation
	// reaches this step.
	DialogAction *DialogAction

	// Override settings to configure the intent state.
	Intent *IntentOverride

	// Map of key/value pairs representing session-specific context information. It
	// contains application information passed between Amazon Lex and a client
	// application.
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Specifies the DTMF input specifications.
type DTMFSpecification struct {

	// The DTMF character that clears the accumulated DTMF digits and immediately ends
	// the input.
	//
	// This member is required.
	DeletionCharacter *string

	// The DTMF character that immediately ends input. If the user does not press this
	// character, the input ends after the end timeout.
	//
	// This member is required.
	EndCharacter *string

	// How long the bot should wait after the last DTMF character input before
	// assuming that the input has concluded.
	//
	// This member is required.
	EndTimeoutMs *int32

	// The maximum number of DTMF digits allowed in an utterance.
	//
	// This member is required.
	MaxLength *int32

	noSmithyDocumentSerde
}

// Settings that specify the dialog code hook that is called by Amazon Lex between
// eliciting slot values.
type ElicitationCodeHookInvocationSetting struct {

	// Indicates whether a Lambda function should be invoked for the dialog.
	//
	// This member is required.
	EnableCodeHookInvocation *bool

	// A label that indicates the dialog step from which the dialog code hook is
	// happening.
	InvocationLabel *string

	noSmithyDocumentSerde
}

// The object representing the passwords that were used to encrypt the data
// related to the bot recommendation, as well as the KMS key ARN used to encrypt
// the associated metadata.
type EncryptionSetting struct {

	// The password used to encrypt the associated transcript file.
	AssociatedTranscriptsPassword *string

	// The password used to encrypt the recommended bot recommendation file.
	BotLocaleExportPassword *string

	// The KMS key ARN used to encrypt the metadata associated with the bot
	// recommendation.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Settings parameters for the error logs, whether it is enabled or disabled.
type ErrorLogSettings struct {

	// Settings parameters for the error logs, when it is enabled.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// Contains the names of the fields used for an exact response to the user.
type ExactResponseFields struct {

	// The name of the field that contains the answer to the query made to the
	// OpenSearch Service database.
	//
	// This member is required.
	AnswerField *string

	// The name of the field that contains the query made to the OpenSearch Service
	// database.
	//
	// This member is required.
	QuestionField *string

	noSmithyDocumentSerde
}

// Details about an error in an execution of a test set.
type ExecutionErrorDetails struct {

	// The error code for the error.
	//
	// This member is required.
	ErrorCode *string

	// The message describing the error.
	//
	// This member is required.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Filters the response form the [ListExports] operation
//
// [ListExports]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListExports.html
type ExportFilter struct {

	// The name of the field to use for filtering.
	//
	// This member is required.
	Name ExportFilterName

	// The operator to use for the filter. Specify EQ when the ListExports operation
	// should return only resource types that equal the specified value. Specify CO
	// when the ListExports operation should return resource types that contain the
	// specified value.
	//
	// This member is required.
	Operator ExportFilterOperator

	// The values to use to filter the response. The values must be Bot , BotLocale ,
	// or CustomVocabulary .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about the bot or bot locale that you want to export. You
// can specify the botExportSpecification or the botLocaleExportSpecification , but
// not both.
type ExportResourceSpecification struct {

	// Parameters for exporting a bot.
	BotExportSpecification *BotExportSpecification

	// Parameters for exporting a bot locale.
	BotLocaleExportSpecification *BotLocaleExportSpecification

	// The parameters required to export a custom vocabulary.
	CustomVocabularyExportSpecification *CustomVocabularyExportSpecification

	// Specifications for the test set that is exported as a resource.
	TestSetExportSpecification *TestSetExportSpecification

	noSmithyDocumentSerde
}

// Provides information about sorting a list of exports.
type ExportSortBy struct {

	// The export field to use for sorting.
	//
	// This member is required.
	Attribute ExportSortAttribute

	// The order to sort the list.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Provides summary information about an export in an export list.
type ExportSummary struct {

	// The date and time that the export was created.
	CreationDateTime *time.Time

	// The unique identifier that Amazon Lex assigned to the export.
	ExportId *string

	// The status of the export. When the status is Completed the export is ready to
	// download.
	ExportStatus ExportStatus

	// The file format used in the export files.
	FileFormat ImportExportFileFormat

	// The date and time that the export was last updated.
	LastUpdatedDateTime *time.Time

	// Information about the bot or bot locale that was exported.
	ResourceSpecification *ExportResourceSpecification

	noSmithyDocumentSerde
}

// Provides information about the external source of the slot type's definition.
type ExternalSourceSetting struct {

	// Settings required for a slot type based on a grammar that you provide.
	GrammarSlotTypeSetting *GrammarSlotTypeSetting

	noSmithyDocumentSerde
}

// The unique failed custom vocabulary item from the custom vocabulary list.
type FailedCustomVocabularyItem struct {

	// The unique error code for the failed custom vocabulary item from the custom
	// vocabulary list.
	ErrorCode ErrorCode

	// The error message for the failed custom vocabulary item from the custom
	// vocabulary list.
	ErrorMessage *string

	// The unique item identifer for the failed custom vocabulary item from the custom
	// vocabulary list.
	ItemId *string

	noSmithyDocumentSerde
}

// Determines if a Lambda function should be invoked for a specific intent.
type FulfillmentCodeHookSettings struct {

	// Indicates whether a Lambda function should be invoked to fulfill a specific
	// intent.
	//
	// This member is required.
	Enabled bool

	// Determines whether the fulfillment code hook is used. When active is false, the
	// code hook doesn't run.
	Active *bool

	// Provides settings for update messages sent to the user for long-running Lambda
	// fulfillment functions. Fulfillment updates can be used only with streaming
	// conversations.
	FulfillmentUpdatesSpecification *FulfillmentUpdatesSpecification

	// Provides settings for messages sent to the user for after the Lambda
	// fulfillment function completes. Post-fulfillment messages can be sent for both
	// streaming and non-streaming conversations.
	PostFulfillmentStatusSpecification *PostFulfillmentStatusSpecification

	noSmithyDocumentSerde
}

// Provides settings for a message that is sent to the user when a fulfillment
// Lambda function starts running.
type FulfillmentStartResponseSpecification struct {

	// The delay between when the Lambda fulfillment function starts running and the
	// start message is played. If the Lambda function returns before the delay is
	// over, the start message isn't played.
	//
	// This member is required.
	DelayInSeconds *int32

	// 1 - 5 message groups that contain start messages. Amazon Lex chooses one of the
	// messages to play to the user.
	//
	// This member is required.
	MessageGroups []MessageGroup

	// Determines whether the user can interrupt the start message while it is playing.
	AllowInterrupt *bool

	noSmithyDocumentSerde
}

// Provides settings for a message that is sent periodically to the user while a
// fulfillment Lambda function is running.
type FulfillmentUpdateResponseSpecification struct {

	// The frequency that a message is sent to the user. When the period ends, Amazon
	// Lex chooses a message from the message groups and plays it to the user. If the
	// fulfillment Lambda returns before the first period ends, an update message is
	// not played to the user.
	//
	// This member is required.
	FrequencyInSeconds *int32

	// 1 - 5 message groups that contain update messages. Amazon Lex chooses one of
	// the messages to play to the user.
	//
	// This member is required.
	MessageGroups []MessageGroup

	// Determines whether the user can interrupt an update message while it is playing.
	AllowInterrupt *bool

	noSmithyDocumentSerde
}

// Provides information for updating the user on the progress of fulfilling an
// intent.
type FulfillmentUpdatesSpecification struct {

	// Determines whether fulfillment updates are sent to the user. When this field is
	// true, updates are sent.
	//
	// If the active field is set to true, the startResponse , updateResponse , and
	// timeoutInSeconds fields are required.
	//
	// This member is required.
	Active *bool

	// Provides configuration information for the message sent to users when the
	// fulfillment Lambda functions starts running.
	StartResponse *FulfillmentStartResponseSpecification

	// The length of time that the fulfillment Lambda function should run before it
	// times out.
	TimeoutInSeconds *int32

	// Provides configuration information for messages sent periodically to the user
	// while the fulfillment Lambda function is running.
	UpdateResponse *FulfillmentUpdateResponseSpecification

	noSmithyDocumentSerde
}

// Specifies the attribute and method by which to sort the generation request
// information.
type GenerationSortBy struct {

	// The attribute by which to sort the generation request information. You can sort
	// by the following attributes.
	//
	//   - creationStartTime – The time at which the generation request was created.
	//
	//   - lastUpdatedTime – The time at which the generation request was last updated.
	//
	// This member is required.
	Attribute GenerationSortByAttribute

	// The order by which to sort the generation request information.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Contains information about a generation request made for the bot locale.
type GenerationSummary struct {

	// The date and time at which the generation request was made.
	CreationDateTime *time.Time

	// The unique identifier of the generation request.
	GenerationId *string

	// The status of the generation request.
	GenerationStatus GenerationStatus

	// The date and time at which the generation request was last updated.
	LastUpdatedDateTime *time.Time

	noSmithyDocumentSerde
}

// Contains specifications about the generative AI capabilities from Amazon
// Bedrock that you can turn on for your bot.
type GenerativeAISettings struct {

	// Contains specifications about the Amazon Lex build time generative AI
	// capabilities from Amazon Bedrock that you can turn on for your bot.
	BuildtimeSettings *BuildtimeSettings

	// Contains specifications about the Amazon Lex runtime generative AI capabilities
	// from Amazon Bedrock that you can turn on for your bot.
	RuntimeSettings *RuntimeSettings

	noSmithyDocumentSerde
}

// Settings requried for a slot type based on a grammar that you provide.
type GrammarSlotTypeSetting struct {

	// The source of the grammar used to create the slot type.
	Source *GrammarSlotTypeSource

	noSmithyDocumentSerde
}

// Describes the Amazon S3 bucket name and location for the grammar that is the
// source for the slot type.
type GrammarSlotTypeSource struct {

	// The name of the Amazon S3 bucket that contains the grammar source.
	//
	// This member is required.
	S3BucketName *string

	// The path to the grammar in the Amazon S3 bucket.
	//
	// This member is required.
	S3ObjectKey *string

	// The KMS key required to decrypt the contents of the grammar, if any.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// A card that is shown to the user by a messaging platform. You define the
// contents of the card, the card is displayed by the platform.
//
// When you use a response card, the response from the user is constrained to the
// text associated with a button on the card.
type ImageResponseCard struct {

	// The title to display on the response card. The format of the title is
	// determined by the platform displaying the response card.
	//
	// This member is required.
	Title *string

	// A list of buttons that should be displayed on the response card. The
	// arrangement of the buttons is determined by the platform that displays the
	// button.
	Buttons []Button

	// The URL of an image to display on the response card. The image URL must be
	// publicly available so that the platform displaying the response card has access
	// to the image.
	ImageUrl *string

	// The subtitle to display on the response card. The format of the subtitle is
	// determined by the platform displaying the response card.
	Subtitle *string

	noSmithyDocumentSerde
}

// Filters the response from the [ListImports] operation.
//
// [ListImports]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListImports.html
type ImportFilter struct {

	// The name of the field to use for filtering.
	//
	// This member is required.
	Name ImportFilterName

	// The operator to use for the filter. Specify EQ when the ListImports operation
	// should return only resource types that equal the specified value. Specify CO
	// when the ListImports operation should return resource types that contain the
	// specified value.
	//
	// This member is required.
	Operator ImportFilterOperator

	// The values to use to filter the response. The values must be Bot , BotLocale ,
	// or CustomVocabulary .
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about the bot or bot locale that you want to import. You
// can specify the botImportSpecification or the botLocaleImportSpecification , but
// not both.
type ImportResourceSpecification struct {

	// Parameters for importing a bot.
	BotImportSpecification *BotImportSpecification

	// Parameters for importing a bot locale.
	BotLocaleImportSpecification *BotLocaleImportSpecification

	// Provides the parameters required for importing a custom vocabulary.
	CustomVocabularyImportSpecification *CustomVocabularyImportSpecification

	// Specifications for the test set that is imported.
	TestSetImportResourceSpecification *TestSetImportResourceSpecification

	noSmithyDocumentSerde
}

// Provides information for sorting a list of imports.
type ImportSortBy struct {

	// The export field to use for sorting.
	//
	// This member is required.
	Attribute ImportSortAttribute

	// The order to sort the list.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Provides summary information about an import in an import list.
type ImportSummary struct {

	// The date and time that the import was created.
	CreationDateTime *time.Time

	// The unique identifier that Amazon Lex assigned to the import.
	ImportId *string

	// The status of the resource. When the status is Completed the resource is ready
	// to build.
	ImportStatus ImportStatus

	// The unique identifier that Amazon Lex assigned to the imported resource.
	ImportedResourceId *string

	// The name that you gave the imported resource.
	ImportedResourceName *string

	// The type of resource that was imported.
	ImportedResourceType ImportResourceType

	// The date and time that the import was last updated.
	LastUpdatedDateTime *time.Time

	// The strategy used to merge existing bot or bot locale definitions with the
	// imported definition.
	MergeStrategy MergeStrategy

	noSmithyDocumentSerde
}

// Configuration setting for a response sent to the user before Amazon Lex starts
// eliciting slots.
type InitialResponseSetting struct {

	// Settings that specify the dialog code hook that is called by Amazon Lex at a
	// step of the conversation.
	CodeHook *DialogCodeHookInvocationSetting

	// Provides a list of conditional branches. Branches are evaluated in the order
	// that they are entered in the list. The first branch with a condition that
	// evaluates to true is executed. The last branch in the list is the default
	// branch. The default branch should not have any condition expression. The default
	// branch is executed if no other branch has a matching condition.
	Conditional *ConditionalSpecification

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	InitialResponse *ResponseSpecification

	// The next step in the conversation.
	NextStep *DialogState

	noSmithyDocumentSerde
}

// A context that must be active for an intent to be selected by Amazon Lex.
type InputContext struct {

	// The name of the context.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifications for the current state of the dialog between the user and the bot
// in the test set.
type InputSessionStateSpecification struct {

	// Active contexts for the session state.
	ActiveContexts []ActiveContext

	// Runtime hints for the session state.
	RuntimeHints *RuntimeHints

	// Session attributes for the session state.
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Information for an intent that is classified by the test workbench.
type IntentClassificationTestResultItem struct {

	// The name of the intent.
	//
	// This member is required.
	IntentName *string

	// Indicates whether the conversation involves multiple turns or not.
	//
	// This member is required.
	MultiTurnConversation bool

	// The result of the intent classification test.
	//
	// This member is required.
	ResultCounts *IntentClassificationTestResultItemCounts

	noSmithyDocumentSerde
}

// The number of items in the intent classification test.
type IntentClassificationTestResultItemCounts struct {

	// The number of matched and mismatched results for intent recognition for the
	// intent.
	//
	// This member is required.
	IntentMatchResultCounts map[string]int32

	// The total number of results in the intent classification test.
	//
	// This member is required.
	TotalResultCount *int32

	// The number of matched, mismatched, and execution error results for speech
	// transcription for the intent.
	SpeechTranscriptionResultCounts map[string]int32

	noSmithyDocumentSerde
}

// Information for the results of the intent classification test.
type IntentClassificationTestResults struct {

	// A list of the results for the intent classification test.
	//
	// This member is required.
	Items []IntentClassificationTestResultItem

	noSmithyDocumentSerde
}

// Provides a statement the Amazon Lex conveys to the user when the intent is
// successfully fulfilled.
type IntentClosingSetting struct {

	// Specifies whether an intent's closing response is used. When this field is
	// false, the closing response isn't sent to the user. If the active field isn't
	// specified, the default is true.
	Active *bool

	// The response that Amazon Lex sends to the user when the intent is complete.
	ClosingResponse *ResponseSpecification

	// A list of conditional branches associated with the intent's closing response.
	// These branches are executed when the nextStep attribute is set to
	// EvalutateConditional .
	Conditional *ConditionalSpecification

	// Specifies the next step that the bot executes after playing the intent's
	// closing response.
	NextStep *DialogState

	noSmithyDocumentSerde
}

// Provides a prompt for making sure that the user is ready for the intent to be
// fulfilled.
type IntentConfirmationSetting struct {

	// Prompts the user to confirm the intent. This question should have a yes or no
	// answer.
	//
	// Amazon Lex uses this prompt to ensure that the user acknowledges that the
	// intent is ready for fulfillment. For example, with the OrderPizza intent, you
	// might want to confirm that the order is correct before placing it. For other
	// intents, such as intents that simply respond to user questions, you might not
	// need to ask the user for confirmation before providing the information.
	//
	// This member is required.
	PromptSpecification *PromptSpecification

	// Specifies whether the intent's confirmation is sent to the user. When this
	// field is false, confirmation and declination responses aren't sent. If the
	// active field isn't specified, the default is true.
	Active *bool

	// The DialogCodeHookInvocationSetting object associated with intent's
	// confirmation step. The dialog code hook is triggered based on these invocation
	// settings when the confirmation next step or declination next step or failure
	// next step is InvokeDialogCodeHook .
	CodeHook *DialogCodeHookInvocationSetting

	// A list of conditional branches to evaluate after the intent is closed.
	ConfirmationConditional *ConditionalSpecification

	// Specifies the next step that the bot executes when the customer confirms the
	// intent.
	ConfirmationNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	ConfirmationResponse *ResponseSpecification

	// A list of conditional branches to evaluate after the intent is declined.
	DeclinationConditional *ConditionalSpecification

	// Specifies the next step that the bot executes when the customer declines the
	// intent.
	DeclinationNextStep *DialogState

	// When the user answers "no" to the question defined in promptSpecification ,
	// Amazon Lex responds with this response to acknowledge that the intent was
	// canceled.
	DeclinationResponse *ResponseSpecification

	// The DialogCodeHookInvocationSetting used when the code hook is invoked during
	// confirmation prompt retries.
	ElicitationCodeHook *ElicitationCodeHookInvocationSetting

	// Provides a list of conditional branches. Branches are evaluated in the order
	// that they are entered in the list. The first branch with a condition that
	// evaluates to true is executed. The last branch in the list is the default
	// branch. The default branch should not have any condition expression. The default
	// branch is executed if no other branch has a matching condition.
	FailureConditional *ConditionalSpecification

	// The next step to take in the conversation if the confirmation step fails.
	FailureNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	FailureResponse *ResponseSpecification

	noSmithyDocumentSerde
}

// Configures the Intent Disambiguation feature that helps resolve ambiguous user
// inputs when multiple intents could match. When enabled, the system presents
// clarifying questions to users, helping them specify their exact intent for
// improved conversation accuracy.
type IntentDisambiguationSettings struct {

	// Determines whether the Intent Disambiguation feature is enabled. When set to
	// true , Amazon Lex will present disambiguation options to users when multiple
	// intents could match their input, with the default being false .
	//
	// This member is required.
	Enabled bool

	// Provides a custom message that will be displayed before presenting the
	// disambiguation options to users. This message helps set the context for users
	// and can be customized to match your bot's tone and brand. If not specified, a
	// default message will be used.
	CustomDisambiguationMessage *string

	// Specifies the maximum number of intent options (2-5) to present to users when
	// disambiguation is needed. This setting determines how many intent options will
	// be shown to users when the system detects ambiguous input. The default value is
	// 3.
	MaxDisambiguationIntents *int32

	noSmithyDocumentSerde
}

// Filters the response from the ListIntents operation.
type IntentFilter struct {

	// The name of the field to use for the filter.
	//
	// This member is required.
	Name IntentFilterName

	// The operator to use for the filter. Specify EQ when the ListIntents operation
	// should return only aliases that equal the specified value. Specify CO when the
	// ListIntents operation should return aliases that contain the specified value.
	//
	// This member is required.
	Operator IntentFilterOperator

	// The value to use for the filter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Information about intent-level slot resolution in a test result.
type IntentLevelSlotResolutionTestResultItem struct {

	// The name of the intent that was recognized.
	//
	// This member is required.
	IntentName *string

	// Indicates whether the conversation involves multiple turns or not.
	//
	// This member is required.
	MultiTurnConversation bool

	// The results for the slot resolution in the test execution result.
	//
	// This member is required.
	SlotResolutionResults []SlotResolutionTestResultItem

	noSmithyDocumentSerde
}

// Indicates the success or failure of slots at the intent level.
type IntentLevelSlotResolutionTestResults struct {

	// Indicates the items for the slot level resolution for the intents.
	//
	// This member is required.
	Items []IntentLevelSlotResolutionTestResultItem

	noSmithyDocumentSerde
}

// Override settings to configure the intent state.
type IntentOverride struct {

	// The name of the intent. Only required when you're switching intents.
	Name *string

	// A map of all of the slot value overrides for the intent. The name of the slot
	// maps to the value of the slot. Slots that are not included in the map aren't
	// overridden.
	Slots map[string]SlotValueOverride

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of intents.
type IntentSortBy struct {

	// The attribute to use to sort the list of intents.
	//
	// This member is required.
	Attribute IntentSortAttribute

	// The order to sort the list. You can choose ascending or descending.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// The object that contains the statistical summary of recommended intents
// associated with the bot recommendation.
type IntentStatistics struct {

	// The number of recommended intents associated with the bot recommendation.
	DiscoveredIntentCount *int32

	noSmithyDocumentSerde
}

// Summary information about an intent returned by the ListIntents operation.
type IntentSummary struct {

	// The description of the intent.
	Description *string

	// The input contexts that must be active for this intent to be considered for
	// recognition.
	InputContexts []InputContext

	// The display name of the intent.
	IntentDisplayName *string

	// The unique identifier assigned to the intent. Use this ID to get detailed
	// information about the intent with the DescribeIntent operation.
	IntentId *string

	// The name of the intent.
	IntentName *string

	// The timestamp of the date and time that the intent was last updated.
	LastUpdatedDateTime *time.Time

	// The output contexts that are activated when this intent is fulfilled.
	OutputContexts []OutputContext

	// If this intent is derived from a built-in intent, the name of the parent intent.
	ParentIntentSignature *string

	noSmithyDocumentSerde
}

// An object containing the name of an intent that was invoked.
type InvokedIntentSample struct {

	// The name of an intent that was invoked.
	IntentName *string

	noSmithyDocumentSerde
}

// Provides configuration information for the AMAZON.KendraSearchIntent intent.
// When you use this intent, Amazon Lex searches the specified Amazon Kendra index
// and returns documents from the index that match the user's utterance.
type KendraConfiguration struct {

	// The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the
	// AMAZON.KendraSearchIntent intent to search. The index must be in the same
	// account and Region as the Amazon Lex bot.
	//
	// This member is required.
	KendraIndex *string

	// A query filter that Amazon Lex sends to Amazon Kendra to filter the response
	// from a query. The filter is in the format defined by Amazon Kendra. For more
	// information, see [Filtering queries].
	//
	// [Filtering queries]: https://docs.aws.amazon.com/kendra/latest/dg/filtering.html
	QueryFilterString *string

	// Determines whether the AMAZON.KendraSearchIntent intent uses a custom query
	// string to query the Amazon Kendra index.
	QueryFilterStringEnabled bool

	noSmithyDocumentSerde
}

// Specifies a Lambda function that verifies requests to a bot or fulfills the
// user's request to a bot.
type LambdaCodeHook struct {

	// The version of the request-response that you want Amazon Lex to use to invoke
	// your Lambda function.
	//
	// This member is required.
	CodeHookInterfaceVersion *string

	// The Amazon Resource Name (ARN) of the Lambda function.
	//
	// This member is required.
	LambdaARN *string

	noSmithyDocumentSerde
}

// The object that contains transcript filter details that are associated with a
// bot recommendation.
type LexTranscriptFilter struct {

	// The object that contains a date range filter that will be applied to the
	// transcript. Specify this object if you want Amazon Lex to only read the files
	// that are within the date range.
	DateRangeFilter *DateRangeFilter

	noSmithyDocumentSerde
}

// The object that provides message text and its type.
type Message struct {

	// A message in a custom format defined by the client application.
	CustomPayload *CustomPayload

	// A message that defines a response card that the client application can show to
	// the user.
	ImageResponseCard *ImageResponseCard

	// A message in plain text format.
	PlainTextMessage *PlainTextMessage

	// A message in Speech Synthesis Markup Language (SSML).
	SsmlMessage *SSMLMessage

	noSmithyDocumentSerde
}

// Provides one or more messages that Amazon Lex should send to the user.
type MessageGroup struct {

	// The primary message that Amazon Lex should send to the user.
	//
	// This member is required.
	Message *Message

	// Message variations to send to the user. When variations are defined, Amazon Lex
	// chooses the primary message or one of the variations to send to the user.
	Variations []Message

	noSmithyDocumentSerde
}

// Indicates whether a slot can return multiple values.
type MultipleValuesSetting struct {

	// Indicates whether a slot can return multiple values. When true , the slot may
	// return more than one value in a response. When false , the slot returns only a
	// single value.
	//
	// Multi-value slots are only available in the en-US locale. If you set this value
	// to true in any other locale, Amazon Lex throws a ValidationException .
	//
	// If the allowMutlipleValues is not set, the default value is false .
	AllowMultipleValues bool

	noSmithyDocumentSerde
}

// The new custom vocabulary item from the custom vocabulary list.
type NewCustomVocabularyItem struct {

	// The unique phrase for the new custom vocabulary item from the custom vocabulary
	// list.
	//
	// This member is required.
	Phrase *string

	// The display as value assigned to the new custom vocabulary item from the custom
	// vocabulary list.
	DisplayAs *string

	// The weight assigned to the new custom vocabulary item from the custom
	// vocabulary list.
	Weight *int32

	noSmithyDocumentSerde
}

// Configures the Assisted Natural Language Understanding (NLU) feature for your
// bot. This specification determines whether enhanced intent recognition and
// utterance understanding capabilities are active.
type NluImprovementSpecification struct {

	// Determines whether the Assisted NLU feature is enabled for the bot. When set to
	// true , Amazon Lex uses advanced models to improve intent recognition and slot
	// resolution, with the default being false .
	//
	// This member is required.
	Enabled bool

	// Specifies the mode for Assisted NLU operation. Use Primary to make Assisted NLU
	// the primary intent recognition method, or Fallback to use it only when standard
	// NLU confidence is low.
	AssistedNluMode AssistedNluMode

	// An object containing specifications for the Intent Disambiguation feature
	// within the Assisted NLU settings. These settings determine how the bot handles
	// ambiguous user inputs that could match multiple intents.
	IntentDisambiguationSettings *IntentDisambiguationSettings

	noSmithyDocumentSerde
}

// Determines whether Amazon Lex obscures slot values in conversation logs.
type ObfuscationSetting struct {

	// Value that determines whether Amazon Lex obscures slot values in conversation
	// logs. The default is to obscure the values.
	//
	// This member is required.
	ObfuscationSettingType ObfuscationSettingType

	noSmithyDocumentSerde
}

// Contains details about the configuration of the Amazon OpenSearch Service
// database used for the AMAZON.QnAIntent .
type OpensearchConfiguration struct {

	// The endpoint of the Amazon OpenSearch Service domain.
	//
	// This member is required.
	DomainEndpoint *string

	// The name of the Amazon OpenSearch Service index.
	//
	// This member is required.
	IndexName *string

	// Specifies whether to return an exact response or to return an answer generated
	// by the model using the fields you specify from the database.
	ExactResponse bool

	// Contains the names of the fields used for an exact response to the user.
	ExactResponseFields *ExactResponseFields

	// Contains a list of fields from the Amazon OpenSearch Service that the model can
	// use to generate the answer to the query.
	IncludeFields []string

	noSmithyDocumentSerde
}

// Describes a session context that is activated when an intent is fulfilled.
type OutputContext struct {

	// The name of the output context.
	//
	// This member is required.
	Name *string

	// The amount of time, in seconds, that the output context should remain active.
	// The time is figured from the first time the context is sent to the user.
	//
	// This member is required.
	TimeToLiveInSeconds *int32

	// The number of conversation turns that the output context should remain active.
	// The number of turns is counted from the first time that the context is sent to
	// the user.
	//
	// This member is required.
	TurnsToLive *int32

	noSmithyDocumentSerde
}

// Information about the overall results for a test execution result.
type OverallTestResultItem struct {

	// The number of results that succeeded.
	//
	// This member is required.
	EndToEndResultCounts map[string]int32

	// Indicates whether the conversation contains multiple turns or not.
	//
	// This member is required.
	MultiTurnConversation bool

	// The total number of overall results in the result of the test execution.
	//
	// This member is required.
	TotalResultCount *int32

	// The number of speech transcription results in the overall test.
	SpeechTranscriptionResultCounts map[string]int32

	noSmithyDocumentSerde
}

// Information about the overall test results.
type OverallTestResults struct {

	// A list of the overall test results.
	//
	// This member is required.
	Items []OverallTestResultItem

	noSmithyDocumentSerde
}

// A network of bots.
type ParentBotNetwork struct {

	// The identifier of the network of bots assigned by Amazon Lex.
	//
	// This member is required.
	BotId *string

	// The version of the network of bots.
	//
	// This member is required.
	BotVersion *string

	noSmithyDocumentSerde
}

// The object that contains a path format that will be applied when Amazon Lex
// reads the transcript file in the bucket you provide. Specify this object if you
// only want Lex to read a subset of files in your Amazon S3 bucket.
type PathFormat struct {

	// A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3
	// bucket. Specify this list if you only want Lex to read the files under this set
	// of sub-folders.
	ObjectPrefixes []string

	noSmithyDocumentSerde
}

// Defines an ASCII text message to send to the user.
type PlainTextMessage struct {

	// The message to send to the user.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies next steps to run after the dialog code hook finishes.
type PostDialogCodeHookInvocationSpecification struct {

	// A list of conditional branches to evaluate after the dialog code hook throws an
	// exception or returns with the State field of the Intent object set to Failed .
	FailureConditional *ConditionalSpecification

	// Specifies the next step the bot runs after the dialog code hook throws an
	// exception or returns with the State field of the Intent object set to Failed .
	FailureNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	FailureResponse *ResponseSpecification

	// A list of conditional branches to evaluate after the dialog code hook finishes
	// successfully.
	SuccessConditional *ConditionalSpecification

	// Specifics the next step the bot runs after the dialog code hook finishes
	// successfully.
	SuccessNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	SuccessResponse *ResponseSpecification

	// A list of conditional branches to evaluate if the code hook times out.
	TimeoutConditional *ConditionalSpecification

	// Specifies the next step that the bot runs when the code hook times out.
	TimeoutNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	TimeoutResponse *ResponseSpecification

	noSmithyDocumentSerde
}

// Provides a setting that determines whether the post-fulfillment response is
// sent to the user. For more information, see [https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete]
//
// [https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete]: https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete
type PostFulfillmentStatusSpecification struct {

	// A list of conditional branches to evaluate after the fulfillment code hook
	// throws an exception or returns with the State field of the Intent object set to
	// Failed .
	FailureConditional *ConditionalSpecification

	// Specifies the next step the bot runs after the fulfillment code hook throws an
	// exception or returns with the State field of the Intent object set to Failed .
	FailureNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	FailureResponse *ResponseSpecification

	// A list of conditional branches to evaluate after the fulfillment code hook
	// finishes successfully.
	SuccessConditional *ConditionalSpecification

	// Specifies the next step in the conversation that Amazon Lex invokes when the
	// fulfillment code hook completes successfully.
	SuccessNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	SuccessResponse *ResponseSpecification

	// A list of conditional branches to evaluate if the fulfillment code hook times
	// out.
	TimeoutConditional *ConditionalSpecification

	// Specifies the next step that the bot runs when the fulfillment code hook times
	// out.
	TimeoutNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	TimeoutResponse *ResponseSpecification

	noSmithyDocumentSerde
}

// The IAM principal that you allowing or denying access to an Amazon Lex action.
// You must provide a service or an arn , but not both in the same statement. For
// more information, see [AWS JSON policy elements: Principal].
//
// [AWS JSON policy elements: Principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
type Principal struct {

	// The Amazon Resource Name (ARN) of the principal.
	Arn *string

	// The name of the Amazon Web Services service that should allowed or denied
	// access to an Amazon Lex action.
	Service *string

	noSmithyDocumentSerde
}

// Specifies the settings on a prompt attempt.
type PromptAttemptSpecification struct {

	// Indicates the allowed input types of the prompt attempt.
	//
	// This member is required.
	AllowedInputTypes *AllowedInputTypes

	// Indicates whether the user can interrupt a speech prompt attempt from the bot.
	AllowInterrupt *bool

	// Specifies the settings on audio and DTMF input.
	AudioAndDTMFInputSpecification *AudioAndDTMFInputSpecification

	// Specifies the settings on text input.
	TextInputSpecification *TextInputSpecification

	noSmithyDocumentSerde
}

// Specifies a list of message groups that Amazon Lex sends to a user to elicit a
// response.
type PromptSpecification struct {

	// The maximum number of times the bot tries to elicit a response from the user
	// using this prompt.
	//
	// This member is required.
	MaxRetries *int32

	// A collection of messages that Amazon Lex can send to the user. Amazon Lex
	// chooses the actual message to send at runtime.
	//
	// This member is required.
	MessageGroups []MessageGroup

	// Indicates whether the user can interrupt a speech prompt from the bot.
	AllowInterrupt *bool

	// Indicates how a message is selected from a message group among retries.
	MessageSelectionStrategy MessageSelectionStrategy

	// Specifies the advanced settings on each attempt of the prompt.
	PromptAttemptsSpecification map[string]PromptAttemptSpecification

	noSmithyDocumentSerde
}

// The configuration details of the Qinconnect assistant.
type QInConnectAssistantConfiguration struct {

	// The assistant Arn details of the Qinconnect assistant configuration.
	//
	// This member is required.
	AssistantArn *string

	noSmithyDocumentSerde
}

// The configuration details of the Qinconnect intent.
type QInConnectIntentConfiguration struct {

	// The Qinconnect assistant configuration details of the Qinconnect intent.
	QInConnectAssistantConfiguration *QInConnectAssistantConfiguration

	noSmithyDocumentSerde
}

// Details about the the configuration of the built-in Amazon.QnAIntent .
type QnAIntentConfiguration struct {

	// Contains information about the Amazon Bedrock model used to interpret the
	// prompt used in descriptive bot building.
	BedrockModelConfiguration *BedrockModelSpecification

	// Contains details about the configuration of the data source used for the
	// AMAZON.QnAIntent .
	DataSourceConfiguration *DataSourceConfiguration

	noSmithyDocumentSerde
}

// Contains details about the configuration of the Amazon Kendra index used for
// the AMAZON.QnAIntent .
type QnAKendraConfiguration struct {

	// The ARN of the Amazon Kendra index to use.
	//
	// This member is required.
	KendraIndex *string

	// Specifies whether to return an exact response from the Amazon Kendra index or
	// to let the Amazon Bedrock model you select generate a response based on the
	// results. To use this feature, you must first add FAQ questions to your index by
	// following the steps at [Adding frequently asked questions (FAQs) to an index].
	//
	// [Adding frequently asked questions (FAQs) to an index]: https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html
	ExactResponse bool

	// Contains the Amazon Kendra filter string to use if enabled. For more
	// information on the Amazon Kendra search filter JSON format, see [Using document attributes to filter search results].
	//
	// [Using document attributes to filter search results]: https://docs.aws.amazon.com/kendra/latest/dg/filtering.html#search-filtering
	QueryFilterString *string

	// Specifies whether to enable an Amazon Kendra filter string or not.
	QueryFilterStringEnabled bool

	noSmithyDocumentSerde
}

// An object that contains a summary of a recommended intent.
type RecommendedIntentSummary struct {

	// The unique identifier of a recommended intent associated with the bot
	// recommendation.
	IntentId *string

	// The name of a recommended intent associated with the bot recommendation.
	IntentName *string

	// The count of sample utterances of a recommended intent that is associated with
	// a bot recommendation.
	SampleUtterancesCount *int32

	noSmithyDocumentSerde
}

// Specifies the time window that utterance statistics are returned for. The time
// window is always relative to the last time that the that utterances were
// aggregated. For example, if the ListAggregatedUtterances operation is called at
// 1600, the time window is set to 1 hour, and the last refresh time was 1530, only
// utterances made between 1430 and 1530 are returned.
//
// You can choose the time window that statistics should be returned for.
//
//   - Hours - You can request utterance statistics for 1, 3, 6, 12, or 24 hour
//     time windows. Statistics are refreshed every half hour for 1 hour time windows,
//     and hourly for the other time windows.
//
//   - Days - You can request utterance statistics for 3 days. Statistics are
//     refreshed every 6 hours.
//
//   - Weeks - You can see statistics for one or two weeks. Statistics are
//     refreshed every 12 hours for one week time windows, and once per day for two
//     week time windows.
type RelativeAggregationDuration struct {

	// The type of time period that the timeValue field represents.
	//
	// This member is required.
	TimeDimension TimeDimension

	// The period of the time window to gather statistics for. The valid value depends
	// on the setting of the timeDimension field.
	//
	//   - Hours - 1/3/6/12/24
	//
	//   - Days - 3
	//
	//   - Weeks - 1/2
	//
	// This member is required.
	TimeValue *int32

	noSmithyDocumentSerde
}

// Specifies a list of message groups that Amazon Lex uses to respond the user
// input.
type ResponseSpecification struct {

	// A collection of responses that Amazon Lex can send to the user. Amazon Lex
	// chooses the actual response to send at runtime.
	//
	// This member is required.
	MessageGroups []MessageGroup

	// Indicates whether the user can interrupt a speech response from Amazon Lex.
	AllowInterrupt *bool

	noSmithyDocumentSerde
}

// Provides an array of phrases that should be given preference when resolving
// values for a slot.
type RuntimeHintDetails struct {

	// One or more strings that Amazon Lex should look for in the input to the bot.
	// Each phrase is given preference when deciding on slot values.
	RuntimeHintValues []RuntimeHintValue

	// A map of constituent sub slot names inside a composite slot in the intent and
	// the phrases that should be added for each sub slot. Inside each composite slot
	// hints, this structure provides a mechanism to add granular sub slot phrases.
	// Only sub slot hints are supported for composite slots. The intent name,
	// composite slot name and the constituent sub slot names must exist.
	SubSlotHints map[string]RuntimeHintDetails

	noSmithyDocumentSerde
}

// You can provide Amazon Lex with hints to the phrases that a customer is likely
// to use for a slot. When a slot with hints is resolved, the phrases in the
// runtime hints are preferred in the resolution. You can provide hints for a
// maximum of 100 intents. You can provide a maximum of 100 slots.
//
// Before you can use runtime hints with an existing bot, you must first rebuild
// the bot.
//
// For more information, see [Using runtime hints to improve recognition of slot values].
//
// [Using runtime hints to improve recognition of slot values]: https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.html
type RuntimeHints struct {

	// A list of the slots in the intent that should have runtime hints added, and the
	// phrases that should be added for each slot.
	//
	// The first level of the slotHints map is the name of the intent. The second
	// level is the name of the slot within the intent. For more information, see [Using hints to improve accuracy].
	//
	// The intent name and slot name must exist.
	//
	// [Using hints to improve accuracy]: https://docs.aws.amazon.com/lexv2/latest/dg/using-hints.html
	SlotHints map[string]map[string]RuntimeHintDetails

	noSmithyDocumentSerde
}

// Provides the phrase that Amazon Lex should look for in the user's input to the
// bot.
type RuntimeHintValue struct {

	// The phrase that Amazon Lex should look for in the user's input to the bot.
	//
	// This member is required.
	Phrase *string

	noSmithyDocumentSerde
}

// Contains specifications about the Amazon Lex runtime generative AI capabilities
// from Amazon Bedrock that you can turn on for your bot.
type RuntimeSettings struct {

	// An object containing specifications for the Assisted NLU feature within the
	// bot's runtime settings. These settings determine how the bot processes and
	// interprets user utterances during conversations.
	NluImprovement *NluImprovementSpecification

	// An object containing specifications for the assisted slot resolution feature.
	SlotResolutionImprovement *SlotResolutionImprovementSpecification

	noSmithyDocumentSerde
}

// Specifies an Amazon S3 bucket for logging audio conversations
type S3BucketLogDestination struct {

	// The S3 prefix to assign to audio log files.
	//
	// This member is required.
	LogPrefix *string

	// The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log files are
	// stored.
	//
	// This member is required.
	S3BucketArn *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service
	// (KMS) key for encrypting audio log files stored in an S3 bucket.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// The object representing the Amazon S3 bucket containing the transcript, as well
// as the associated metadata.
type S3BucketTranscriptSource struct {

	// The name of the bucket containing the transcript and the associated metadata.
	//
	// This member is required.
	S3BucketName *string

	// The format of the transcript content. Currently, Genie only supports the Amazon
	// Lex transcript format.
	//
	// This member is required.
	TranscriptFormat TranscriptFormat

	// The ARN of the KMS key that customer use to encrypt their Amazon S3 bucket.
	// Only use this field if your bucket is encrypted using a customer managed KMS
	// key.
	KmsKeyArn *string

	// The object that contains a path format that will be applied when Amazon Lex
	// reads the transcript file in the bucket you provide. Specify this object if you
	// only want Lex to read a subset of files in your Amazon S3 bucket.
	PathFormat *PathFormat

	// The object that contains the filter which will be applied when Amazon Lex reads
	// through the Amazon S3 bucket. Specify this object if you want Amazon Lex to read
	// only a subset of the Amazon S3 bucket based on the filter you provide.
	TranscriptFilter *TranscriptFilter

	noSmithyDocumentSerde
}

// A sample utterance that invokes an intent or respond to a slot elicitation
// prompt.
type SampleUtterance struct {

	// The sample utterance that Amazon Lex uses to build its machine-learning model
	// to recognize intents.
	//
	// This member is required.
	Utterance *string

	noSmithyDocumentSerde
}

// Contains specifications for the sample utterance generation feature.
type SampleUtteranceGenerationSpecification struct {

	// Specifies whether to enable sample utterance generation or not.
	//
	// This member is required.
	Enabled bool

	// Contains information about the Amazon Bedrock model used to interpret the
	// prompt used in descriptive bot building.
	BedrockModelSpecification *BedrockModelSpecification

	noSmithyDocumentSerde
}

// Defines one of the values for a slot type.
type SampleValue struct {

	// The value that can be used for a slot type.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Determines whether Amazon Lex will use Amazon Comprehend to detect the
// sentiment of user utterances.
type SentimentAnalysisSettings struct {

	// Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user
	// utterances.
	//
	// This member is required.
	DetectSentiment bool

	noSmithyDocumentSerde
}

// An object specifying the measure and method by which to sort the session
// analytics data.
type SessionDataSortBy struct {

	// The measure by which to sort the session analytics data.
	//
	//   - conversationStartTime – The date and time when the conversation began. A
	//   conversation is defined as a unique combination of a sessionId and an
	//   originatingRequestId .
	//
	//   - numberOfTurns – The number of turns that the session took.
	//
	//   - conversationDurationSeconds – The duration of the conversation in seconds.
	//
	// This member is required.
	Name AnalyticsSessionSortByName

	// Specifies whether to sort the results in ascending or descending order.
	//
	// This member is required.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// An object containing information about a specific session.
type SessionSpecification struct {

	// The identifier of the alias of the bot that the session was held with.
	BotAliasId *string

	// The version of the bot that the session was held with.
	BotVersion *string

	// The channel that is integrated with the bot that the session was held with.
	Channel *string

	// The duration of the conversation in seconds. A conversation is defined as a
	// unique combination of a sessionId and an originatingRequestId .
	ConversationDurationSeconds *int64

	// The final state of the conversation. A conversation is defined as a unique
	// combination of a sessionId and an originatingRequestId .
	ConversationEndState ConversationEndState

	// The date and time when the conversation ended. A conversation is defined as a
	// unique combination of a sessionId and an originatingRequestId .
	ConversationEndTime *time.Time

	// The date and time when the conversation began. A conversation is defined as a
	// unique combination of a sessionId and an originatingRequestId .
	ConversationStartTime *time.Time

	// A list of objects containing the name of an intent that was invoked.
	InvokedIntentSamples []InvokedIntentSample

	// The locale of the bot that the session was held with.
	LocaleId *string

	// The mode of the session. The possible values are as follows:
	//
	//   - Speech – The session was spoken.
	//
	//   - Text – The session was written.
	//
	//   - DTMF – The session used a touch-tone keypad (Dual Tone Multi-Frequency).
	//
	//   - MultiMode – The session used multiple modes.
	Mode AnalyticsModality

	// The number of turns that the session took.
	NumberOfTurns *int64

	// The identifier of the first request in a session.
	OriginatingRequestId *string

	// The identifier of the session.
	SessionId *string

	noSmithyDocumentSerde
}

// Settings used when Amazon Lex successfully captures a slot value from a user.
type SlotCaptureSetting struct {

	// A list of conditional branches to evaluate after the slot value is captured.
	CaptureConditional *ConditionalSpecification

	// Specifies the next step that the bot runs when the slot value is captured
	// before the code hook times out.
	CaptureNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	CaptureResponse *ResponseSpecification

	// Code hook called after Amazon Lex successfully captures a slot value.
	CodeHook *DialogCodeHookInvocationSetting

	// Code hook called when Amazon Lex doesn't capture a slot value.
	ElicitationCodeHook *ElicitationCodeHookInvocationSetting

	// A list of conditional branches to evaluate when the slot value isn't captured.
	FailureConditional *ConditionalSpecification

	// Specifies the next step that the bot runs when the slot value code is not
	// recognized.
	FailureNextStep *DialogState

	// Specifies a list of message groups that Amazon Lex uses to respond the user
	// input.
	FailureResponse *ResponseSpecification

	noSmithyDocumentSerde
}

// Specifies the default value to use when a user doesn't provide a value for a
// slot.
type SlotDefaultValue struct {

	// The default value to use when a user doesn't provide a value for a slot.
	//
	// This member is required.
	DefaultValue *string

	noSmithyDocumentSerde
}

// Defines a list of values that Amazon Lex should use as the default value for a
// slot.
type SlotDefaultValueSpecification struct {

	// A list of default values. Amazon Lex chooses the default value to use in the
	// order that they are presented in the list.
	//
	// This member is required.
	DefaultValueList []SlotDefaultValue

	noSmithyDocumentSerde
}

// Filters the response from the ListSlots operation.
type SlotFilter struct {

	// The name of the field to use for filtering.
	//
	// This member is required.
	Name SlotFilterName

	// The operator to use for the filter. Specify EQ when the ListSlots operation
	// should return only aliases that equal the specified value. Specify CO when the
	// ListSlots operation should return aliases that contain the specified value.
	//
	// This member is required.
	Operator SlotFilterOperator

	// The value to use to filter the response.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Sets the priority that Amazon Lex should use when eliciting slot values from a
// user.
type SlotPriority struct {

	// The priority that Amazon Lex should apply to the slot.
	//
	// This member is required.
	Priority *int32

	// The unique identifier of the slot.
	//
	// This member is required.
	SlotId *string

	noSmithyDocumentSerde
}

// Contains specifications for the assisted slot resolution feature.
type SlotResolutionImprovementSpecification struct {

	// Specifies whether assisted slot resolution is turned on or off.
	//
	// This member is required.
	Enabled bool

	// An object containing information about the Amazon Bedrock model used to assist
	// slot resolution.
	BedrockModelSpecification *BedrockModelSpecification

	noSmithyDocumentSerde
}

// Contains information about whether assisted slot resolution is turned on for
// the slot or not.
type SlotResolutionSetting struct {

	// Specifies whether assisted slot resolution is turned on for the slot or not. If
	// the value is EnhancedFallback , assisted slot resolution is activated when
	// Amazon Lex defaults to the AMAZON.FallbackIntent . If the value is Default ,
	// assisted slot resolution is turned off.
	//
	// This member is required.
	SlotResolutionStrategy SlotResolutionStrategy

	noSmithyDocumentSerde
}

// Information about the success and failure rate of slot resolution in the
// results of a test execution.
type SlotResolutionTestResultItem struct {

	// A result for slot resolution in the results of a test execution.
	//
	// This member is required.
	ResultCounts *SlotResolutionTestResultItemCounts

	// The name of the slot.
	//
	// This member is required.
	SlotName *string

	noSmithyDocumentSerde
}

// Information about the counts for a slot resolution in the results of a test
// execution.
type SlotResolutionTestResultItemCounts struct {

	// The number of matched and mismatched results for slot resolution for the slot.
	//
	// This member is required.
	SlotMatchResultCounts map[string]int32

	// The total number of results.
	//
	// This member is required.
	TotalResultCount *int32

	// The number of matched, mismatched and execution error results for speech
	// transcription for the slot.
	SpeechTranscriptionResultCounts map[string]int32

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of bots.
type SlotSortBy struct {

	// The attribute to use to sort the list.
	//
	// This member is required.
	Attribute SlotSortAttribute

	// The order to sort the list. You can choose ascending or descending.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Summary information about a slot, a value that the bot elicits from the user.
type SlotSummary struct {

	// The description of the slot.
	Description *string

	// The timestamp of the last date and time that the slot was updated.
	LastUpdatedDateTime *time.Time

	// Whether the slot is required or optional. An intent is complete when all
	// required slots are filled.
	SlotConstraint SlotConstraint

	// The unique identifier of the slot.
	SlotId *string

	// The name given to the slot.
	SlotName *string

	// The unique identifier for the slot type that defines the values for the slot.
	SlotTypeId *string

	// Prompts that are sent to the user to elicit a value for the slot.
	ValueElicitationPromptSpecification *PromptSpecification

	noSmithyDocumentSerde
}

// Filters the response from the ListSlotTypes operation.
type SlotTypeFilter struct {

	// The name of the field to use for filtering.
	//
	// This member is required.
	Name SlotTypeFilterName

	// The operator to use for the filter. Specify EQ when the ListSlotTypes operation
	// should return only aliases that equal the specified value. Specify CO when the
	// ListSlotTypes operation should return aliases that contain the specified value.
	//
	// This member is required.
	Operator SlotTypeFilterOperator

	// The value to use to filter the response.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies attributes for sorting a list of slot types.
type SlotTypeSortBy struct {

	// The attribute to use to sort the list of slot types.
	//
	// This member is required.
	Attribute SlotTypeSortAttribute

	// The order to sort the list. You can say ascending or descending.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// The object that contains the statistical summary of the recommended slot type
// associated with the bot recommendation.
type SlotTypeStatistics struct {

	// The number of recommended slot types associated with the bot recommendation.
	DiscoveredSlotTypeCount *int32

	noSmithyDocumentSerde
}

// Provides summary information about a slot type.
type SlotTypeSummary struct {

	// The description of the slot type.
	Description *string

	// A timestamp of the date and time that the slot type was last updated.
	LastUpdatedDateTime *time.Time

	// If the slot type is derived from a built-on slot type, the name of the parent
	// slot type.
	ParentSlotTypeSignature *string

	// Indicates the type of the slot type.
	//
	//   - Custom - A slot type that you created using custom values. For more
	//   information, see [Creating custom slot types].
	//
	//   - Extended - A slot type created by extending the AMAZON.AlphaNumeric built-in
	//   slot type. For more information, see [AMAZON.AlphaNumeric]AMAZON.AlphaNumeric .
	//
	//   - ExternalGrammar - A slot type using a custom GRXML grammar to define values.
	//   For more information, see [Using a custom grammar slot type].
	//
	// [AMAZON.AlphaNumeric]: https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html
	// [Creating custom slot types]: https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html
	// [Using a custom grammar slot type]: https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html
	SlotTypeCategory SlotTypeCategory

	// The unique identifier assigned to the slot type.
	SlotTypeId *string

	// The name of the slot type.
	SlotTypeName *string

	noSmithyDocumentSerde
}

// Each slot type can have a set of values. Each SlotTypeValue represents a value
// that the slot type can take.
type SlotTypeValue struct {

	// The value of the slot type entry.
	SampleValue *SampleValue

	// Additional values related to the slot type entry.
	Synonyms []SampleValue

	noSmithyDocumentSerde
}

// The value to set in a slot.
type SlotValue struct {

	// The value that Amazon Lex determines for the slot. The actual value depends on
	// the setting of the value selection strategy for the bot. You can choose to use
	// the value entered by the user, or you can have Amazon Lex choose the first value
	// in the resolvedValues list.
	InterpretedValue *string

	noSmithyDocumentSerde
}

// Specifies the elicitation setting details eliciting a slot.
type SlotValueElicitationSetting struct {

	// Specifies whether the slot is required or optional.
	//
	// This member is required.
	SlotConstraint SlotConstraint

	// A list of default values for a slot. Default values are used when Amazon Lex
	// hasn't determined a value for a slot. You can specify default values from
	// context variables, session attributes, and defined values.
	DefaultValueSpecification *SlotDefaultValueSpecification

	// The prompt that Amazon Lex uses to elicit the slot value from the user.
	PromptSpecification *PromptSpecification

	// If you know a specific pattern that users might respond to an Amazon Lex
	// request for a slot value, you can provide those utterances to improve accuracy.
	// This is optional. In most cases, Amazon Lex is capable of understanding user
	// utterances.
	SampleUtterances []SampleUtterance

	// Specifies the settings that Amazon Lex uses when a slot value is successfully
	// entered by a user.
	SlotCaptureSetting *SlotCaptureSetting

	// An object containing information about whether assisted slot resolution is
	// turned on for the slot or not.
	SlotResolutionSetting *SlotResolutionSetting

	// Specifies the prompts that Amazon Lex uses while a bot is waiting for customer
	// input.
	WaitAndContinueSpecification *WaitAndContinueSpecification

	noSmithyDocumentSerde
}

// The slot values that Amazon Lex uses when it sets slot values in a dialog step.
type SlotValueOverride struct {

	// When the shape value is List , it indicates that the values field contains a
	// list of slot values. When the value is Scalar , it indicates that the value
	// field contains a single value.
	Shape SlotShape

	// The current value of the slot.
	Value *SlotValue

	// A list of one or more values that the user provided for the slot. For example,
	// for a slot that elicits pizza toppings, the values might be "pepperoni" and
	// "pineapple."
	Values []SlotValueOverride

	noSmithyDocumentSerde
}

// Provides a regular expression used to validate the value of a slot.
type SlotValueRegexFilter struct {

	// A regular expression used to validate the value of a slot.
	//
	// Use a standard regular expression. Amazon Lex supports the following characters
	// in the regular expression:
	//
	//   - A-Z, a-z
	//
	//   - 0-9
	//
	//   - Unicode characters ("\⁠u")
	//
	// Represent Unicode characters with four digits, for example "\⁠u0041" or
	// "\⁠u005A".
	//
	// The following regular expression operators are not supported:
	//
	//   - Infinite repeaters: *, +, or {x,} with no upper bound.
	//
	//   - Wild card (.)
	//
	// This member is required.
	Pattern *string

	noSmithyDocumentSerde
}

// Contains settings used by Amazon Lex to select a slot value.
type SlotValueSelectionSetting struct {

	// Determines the slot resolution strategy that Amazon Lex uses to return slot
	// type values. The field can be set to one of the following values:
	//
	//   - ORIGINAL_VALUE - Returns the value entered by the user, if the user value is
	//   similar to the slot value.
	//
	//   - TOP_RESOLUTION - If there is a resolution list for the slot, return the
	//   first value in the resolution list as the slot type value. If there is no
	//   resolution list, null is returned.
	//
	// If you don't specify the valueSelectionStrategy , the default is ORIGINAL_VALUE .
	//
	// This member is required.
	ResolutionStrategy SlotValueResolutionStrategy

	// Provides settings that enable advanced recognition settings for slot values.
	// You can use this to enable using slot values as a custom vocabulary for
	// recognizing user utterances.
	AdvancedRecognitionSetting *AdvancedRecognitionSetting

	// A regular expression used to validate the value of a slot.
	RegexFilter *SlotValueRegexFilter

	noSmithyDocumentSerde
}

// Subslot specifications.
type Specifications struct {

	// The unique identifier assigned to the slot type.
	//
	// This member is required.
	SlotTypeId *string

	// Specifies the elicitation setting details for constituent sub slots of a
	// composite slot.
	//
	// This member is required.
	ValueElicitationSetting *SubSlotValueElicitationSetting

	noSmithyDocumentSerde
}

// Configuration for a foundation model used for speech synthesis and recognition
// capabilities.
type SpeechFoundationModel struct {

	// The Amazon Resource Name (ARN) of the foundation model used for speech
	// processing.
	//
	// This member is required.
	ModelArn *string

	// The identifier of the voice to use for speech synthesis with the foundation
	// model.
	VoiceId *string

	noSmithyDocumentSerde
}

// Configuration settings that define which speech-to-text model to use for
// processing speech input.
type SpeechModelConfig struct {

	// Configuration settings for using Deepgram as the speech-to-text provider.
	DeepgramConfig *DeepgramSpeechModelConfig

	noSmithyDocumentSerde
}

// Settings that control how Amazon Lex processes and recognizes speech input from
// users.
type SpeechRecognitionSettings struct {

	// Configuration settings for the selected speech-to-text model.
	SpeechModelConfig *SpeechModelConfig

	// The speech-to-text model to use.
	SpeechModelPreference SpeechModelPreference

	noSmithyDocumentSerde
}

// Defines a Speech Synthesis Markup Language (SSML) prompt.
type SSMLMessage struct {

	// The SSML text that defines the prompt.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines the messages that Amazon Lex sends to a user to remind them that the
// bot is waiting for a response.
type StillWaitingResponseSpecification struct {

	// How often a message should be sent to the user. Minimum of 1 second, maximum of
	// 5 minutes.
	//
	// This member is required.
	FrequencyInSeconds *int32

	// One or more message groups, each containing one or more messages, that define
	// the prompts that Amazon Lex sends to the user.
	//
	// This member is required.
	MessageGroups []MessageGroup

	// If Amazon Lex waits longer than this length of time for a response, it will
	// stop sending messages.
	//
	// This member is required.
	TimeoutInSeconds *int32

	// Indicates that the user can interrupt the response by speaking while the
	// message is being played.
	AllowInterrupt *bool

	noSmithyDocumentSerde
}

// Specifications for the constituent sub slots and the expression for the
// composite slot.
type SubSlotSetting struct {

	// The expression text for defining the constituent sub slots in the composite
	// slot using logical AND and OR operators.
	Expression *string

	// Specifications for the constituent sub slots of a composite slot.
	SlotSpecifications map[string]Specifications

	noSmithyDocumentSerde
}

// Subslot type composition.
type SubSlotTypeComposition struct {

	// Name of a constituent sub slot inside a composite slot.
	//
	// This member is required.
	Name *string

	// The unique identifier assigned to a slot type. This refers to either a built-in
	// slot type or the unique slotTypeId of a custom slot type.
	//
	// This member is required.
	SlotTypeId *string

	noSmithyDocumentSerde
}

// Subslot elicitation settings.
//
// DefaultValueSpecification is a list of default values for a constituent sub
// slot in a composite slot. Default values are used when Amazon Lex hasn't
// determined a value for a slot. You can specify default values from context
// variables, session attributes, and defined values. This is similar to
// DefaultValueSpecification for slots.
//
// PromptSpecification is the prompt that Amazon Lex uses to elicit the sub slot
// value from the user. This is similar to PromptSpecification for slots.
type SubSlotValueElicitationSetting struct {

	// Specifies a list of message groups that Amazon Lex sends to a user to elicit a
	// response.
	//
	// This member is required.
	PromptSpecification *PromptSpecification

	// Defines a list of values that Amazon Lex should use as the default value for a
	// slot.
	DefaultValueSpecification *SlotDefaultValueSpecification

	// If you know a specific pattern that users might respond to an Amazon Lex
	// request for a sub slot value, you can provide those utterances to improve
	// accuracy. This is optional. In most cases Amazon Lex is capable of understanding
	// user utterances. This is similar to SampleUtterances for slots.
	SampleUtterances []SampleUtterance

	// Specifies the prompts that Amazon Lex uses while a bot is waiting for customer
	// input.
	WaitAndContinueSpecification *WaitAndContinueSpecification

	noSmithyDocumentSerde
}

// Contains information about the method by which to filter the results of the
// test execution.
type TestExecutionResultFilterBy struct {

	// Specifies which results to filter. See [Test result details">Test results details] for details about different types of
	// results.
	//
	// [Test result details">Test results details]: https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html
	//
	// This member is required.
	ResultTypeFilter TestResultTypeFilter

	// Contains information about the method for filtering Conversation level test
	// results.
	ConversationLevelTestResultsFilterBy *ConversationLevelTestResultsFilterBy

	noSmithyDocumentSerde
}

// Contains the results of the test execution, grouped by type of results. See [Test result details">Test results details]
// for details about different types of results.
//
// [Test result details">Test results details]: https://docs.aws.amazon.com/lexv2/latest/dg/test-results-details-test-set.html
type TestExecutionResultItems struct {

	// Results related to conversations in the test set, including metrics about
	// success and failure of conversations and intent and slot failures.
	ConversationLevelTestResults *ConversationLevelTestResults

	// Intent recognition results aggregated by intent name. The aggregated results
	// contain success and failure rates of intent recognition, speech transcriptions,
	// and end-to-end conversations.
	IntentClassificationTestResults *IntentClassificationTestResults

	// Slot resolution results aggregated by intent and slot name. The aggregated
	// results contain success and failure rates of slot resolution, speech
	// transcriptions, and end-to-end conversations
	IntentLevelSlotResolutionTestResults *IntentLevelSlotResolutionTestResults

	// Overall results for the test execution, including the breakdown of
	// conversations and single-input utterances.
	OverallTestResults *OverallTestResults

	// Results related to utterances in the test set.
	UtteranceLevelTestResults *UtteranceLevelTestResults

	noSmithyDocumentSerde
}

// Contains information about the method by which to sort the instances of test
// executions you have carried out.
type TestExecutionSortBy struct {

	// Specifies whether to sort the test set executions by the date and time at which
	// the test sets were created.
	//
	// This member is required.
	Attribute TestExecutionSortAttribute

	// Specifies whether to sort in ascending or descending order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Summarizes metadata about the test execution.
type TestExecutionSummary struct {

	// Specifies whether the API mode for the test execution is streaming or
	// non-streaming.
	ApiMode TestExecutionApiMode

	// The date and time at which the test execution was created.
	CreationDateTime *time.Time

	// The date and time at which the test execution was last updated.
	LastUpdatedDateTime *time.Time

	// Contains information about the bot used for the test execution..
	Target *TestExecutionTarget

	// The unique identifier of the test execution.
	TestExecutionId *string

	// Specifies whether the data used for the test execution is written or spoken.
	TestExecutionModality TestExecutionModality

	// The current status of the test execution.
	TestExecutionStatus TestExecutionStatus

	// The unique identifier of the test set used in the test execution.
	TestSetId *string

	// The name of the test set used in the test execution.
	TestSetName *string

	noSmithyDocumentSerde
}

// Contains information about the bot used for the test execution.
type TestExecutionTarget struct {

	// Contains information about the bot alias used for the test execution.
	BotAliasTarget *BotAliasTestExecutionTarget

	noSmithyDocumentSerde
}

// Contains details about the errors in the test set discrepancy report
type TestSetDiscrepancyErrors struct {

	// Contains information about discrepancies found for intents between the test set
	// and the bot.
	//
	// This member is required.
	IntentDiscrepancies []TestSetIntentDiscrepancyItem

	// Contains information about discrepancies found for slots between the test set
	// and the bot.
	//
	// This member is required.
	SlotDiscrepancies []TestSetSlotDiscrepancyItem

	noSmithyDocumentSerde
}

// Contains information about the bot alias used for the test set discrepancy
// report.
type TestSetDiscrepancyReportBotAliasTarget struct {

	// The unique identifier for the bot associated with the bot alias.
	//
	// This member is required.
	BotAliasId *string

	// The unique identifier for the bot alias.
	//
	// This member is required.
	BotId *string

	// The unique identifier of the locale associated with the bot alias.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// Contains information about the resource used for the test set discrepancy
// report.
type TestSetDiscrepancyReportResourceTarget struct {

	// Contains information about the bot alias used as the resource for the test set
	// discrepancy report.
	BotAliasTarget *TestSetDiscrepancyReportBotAliasTarget

	noSmithyDocumentSerde
}

// Contains information about the test set that is exported.
type TestSetExportSpecification struct {

	// The unique identifier of the test set.
	//
	// This member is required.
	TestSetId *string

	noSmithyDocumentSerde
}

// Contains information about the data source from which the test set is generated.
type TestSetGenerationDataSource struct {

	// Contains information about the bot from which the conversation logs are sourced.
	ConversationLogsDataSource *ConversationLogsDataSource

	noSmithyDocumentSerde
}

// Contains information about the Amazon S3 location from which the test set is
// imported.
type TestSetImportInputLocation struct {

	// The name of the Amazon S3 bucket.
	//
	// This member is required.
	S3BucketName *string

	// The path inside the Amazon S3 bucket pointing to the test-set CSV file.
	//
	// This member is required.
	S3Path *string

	noSmithyDocumentSerde
}

// Contains information about the test set that is imported.
type TestSetImportResourceSpecification struct {

	// Contains information about the input location from where test-set should be
	// imported.
	//
	// This member is required.
	ImportInputLocation *TestSetImportInputLocation

	// Specifies whether the test-set being imported contains written or spoken data.
	//
	// This member is required.
	Modality TestSetModality

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access the
	// test set.
	//
	// This member is required.
	RoleArn *string

	// Contains information about the location that Amazon Lex uses to store the
	// test-set.
	//
	// This member is required.
	StorageLocation *TestSetStorageLocation

	// The name of the test set.
	//
	// This member is required.
	TestSetName *string

	// The description of the test set.
	Description *string

	// A list of tags to add to the test set. You can only add tags when you
	// import/generate a new test set. You can't use the UpdateTestSet operation to
	// update tags. To update tags, use the TagResource operation.
	TestSetTags map[string]string

	noSmithyDocumentSerde
}

// Contains information about discrepancy in an intent information between the
// test set and the bot.
type TestSetIntentDiscrepancyItem struct {

	// The error message for a discrepancy for an intent between the test set and the
	// bot.
	//
	// This member is required.
	ErrorMessage *string

	// The name of the intent in the discrepancy report.
	//
	// This member is required.
	IntentName *string

	noSmithyDocumentSerde
}

// Contains information about discrepancy in a slot information between the test
// set and the bot.
type TestSetSlotDiscrepancyItem struct {

	// The error message for a discrepancy for an intent between the test set and the
	// bot.
	//
	// This member is required.
	ErrorMessage *string

	// The name of the intent associated with the slot in the discrepancy report.
	//
	// This member is required.
	IntentName *string

	// The name of the slot in the discrepancy report.
	//
	// This member is required.
	SlotName *string

	noSmithyDocumentSerde
}

// Contains information about the methods by which to sort the test set.
type TestSetSortBy struct {

	// Specifies whether to sort the test sets by name or by the time they were last
	// updated.
	//
	// This member is required.
	Attribute TestSetSortAttribute

	// Specifies whether to sort in ascending or descending order.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Contains information about the location in which the test set is stored.
type TestSetStorageLocation struct {

	// The name of the Amazon S3 bucket in which the test set is stored.
	//
	// This member is required.
	S3BucketName *string

	// The path inside the Amazon S3 bucket where the test set is stored.
	//
	// This member is required.
	S3Path *string

	// The Amazon Resource Name (ARN) of an Amazon Web Services Key Management Service
	// (KMS) key for encrypting the test set.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains summary information about the test set.
type TestSetSummary struct {

	// The date and time at which the test set was created.
	CreationDateTime *time.Time

	// The description of the test set.
	Description *string

	// The date and time at which the test set was last updated.
	LastUpdatedDateTime *time.Time

	// Specifies whether the test set contains written or spoken data.
	Modality TestSetModality

	// The number of turns in the test set.
	NumTurns *int32

	// The Amazon Resource Name (ARN) of an IAM role that has permission to access the
	// test set.
	RoleArn *string

	// The status of the test set.
	Status TestSetStatus

	// Contains information about the location at which the test set is stored.
	StorageLocation *TestSetStorageLocation

	// The unique identifier of the test set.
	TestSetId *string

	// The name of the test set.
	TestSetName *string

	noSmithyDocumentSerde
}

// Contains information about a turn in a test set.
type TestSetTurnRecord struct {

	// The record number associated with the turn.
	//
	// This member is required.
	RecordNumber *int64

	// Contains information about the agent or user turn depending upon type of turn.
	//
	// This member is required.
	TurnSpecification *TurnSpecification

	// The unique identifier for the conversation associated with the turn.
	ConversationId *string

	// The number of turns that has elapsed up to that turn.
	TurnNumber *int32

	noSmithyDocumentSerde
}

// Contains information about the results of the analysis of a turn in the test
// set.
type TestSetTurnResult struct {

	// Contains information about the agent messages in the turn.
	Agent *AgentTurnResult

	// Contains information about the user messages in the turn.
	User *UserTurnResult

	noSmithyDocumentSerde
}

// Specifies the text input specifications.
type TextInputSpecification struct {

	// Time for which a bot waits before re-prompting a customer for text input.
	//
	// This member is required.
	StartTimeoutMs *int32

	noSmithyDocumentSerde
}

// Defines the Amazon CloudWatch Logs destination log group for conversation text
// logs.
type TextLogDestination struct {

	// Defines the Amazon CloudWatch Logs log group where text and metadata logs are
	// delivered.
	//
	// This member is required.
	CloudWatch *CloudWatchLogGroupLogDestination

	noSmithyDocumentSerde
}

// Defines settings to enable text conversation logs.
type TextLogSetting struct {

	// Defines the Amazon CloudWatch Logs destination log group for conversation text
	// logs.
	//
	// This member is required.
	Destination *TextLogDestination

	// Determines whether conversation logs should be stored for an alias.
	//
	// This member is required.
	Enabled bool

	// The option to enable selective conversation log capture for text.
	SelectiveLoggingEnabled *bool

	noSmithyDocumentSerde
}

// The object representing the filter that Amazon Lex will use to select the
// appropriate transcript.
type TranscriptFilter struct {

	// The object representing the filter that Amazon Lex will use to select the
	// appropriate transcript when the transcript format is the Amazon Lex format.
	LexTranscriptFilter *LexTranscriptFilter

	noSmithyDocumentSerde
}

// Indicates the setting of the location where the transcript is stored.
type TranscriptSourceSetting struct {

	// Indicates the setting of the Amazon S3 bucket where the transcript is stored.
	S3BucketTranscriptSource *S3BucketTranscriptSource

	noSmithyDocumentSerde
}

// Contains information about the messages in the turn.
type TurnSpecification struct {

	// Contains information about the agent messages in the turn.
	AgentTurn *AgentTurnSpecification

	// Contains information about the user messages in the turn.
	UserTurn *UserTurnSpecification

	noSmithyDocumentSerde
}

// Unified configuration settings that combine speech recognition and synthesis
// capabilities.
type UnifiedSpeechSettings struct {

	// The foundation model configuration to use for unified speech processing
	// capabilities.
	//
	// This member is required.
	SpeechFoundationModel *SpeechFoundationModel

	noSmithyDocumentSerde
}

// Contains information about the user messages in the turn in the input.
type UserTurnInputSpecification struct {

	// The utterance input in the user turn.
	//
	// This member is required.
	UtteranceInput *UtteranceInputSpecification

	// Request attributes of the user turn.
	RequestAttributes map[string]string

	// Contains information about the session state in the input.
	SessionState *InputSessionStateSpecification

	noSmithyDocumentSerde
}

// Contains information about the intent that is output for the turn by the test
// execution.
type UserTurnIntentOutput struct {

	// The name of the intent.
	//
	// This member is required.
	Name *string

	// The slots associated with the intent.
	Slots map[string]UserTurnSlotOutput

	noSmithyDocumentSerde
}

// Contains results that are output for the user turn by the test execution.
type UserTurnOutputSpecification struct {

	// Contains information about the intent.
	//
	// This member is required.
	Intent *UserTurnIntentOutput

	// The contexts that are active in the turn.
	ActiveContexts []ActiveContext

	// The transcript that is output for the user turn by the test execution.
	Transcript *string

	noSmithyDocumentSerde
}

// Contains the results for the user turn by the test execution.
type UserTurnResult struct {

	// Contains information about the expected output for the user turn.
	//
	// This member is required.
	ExpectedOutput *UserTurnOutputSpecification

	// Contains information about the user messages in the turn in the input.
	//
	// This member is required.
	Input *UserTurnInputSpecification

	// Contains information about the actual output for the user turn.
	ActualOutput *UserTurnOutputSpecification

	// Contains information about the results related to the conversation associated
	// with the user turn.
	ConversationLevelResult *ConversationLevelResultDetail

	// Specifies whether the expected and actual outputs match or not, or if there is
	// an error in execution.
	EndToEndResult TestResultMatchStatus

	// Details about an error in an execution of a test set.
	ErrorDetails *ExecutionErrorDetails

	// Specifies whether the expected and actual intents match or not.
	IntentMatchResult TestResultMatchStatus

	// Specifies whether the expected and actual slots match or not.
	SlotMatchResult TestResultMatchStatus

	// Specifies whether the expected and actual speech transcriptions match or not,
	// or if there is an error in execution.
	SpeechTranscriptionResult TestResultMatchStatus

	noSmithyDocumentSerde
}

// Contains information about a slot output by the test set execution.
type UserTurnSlotOutput struct {

	// A list of items mapping the name of the subslots to information about those
	// subslots.
	SubSlots map[string]UserTurnSlotOutput

	// The value output by the slot recognition.
	Value *string

	// Values that are output by the slot recognition.
	Values []UserTurnSlotOutput

	noSmithyDocumentSerde
}

// Contains information about the expected and input values for the user turn.
type UserTurnSpecification struct {

	// Contains results about the expected output for the user turn.
	//
	// This member is required.
	Expected *UserTurnOutputSpecification

	// Contains information about the user messages in the turn in the input.
	//
	// This member is required.
	Input *UserTurnInputSpecification

	noSmithyDocumentSerde
}

// Provides parameters for setting the time window and duration for aggregating
// utterance data.
type UtteranceAggregationDuration struct {

	// The desired time window for aggregating utterances.
	//
	// This member is required.
	RelativeAggregationDuration *RelativeAggregationDuration

	noSmithyDocumentSerde
}

// Contains information about the audio for an utterance.
type UtteranceAudioInputSpecification struct {

	// Amazon S3 file pointing to the audio.
	//
	// This member is required.
	AudioFileS3Location *string

	noSmithyDocumentSerde
}

// An object that contains a response to the utterance from the bot.
type UtteranceBotResponse struct {

	// The text of the response to the utterance from the bot.
	Content *string

	// The type of the response. The following values are possible:
	//
	//   - PlainText – A plain text string.
	//
	//   - CustomPayload – A response string that you can customize to include data or
	//   metadata for your application.
	//
	//   - SSML – A string that includes Speech Synthesis Markup Language to customize
	//   the audio response.
	//
	//   - ImageResponseCard – An image with buttons that the customer can select. See [ImageResponseCard]
	//   for more information.
	//
	// [ImageResponseCard]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html
	ContentType UtteranceContentType

	// A card that is shown to the user by a messaging platform. You define the
	// contents of the card, the card is displayed by the platform.
	//
	// When you use a response card, the response from the user is constrained to the
	// text associated with a button on the card.
	ImageResponseCard *ImageResponseCard

	noSmithyDocumentSerde
}

// An object specifying the measure and method by which to sort the utterance data.
type UtteranceDataSortBy struct {

	// The measure by which to sort the utterance analytics data.
	//
	//   - Count – The number of utterances.
	//
	//   - UtteranceTimestamp – The date and time of the utterance.
	//
	// This member is required.
	Name AnalyticsUtteranceSortByName

	// Specifies whether to sort the results in ascending or descending order.
	//
	// This member is required.
	Order AnalyticsSortOrder

	noSmithyDocumentSerde
}

// Contains information about input of an utterance.
type UtteranceInputSpecification struct {

	// Contains information about the audio input for an utterance.
	AudioInput *UtteranceAudioInputSpecification

	// A text input transcription of the utterance. It is only applicable for
	// test-sets containing text data.
	TextInput *string

	noSmithyDocumentSerde
}

// Contains information about multiple utterances in the results of a test set
// execution.
type UtteranceLevelTestResultItem struct {

	// The record number of the result.
	//
	// This member is required.
	RecordNumber *int64

	// Contains information about the turn associated with the result.
	//
	// This member is required.
	TurnResult *TestSetTurnResult

	// The unique identifier for the conversation associated with the result.
	ConversationId *string

	noSmithyDocumentSerde
}

// Contains information about the utterances in the results of the test set
// execution.
type UtteranceLevelTestResults struct {

	// Contains information about an utterance in the results of the test set
	// execution.
	//
	// This member is required.
	Items []UtteranceLevelTestResultItem

	noSmithyDocumentSerde
}

// An object containing information about a specific utterance.
type UtteranceSpecification struct {

	// The name of the intent that the utterance is associated to.
	AssociatedIntentName *string

	// The name of the slot that the utterance is associated to.
	AssociatedSlotName *string

	// The duration in milliseconds of the audio associated with the utterance.
	AudioVoiceDurationMillis *int64

	// The identifier of the alias of the bot that the utterance was made to.
	BotAliasId *string

	// The identifier for the audio of the bot response.
	BotResponseAudioVoiceId *string

	// A list of objects containing information about the bot response to the
	// utterance.
	BotResponses []UtteranceBotResponse

	// The version of the bot that the utterance was made to.
	BotVersion *string

	// The channel that is integrated with the bot that the utterance was made to.
	Channel *string

	// The date and time when the conversation in which the utterance took place
	// ended. A conversation is defined as a unique combination of a sessionId and an
	// originatingRequestId .
	ConversationEndTime *time.Time

	// The date and time when the conversation in which the utterance took place
	// began. A conversation is defined as a unique combination of a sessionId and an
	// originatingRequestId .
	ConversationStartTime *time.Time

	// The type of dialog action that the utterance is associated to. See the type
	// field in [DialogAction]for more information.
	//
	// [DialogAction]: https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_DialogAction.html
	DialogActionType *string

	// The input type of the utterance. The possible values are as follows:
	//
	//   - PCM format: audio data must be in little-endian byte order.
	//
	//   - audio/l16; rate=16000; channels=1
	//
	//   - audio/x-l16; sample-rate=16000; channel-count=1
	//
	//   - audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1;
	//   is-big-endian=false
	//
	//   - Opus format
	//
	//   -
	//   audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4
	//
	//   - Text format
	//
	//   - text/plain; charset=utf-8
	InputType *string

	// The state of the intent that the utterance is associated to.
	IntentState IntentState

	// The locale of the bot that the utterance was made to.
	LocaleId *string

	// The mode of the session. The possible values are as follows:
	//
	//   - Speech – The session consisted of spoken dialogue.
	//
	//   - Text – The session consisted of written dialogue.
	//
	//   - DTMF – The session consisted of touch-tone keypad (Dual Tone
	//   Multi-Frequency) key presses.
	//
	//   - MultiMode – The session consisted of multiple modes.
	Mode AnalyticsModality

	// The output type of the utterance. The possible values are as follows:
	//
	//   - audio/mpeg
	//
	//   - audio/ogg
	//
	//   - audio/pcm (16 KHz)
	//
	//   - audio/ (defaults to mpeg )
	//
	//   - text/plain; charset=utf-8
	OutputType *string

	// The identifier of the session that the utterance was made in.
	SessionId *string

	// The slots that have been filled in the session by the time of the utterance.
	SlotsFilledInSession *string

	// The text of the utterance.
	Utterance *string

	// The identifier of the request associated with the utterance.
	UtteranceRequestId *string

	// The date and time when the utterance took place.
	UtteranceTimestamp *time.Time

	// Specifies whether the bot understood the utterance or not.
	UtteranceUnderstood bool

	noSmithyDocumentSerde
}

// Defines settings for using an Amazon Polly voice to communicate with a user.
//
// Valid values include:
//
//   - standard
//
//   - neural
//
//   - long-form
//
//   - generative
type VoiceSettings struct {

	// The identifier of the Amazon Polly voice to use.
	//
	// This member is required.
	VoiceId *string

	// Indicates the type of Amazon Polly voice that Amazon Lex should use for voice
	// interaction with the user. For more information, see the [engine parameter of the SynthesizeSpeech operation]engine SynthesizeSpeech
	// in the Amazon Polly developer guide.
	//
	// If you do not specify a value, the default is standard .
	//
	// [engine parameter of the SynthesizeSpeech operation]: https://docs.aws.amazon.com/polly/latest/dg/API_SynthesizeSpeech.html#polly-SynthesizeSpeech-request-Engine
	Engine VoiceEngine

	noSmithyDocumentSerde
}

// Specifies the prompts that Amazon Lex uses while a bot is waiting for customer
// input.
type WaitAndContinueSpecification struct {

	// The response that Amazon Lex sends to indicate that the bot is ready to
	// continue the conversation.
	//
	// This member is required.
	ContinueResponse *ResponseSpecification

	// The response that Amazon Lex sends to indicate that the bot is waiting for the
	// conversation to continue.
	//
	// This member is required.
	WaitingResponse *ResponseSpecification

	// Specifies whether the bot will wait for a user to respond. When this field is
	// false, wait and continue responses for a slot aren't used. If the active field
	// isn't specified, the default is true.
	Active *bool

	// A response that Amazon Lex sends periodically to the user to indicate that the
	// bot is still waiting for input from the user.
	StillWaitingResponse *StillWaitingResponseSpecification

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
