// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of capacity providers in your account.
func (c *Client) ListCapacityProviders(ctx context.Context, params *ListCapacityProvidersInput, optFns ...func(*Options)) (*ListCapacityProvidersOutput, error) {
	if params == nil {
		params = &ListCapacityProvidersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCapacityProviders", params, optFns, c.addOperationListCapacityProvidersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCapacityProvidersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCapacityProvidersInput struct {

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string

	// The maximum number of capacity providers to return.
	MaxItems *int32

	// Filter capacity providers by their current state.
	State types.CapacityProviderState

	noSmithyDocumentSerde
}

type ListCapacityProvidersOutput struct {

	// A list of capacity providers in your account.
	//
	// This member is required.
	CapacityProviders []types.CapacityProvider

	// The pagination token that's included if more results are available.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCapacityProvidersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCapacityProviders{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCapacityProviders{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCapacityProviders"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCapacityProviders(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCapacityProvidersPaginatorOptions is the paginator options for
// ListCapacityProviders
type ListCapacityProvidersPaginatorOptions struct {
	// The maximum number of capacity providers to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCapacityProvidersPaginator is a paginator for ListCapacityProviders
type ListCapacityProvidersPaginator struct {
	options   ListCapacityProvidersPaginatorOptions
	client    ListCapacityProvidersAPIClient
	params    *ListCapacityProvidersInput
	nextToken *string
	firstPage bool
}

// NewListCapacityProvidersPaginator returns a new ListCapacityProvidersPaginator
func NewListCapacityProvidersPaginator(client ListCapacityProvidersAPIClient, params *ListCapacityProvidersInput, optFns ...func(*ListCapacityProvidersPaginatorOptions)) *ListCapacityProvidersPaginator {
	if params == nil {
		params = &ListCapacityProvidersInput{}
	}

	options := ListCapacityProvidersPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCapacityProvidersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCapacityProvidersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCapacityProviders page.
func (p *ListCapacityProvidersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCapacityProvidersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCapacityProviders(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCapacityProvidersAPIClient is a client that implements the
// ListCapacityProviders operation.
type ListCapacityProvidersAPIClient interface {
	ListCapacityProviders(context.Context, *ListCapacityProvidersInput, ...func(*Options)) (*ListCapacityProvidersOutput, error)
}

var _ ListCapacityProvidersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCapacityProviders(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCapacityProviders",
	}
}
