// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure that encapsulates a signaling channel's metadata and properties.
type ChannelInfo struct {

	// The Amazon Resource Name (ARN) of the signaling channel.
	ChannelARN *string

	// The name of the signaling channel.
	ChannelName *string

	// Current status of the signaling channel.
	ChannelStatus Status

	// The type of the signaling channel.
	ChannelType ChannelType

	// The time at which the signaling channel was created.
	CreationTime *time.Time

	// A structure that contains the configuration for the SINGLE_MASTER channel type.
	SingleMasterConfiguration *SingleMasterConfiguration

	// The current version of the signaling channel.
	Version *string

	noSmithyDocumentSerde
}

// An optional input parameter for the ListSignalingChannels API. When this
// parameter is specified while invoking ListSignalingChannels , the API returns
// only the channels that satisfy a condition specified in ChannelNameCondition .
type ChannelNameCondition struct {

	// A comparison operator. Currently, you can only specify the BEGINS_WITH
	// operator, which finds signaling channels whose names begin with a given prefix.
	ComparisonOperator ComparisonOperator

	// A value to compare.
	ComparisonValue *string

	noSmithyDocumentSerde
}

// The configuration details required to delete the connection of the stream from
// the Edge Agent.
type DeletionConfig struct {

	// The boolean value used to indicate whether or not you want to mark the media
	// for deletion, once it has been uploaded to the Kinesis Video Stream cloud. The
	// media files can be deleted if any of the deletion configuration values are set
	// to true , such as when the limit for the EdgeRetentionInHours , or the
	// MaxLocalMediaSizeInMB , has been reached.
	//
	// Since the default value is set to true , configure the uploader schedule such
	// that the media files are not being deleted before they are initially uploaded to
	// the Amazon Web Services cloud.
	DeleteAfterUpload *bool

	// The number of hours that you want to retain the data in the stream on the Edge
	// Agent. The default value of the retention time is 720 hours, which translates to
	// 30 days.
	EdgeRetentionInHours *int32

	// The value of the local size required in order to delete the edge configuration.
	LocalSizeConfig *LocalSizeConfig

	noSmithyDocumentSerde
}

// An object that contains the latest status details for an edge agent's recorder
// and uploader jobs. Use this information to determine the current health of an
// edge agent.
type EdgeAgentStatus struct {

	// The latest status of a stream’s edge recording job.
	LastRecorderStatus *LastRecorderStatus

	// The latest status of a stream’s edge to cloud uploader job.
	LastUploaderStatus *LastUploaderStatus

	noSmithyDocumentSerde
}

// A description of the stream's edge configuration that will be used to sync with
// the Edge Agent IoT Greengrass component. The Edge Agent component will run on an
// IoT Hub Device setup at your premise.
type EdgeConfig struct {

	// The "Internet of Things (IoT) Thing" Arn of the stream.
	//
	// This member is required.
	HubDeviceArn *string

	// The recorder configuration consists of the local MediaSourceConfig details,
	// that are used as credentials to access the local media files streamed on the
	// camera.
	//
	// This member is required.
	RecorderConfig *RecorderConfig

	// The deletion configuration is made up of the retention time (
	// EdgeRetentionInHours ) and local size configuration ( LocalSizeConfig ) details
	// that are used to make the deletion.
	DeletionConfig *DeletionConfig

	// The uploader configuration contains the ScheduleExpression details that are
	// used to schedule upload jobs for the recorded media files from the Edge Agent to
	// a Kinesis Video Stream.
	UploaderConfig *UploaderConfig

	noSmithyDocumentSerde
}

// The structure that contains the information required for the KVS images
// delivery. If null, the configuration will be deleted from the stream.
type ImageGenerationConfiguration struct {

	// The structure that contains the information required to deliver images to a
	// customer.
	//
	// This member is required.
	DestinationConfig *ImageGenerationDestinationConfig

	// The accepted image format.
	//
	// This member is required.
	Format Format

	// The origin of the Server or Producer timestamps to use to generate the images.
	//
	// This member is required.
	ImageSelectorType ImageSelectorType

	// The time interval in milliseconds (ms) at which the images need to be generated
	// from the stream. The minimum value that can be provided is 200 ms. If the
	// timestamp range is less than the sampling interval, the Image from the
	// StartTimestamp will be returned if available.
	//
	// This member is required.
	SamplingInterval *int32

	// Indicates whether the ContinuousImageGenerationConfigurations API is enabled or
	// disabled.
	//
	// This member is required.
	Status ConfigurationStatus

	// The list of a key-value pair structure that contains extra parameters that can
	// be applied when the image is generated. The FormatConfig key is the JPEGQuality
	// , which indicates the JPEG quality key to be used to generate the image. The
	// FormatConfig value accepts ints from 1 to 100. If the value is 1, the image will
	// be generated with less quality and the best compression. If the value is 100,
	// the image will be generated with the best quality and less compression. If no
	// value is provided, the default value of the JPEGQuality key will be set to 80.
	FormatConfig map[string]string

	// The height of the output image that is used in conjunction with the WidthPixels
	// parameter. When both HeightPixels and WidthPixels parameters are provided, the
	// image will be stretched to fit the specified aspect ratio. If only the
	// HeightPixels parameter is provided, its original aspect ratio will be used to
	// calculate the WidthPixels ratio. If neither parameter is provided, the original
	// image size will be returned.
	HeightPixels *int32

	// The width of the output image that is used in conjunction with the HeightPixels
	// parameter. When both WidthPixels and HeightPixels parameters are provided, the
	// image will be stretched to fit the specified aspect ratio. If only the
	// WidthPixels parameter is provided, its original aspect ratio will be used to
	// calculate the HeightPixels ratio. If neither parameter is provided, the
	// original image size will be returned.
	WidthPixels *int32

	noSmithyDocumentSerde
}

// The structure that contains the information required to deliver images to a
// customer.
type ImageGenerationDestinationConfig struct {

	// The Amazon Web Services Region of the S3 bucket where images will be delivered.
	// This DestinationRegion must match the Region where the stream is located.
	//
	// This member is required.
	DestinationRegion *string

	// The Uniform Resource Identifier (URI) that identifies where the images will be
	// delivered.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// The latest status of a stream's edge recording job.
type LastRecorderStatus struct {

	// A description of a recorder job’s latest status.
	JobStatusDetails *string

	// The timestamp at which the recorder job was last executed and media stored to
	// local disk.
	LastCollectedTime *time.Time

	// The timestamp at which the recorder status was last updated.
	LastUpdatedTime *time.Time

	// The status of the latest recorder job.
	RecorderStatus RecorderStatus

	noSmithyDocumentSerde
}

// The latest status of a stream’s edge to cloud uploader job.
type LastUploaderStatus struct {

	// A description of an uploader job’s latest status.
	JobStatusDetails *string

	// The timestamp at which the uploader job was last executed and media collected
	// to the cloud.
	LastCollectedTime *time.Time

	// The timestamp at which the uploader status was last updated.
	LastUpdatedTime *time.Time

	// The status of the latest uploader job.
	UploaderStatus UploaderStatus

	noSmithyDocumentSerde
}

// A description of a single stream's edge configuration.
type ListEdgeAgentConfigurationsEdgeConfig struct {

	// The timestamp when the stream first created the edge config.
	CreationTime *time.Time

	// A description of the stream's edge configuration that will be used to sync with
	// the Edge Agent IoT Greengrass component. The Edge Agent component will run on an
	// IoT Hub Device setup at your premise.
	EdgeConfig *EdgeConfig

	// A description of the generated failure status.
	FailedStatusDetails *string

	// The timestamp when the stream last updated the edge config.
	LastUpdatedTime *time.Time

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string

	// The name of the stream.
	StreamName *string

	// The current sync status of the stream's edge configuration.
	SyncStatus SyncStatus

	noSmithyDocumentSerde
}

// The configuration details that include the maximum size of the media (
// MaxLocalMediaSizeInMB ) that you want to store for a stream on the Edge Agent,
// as well as the strategy that should be used ( StrategyOnFullSize ) when a
// stream's maximum size has been reached.
type LocalSizeConfig struct {

	// The overall maximum size of the media that you want to store for a stream on
	// the Edge Agent.
	MaxLocalMediaSizeInMB *int32

	// The strategy to perform when a stream’s MaxLocalMediaSizeInMB limit is reached.
	StrategyOnFullSize StrategyOnFullSize

	noSmithyDocumentSerde
}

// A structure that encapsulates, or contains, the media storage configuration
// properties.
type MappedResourceConfigurationListItem struct {

	// The Amazon Resource Name (ARN) of the Kinesis Video Stream resource, associated
	// with the stream.
	ARN *string

	// The type of the associated resource for the kinesis video stream.
	Type *string

	noSmithyDocumentSerde
}

// The configuration details that consist of the credentials required (
// MediaUriSecretArn and MediaUriType ) to access the media files that are streamed
// to the camera.
type MediaSourceConfig struct {

	// The Amazon Web Services Secrets Manager ARN for the username and password of
	// the camera, or a local media file location.
	//
	// This member is required.
	MediaUriSecretArn *string

	// The Uniform Resource Identifier (URI) type. The FILE_URI value can be used to
	// stream local media files.
	//
	// Preview only supports the RTSP_URI media source URI format .
	//
	// This member is required.
	MediaUriType MediaUriType

	noSmithyDocumentSerde
}

// A structure that encapsulates, or contains, the media storage configuration
// properties.
//
//   - If StorageStatus is enabled, the data will be stored in the StreamARN
//     provided. In order for WebRTC Ingestion to work, the stream must have data
//     retention enabled.
//
//   - If StorageStatus is disabled, no data will be stored, and the StreamARN
//     parameter will not be needed.
type MediaStorageConfiguration struct {

	// The status of the media storage configuration.
	//
	// This member is required.
	Status MediaStorageConfigurationStatus

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string

	noSmithyDocumentSerde
}

// Use this API to configure Amazon Simple Notification Service (Amazon SNS)
// notifications for when fragments become available in a stream. If this parameter
// is null, the configuration will be deleted from the stream.
//
// See [Notifications in Kinesis Video Streams] for more information.
//
// [Notifications in Kinesis Video Streams]: https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/notifications.html
type NotificationConfiguration struct {

	// The destination information required to deliver a notification to a customer.
	//
	// This member is required.
	DestinationConfig *NotificationDestinationConfig

	// Indicates if a notification configuration is enabled or disabled.
	//
	// This member is required.
	Status ConfigurationStatus

	noSmithyDocumentSerde
}

// The structure that contains the information required to deliver a notification
// to a customer.
type NotificationDestinationConfig struct {

	// The Uniform Resource Identifier (URI) that identifies where the images will be
	// delivered.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// The recorder configuration consists of the local MediaSourceConfig details that
// are used as credentials to access the local media files streamed on the camera.
type RecorderConfig struct {

	// The configuration details that consist of the credentials required (
	// MediaUriSecretArn and MediaUriType ) to access the media files streamed to the
	// camera.
	//
	// This member is required.
	MediaSourceConfig *MediaSourceConfig

	// The configuration that consists of the ScheduleExpression and the
	// DurationInMinutes details that specify the scheduling to record from a camera,
	// or local media file, onto the Edge Agent. If the ScheduleExpression attribute
	// is not provided, then the Edge Agent will always be set to recording mode.
	ScheduleConfig *ScheduleConfig

	noSmithyDocumentSerde
}

// An object that describes the endpoint of the signaling channel returned by the
// GetSignalingChannelEndpoint API.
//
// The media server endpoint will correspond to the WEBRTC Protocol.
type ResourceEndpointListItem struct {

	// The protocol of the signaling channel returned by the
	// GetSignalingChannelEndpoint API.
	Protocol ChannelProtocol

	// The endpoint of the signaling channel returned by the
	// GetSignalingChannelEndpoint API.
	ResourceEndpoint *string

	noSmithyDocumentSerde
}

// This API enables you to specify the duration that the camera, or local media
// file, should record onto the Edge Agent. The ScheduleConfig consists of the
// ScheduleExpression and the DurationInMinutes attributes.
//
// If the ScheduleConfig is not provided in the RecorderConfig , then the Edge
// Agent will always be set to recording mode.
//
// If the ScheduleConfig is not provided in the UploaderConfig , then the Edge
// Agent will upload at regular intervals (every 1 hour).
type ScheduleConfig struct {

	// The total duration to record the media. If the ScheduleExpression attribute is
	// provided, then the DurationInSeconds attribute should also be specified.
	//
	// This member is required.
	DurationInSeconds *int32

	// The Quartz cron expression that takes care of scheduling jobs to record from
	// the camera, or local media file, onto the Edge Agent. If the ScheduleExpression
	// is not provided for the RecorderConfig , then the Edge Agent will always be set
	// to recording mode.
	//
	// For more information about Quartz, refer to the [Cron Trigger Tutorial] page to understand the valid
	// expressions and its use.
	//
	// [Cron Trigger Tutorial]: https://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html
	//
	// This member is required.
	ScheduleExpression *string

	noSmithyDocumentSerde
}

// An object that contains the endpoint configuration for the SINGLE_MASTER
// channel type.
type SingleMasterChannelEndpointConfiguration struct {

	// This property is used to determine the nature of communication over this
	// SINGLE_MASTER signaling channel. If WSS is specified, this API returns a
	// websocket endpoint. If HTTPS is specified, this API returns an HTTPS endpoint.
	Protocols []ChannelProtocol

	// This property is used to determine messaging permissions in this SINGLE_MASTER
	// signaling channel. If MASTER is specified, this API returns an endpoint that a
	// client can use to receive offers from and send answers to any of the viewers on
	// this signaling channel. If VIEWER is specified, this API returns an endpoint
	// that a client can use only to send offers to another MASTER client on this
	// signaling channel.
	Role ChannelRole

	noSmithyDocumentSerde
}

// A structure that contains the configuration for the SINGLE_MASTER channel type.
type SingleMasterConfiguration struct {

	// The period of time (in seconds) a signaling channel retains undelivered
	// messages before they are discarded. Use to update this value.
	MessageTtlSeconds *int32

	noSmithyDocumentSerde
}

// An object describing a Kinesis video stream.
type StreamInfo struct {

	// A time stamp that indicates when the stream was created.
	CreationTime *time.Time

	// How long the stream retains data, in hours.
	DataRetentionInHours *int32

	// The name of the device that is associated with the stream.
	DeviceName *string

	// The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses
	// to encrypt data on the stream.
	KmsKeyId *string

	// The MediaType of the stream.
	MediaType *string

	// The status of the stream.
	Status Status

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string

	// The name of the stream.
	StreamName *string

	// The version of the stream.
	Version *string

	noSmithyDocumentSerde
}

// Specifies the condition that streams must satisfy to be returned when you list
// streams (see the ListStreams API). A condition has a comparison operation and a
// value. Currently, you can specify only the BEGINS_WITH operator, which finds
// streams whose names start with a given prefix.
type StreamNameCondition struct {

	// A comparison operator. Currently, you can specify only the BEGINS_WITH
	// operator, which finds streams whose names start with a given prefix.
	ComparisonOperator ComparisonOperator

	// A value to compare.
	ComparisonValue *string

	noSmithyDocumentSerde
}

// The configuration for stream storage, including the default storage tier for
// stream data. This configuration determines how stream data is stored and
// accessed, with different tiers offering varying levels of performance and cost
// optimization.
type StreamStorageConfiguration struct {

	// The default storage tier for the stream data. This setting determines the
	// storage class used for stream data, affecting both performance characteristics
	// and storage costs.
	//
	// Available storage tiers:
	//
	//   - HOT - Optimized for frequent access with the lowest latency and highest
	//   performance. Ideal for real-time applications and frequently accessed data.
	//
	//   - WARM - Balanced performance and cost for moderately accessed data. Suitable
	//   for data that is accessed regularly but not continuously.
	//
	// This member is required.
	DefaultStorageTier DefaultStorageTier

	noSmithyDocumentSerde
}

// A key and value pair that is associated with the specified signaling channel.
type Tag struct {

	// The key of the tag that is associated with the specified signaling channel.
	//
	// This member is required.
	Key *string

	// The value of the tag that is associated with the specified signaling channel.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The configuration that consists of the ScheduleExpression and the
// DurationInMinutes details that specify the scheduling to record from a camera,
// or local media file, onto the Edge Agent. If the ScheduleConfig is not provided
// in the UploaderConfig , then the Edge Agent will upload at regular intervals
// (every 1 hour).
type UploaderConfig struct {

	// The configuration that consists of the ScheduleExpression and the
	// DurationInMinutes details that specify the scheduling to record from a camera,
	// or local media file, onto the Edge Agent. If the ScheduleConfig is not provided
	// in this UploaderConfig , then the Edge Agent will upload at regular intervals
	// (every 1 hour).
	//
	// This member is required.
	ScheduleConfig *ScheduleConfig

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
