// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about an Amazon Kendra index.
func (c *Client) DescribeIndex(ctx context.Context, params *DescribeIndexInput, optFns ...func(*Options)) (*DescribeIndexOutput, error) {
	if params == nil {
		params = &DescribeIndexInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeIndex", params, optFns, c.addOperationDescribeIndexMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeIndexOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeIndexInput struct {

	// The identifier of the index you want to get information on.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type DescribeIndexOutput struct {

	// For Enterprise Edition indexes, you can choose to use additional capacity to
	// meet the needs of your application. This contains the capacity units used for
	// the index. A query or document storage capacity of zero indicates that the index
	// is using the default capacity. For more information on the default capacity for
	// an index and adjusting this, see [Adjusting capacity].
	//
	// [Adjusting capacity]: https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html
	CapacityUnits *types.CapacityUnitsConfiguration

	// The Unix timestamp when the index was created.
	CreatedAt *time.Time

	// The description for the index.
	Description *string

	// Configuration information for document metadata or fields. Document metadata
	// are fields or attributes associated with your documents. For example, the
	// company department name associated with each document.
	DocumentMetadataConfigurations []types.DocumentMetadataConfiguration

	// The Amazon Kendra edition used for the index. You decide the edition when you
	// create the index.
	Edition types.IndexEdition

	// When the Status field value is FAILED , the ErrorMessage field contains a
	// message that explains why.
	ErrorMessage *string

	// The identifier of the index.
	Id *string

	// Provides information about the number of FAQ questions and answers and the
	// number of text documents indexed.
	IndexStatistics *types.IndexStatistics

	// The name of the index.
	Name *string

	// The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra
	// permission to write to your Amazon CloudWatch logs.
	RoleArn *string

	// The identifier of the KMS customer master key (CMK) that is used to encrypt
	// your data. Amazon Kendra doesn't support asymmetric CMKs.
	ServerSideEncryptionConfiguration *types.ServerSideEncryptionConfiguration

	// The current status of the index. When the value is ACTIVE , the index is ready
	// for use. If the Status field value is FAILED , the ErrorMessage field contains
	// a message that explains why.
	Status types.IndexStatus

	// The Unix timestamp when the index was last updated.
	UpdatedAt *time.Time

	// The user context policy for the Amazon Kendra index.
	UserContextPolicy types.UserContextPolicy

	// Whether you have enabled IAM Identity Center identity source for your users and
	// groups. This is useful for user context filtering, where search results are
	// filtered based on the user or their group access to documents.
	UserGroupResolutionConfiguration *types.UserGroupResolutionConfiguration

	// The user token configuration for the Amazon Kendra index.
	UserTokenConfigurations []types.UserTokenConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeIndexMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeIndex{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeIndex{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeIndex"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeIndexValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeIndex(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeIndex(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeIndex",
	}
}
