// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about a FAQ.
func (c *Client) DescribeFaq(ctx context.Context, params *DescribeFaqInput, optFns ...func(*Options)) (*DescribeFaqOutput, error) {
	if params == nil {
		params = &DescribeFaqInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFaq", params, optFns, c.addOperationDescribeFaqMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFaqOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFaqInput struct {

	// The identifier of the FAQ you want to get information on.
	//
	// This member is required.
	Id *string

	// The identifier of the index for the FAQ.
	//
	// This member is required.
	IndexId *string

	noSmithyDocumentSerde
}

type DescribeFaqOutput struct {

	// The Unix timestamp when the FAQ was created.
	CreatedAt *time.Time

	// The description of the FAQ that you provided when it was created.
	Description *string

	// If the Status field is FAILED , the ErrorMessage field contains the reason why
	// the FAQ failed.
	ErrorMessage *string

	// The file format used for the FAQ file.
	FileFormat types.FaqFileFormat

	// The identifier of the FAQ.
	Id *string

	// The identifier of the index for the FAQ.
	IndexId *string

	// The code for a language. This shows a supported language for the FAQ document.
	// English is supported by default. For more information on supported languages,
	// including their codes, see [Adding documents in languages other than English].
	//
	// [Adding documents in languages other than English]: https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html
	LanguageCode *string

	// The name that you gave the FAQ when it was created.
	Name *string

	// The Amazon Resource Name (ARN) of the IAM role that provides access to the S3
	// bucket containing the FAQ file.
	RoleArn *string

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *types.S3Path

	// The status of the FAQ. It is ready to use when the status is ACTIVE .
	Status types.FaqStatus

	// The Unix timestamp when the FAQ was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFaqMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFaq{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFaq{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFaq"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeFaqValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFaq(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFaq(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFaq",
	}
}
