// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all data binding usages for computation models. This allows to identify
//
// where specific data bindings are being utilized across the computation models.
// This track dependencies between data sources and computation models.
func (c *Client) ListComputationModelDataBindingUsages(ctx context.Context, params *ListComputationModelDataBindingUsagesInput, optFns ...func(*Options)) (*ListComputationModelDataBindingUsagesOutput, error) {
	if params == nil {
		params = &ListComputationModelDataBindingUsagesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListComputationModelDataBindingUsages", params, optFns, c.addOperationListComputationModelDataBindingUsagesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListComputationModelDataBindingUsagesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListComputationModelDataBindingUsagesInput struct {

	// A filter used to limit the returned data binding usages based on specific data
	// binding values. You can filter by asset, asset model, asset property, or asset
	// model property to find all computation models using these specific data sources.
	//
	// This member is required.
	DataBindingValueFilter *types.DataBindingValueFilter

	// The maximum number of results returned for each paginated request.
	MaxResults *int32

	// The token used for the next set of paginated results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListComputationModelDataBindingUsagesOutput struct {

	// A list of summaries describing the data binding usages across computation
	// models. Each summary includes the computation model IDs and the matched data
	// binding details.
	//
	// This member is required.
	DataBindingUsageSummaries []types.ComputationModelDataBindingUsageSummary

	// The token for the next set of paginated results, or null if there are no
	// additional results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListComputationModelDataBindingUsagesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListComputationModelDataBindingUsages{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListComputationModelDataBindingUsages{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListComputationModelDataBindingUsages"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListComputationModelDataBindingUsagesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListComputationModelDataBindingUsagesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListComputationModelDataBindingUsages(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListComputationModelDataBindingUsagesPaginatorOptions is the paginator options
// for ListComputationModelDataBindingUsages
type ListComputationModelDataBindingUsagesPaginatorOptions struct {
	// The maximum number of results returned for each paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListComputationModelDataBindingUsagesPaginator is a paginator for
// ListComputationModelDataBindingUsages
type ListComputationModelDataBindingUsagesPaginator struct {
	options   ListComputationModelDataBindingUsagesPaginatorOptions
	client    ListComputationModelDataBindingUsagesAPIClient
	params    *ListComputationModelDataBindingUsagesInput
	nextToken *string
	firstPage bool
}

// NewListComputationModelDataBindingUsagesPaginator returns a new
// ListComputationModelDataBindingUsagesPaginator
func NewListComputationModelDataBindingUsagesPaginator(client ListComputationModelDataBindingUsagesAPIClient, params *ListComputationModelDataBindingUsagesInput, optFns ...func(*ListComputationModelDataBindingUsagesPaginatorOptions)) *ListComputationModelDataBindingUsagesPaginator {
	if params == nil {
		params = &ListComputationModelDataBindingUsagesInput{}
	}

	options := ListComputationModelDataBindingUsagesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListComputationModelDataBindingUsagesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListComputationModelDataBindingUsagesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListComputationModelDataBindingUsages page.
func (p *ListComputationModelDataBindingUsagesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListComputationModelDataBindingUsagesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListComputationModelDataBindingUsages(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opListComputationModelDataBindingUsagesMiddleware struct {
}

func (*endpointPrefix_opListComputationModelDataBindingUsagesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListComputationModelDataBindingUsagesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListComputationModelDataBindingUsagesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListComputationModelDataBindingUsagesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListComputationModelDataBindingUsagesAPIClient is a client that implements the
// ListComputationModelDataBindingUsages operation.
type ListComputationModelDataBindingUsagesAPIClient interface {
	ListComputationModelDataBindingUsages(context.Context, *ListComputationModelDataBindingUsagesInput, ...func(*Options)) (*ListComputationModelDataBindingUsagesOutput, error)
}

var _ ListComputationModelDataBindingUsagesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListComputationModelDataBindingUsages(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListComputationModelDataBindingUsages",
	}
}
