// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update the attributes and capabilities associated with a managed thing.
func (c *Client) UpdateManagedThing(ctx context.Context, params *UpdateManagedThingInput, optFns ...func(*Options)) (*UpdateManagedThingOutput, error) {
	if params == nil {
		params = &UpdateManagedThingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateManagedThing", params, optFns, c.addOperationUpdateManagedThingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateManagedThingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateManagedThingInput struct {

	// The id of the managed thing.
	//
	// This member is required.
	Identifier *string

	// The brand of the device.
	Brand *string

	// The capabilities of the device such as light bulb.
	Capabilities *string

	// A report of the capabilities for the managed thing.
	CapabilityReport *types.CapabilityReport

	// The updated capability schemas that define the functionality and features
	// supported by the managed thing.
	CapabilitySchemas []types.CapabilitySchemaItem

	// The classification of the managed thing such as light bulb or thermostat.
	Classification *string

	// The identifier of the credential for the managed thing.
	CredentialLockerId *string

	// The network mode for the hub-connected device.
	HubNetworkMode types.HubNetworkMode

	// The metadata for the managed thing.
	MetaData map[string]string

	// The model of the device.
	Model *string

	// The name of the managed thing representing the physical device.
	Name *string

	// Owner of the device, usually an indication of whom the device belongs to. This
	// value should not contain personal identifiable information.
	Owner *string

	// The serial number of the device.
	SerialNumber *string

	noSmithyDocumentSerde
}

type UpdateManagedThingOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateManagedThingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateManagedThing{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateManagedThing"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateManagedThingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateManagedThing(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateManagedThing(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateManagedThing",
	}
}
