// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of managed job templates.
func (c *Client) ListManagedJobTemplates(ctx context.Context, params *ListManagedJobTemplatesInput, optFns ...func(*Options)) (*ListManagedJobTemplatesOutput, error) {
	if params == nil {
		params = &ListManagedJobTemplatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedJobTemplates", params, optFns, c.addOperationListManagedJobTemplatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedJobTemplatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedJobTemplatesInput struct {

	// Maximum number of entries that can be returned.
	MaxResults *int32

	// The token to retrieve the next set of results.
	NextToken *string

	// An optional parameter for template name. If specified, only the versions of the
	// managed job templates that have the specified template name will be returned.
	TemplateName *string

	noSmithyDocumentSerde
}

type ListManagedJobTemplatesOutput struct {

	// A list of managed job templates that are returned.
	ManagedJobTemplates []types.ManagedJobTemplateSummary

	// The token to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedJobTemplatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedJobTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedJobTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedJobTemplates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedJobTemplates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListManagedJobTemplatesPaginatorOptions is the paginator options for
// ListManagedJobTemplates
type ListManagedJobTemplatesPaginatorOptions struct {
	// Maximum number of entries that can be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedJobTemplatesPaginator is a paginator for ListManagedJobTemplates
type ListManagedJobTemplatesPaginator struct {
	options   ListManagedJobTemplatesPaginatorOptions
	client    ListManagedJobTemplatesAPIClient
	params    *ListManagedJobTemplatesInput
	nextToken *string
	firstPage bool
}

// NewListManagedJobTemplatesPaginator returns a new
// ListManagedJobTemplatesPaginator
func NewListManagedJobTemplatesPaginator(client ListManagedJobTemplatesAPIClient, params *ListManagedJobTemplatesInput, optFns ...func(*ListManagedJobTemplatesPaginatorOptions)) *ListManagedJobTemplatesPaginator {
	if params == nil {
		params = &ListManagedJobTemplatesInput{}
	}

	options := ListManagedJobTemplatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedJobTemplatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedJobTemplatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedJobTemplates page.
func (p *ListManagedJobTemplatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedJobTemplatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedJobTemplates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedJobTemplatesAPIClient is a client that implements the
// ListManagedJobTemplates operation.
type ListManagedJobTemplatesAPIClient interface {
	ListManagedJobTemplates(context.Context, *ListManagedJobTemplatesInput, ...func(*Options)) (*ListManagedJobTemplatesOutput, error)
}

var _ ListManagedJobTemplatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedJobTemplates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedJobTemplates",
	}
}
